/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.klieber.phantomjs.locate.PhantomJsLocatorOptions;
import com.github.klieber.phantomjs.locate.RepositoryDetails;
import com.github.searls.jasmine.NullLog;
import com.github.searls.jasmine.driver.WebDriverFactory;
import com.github.searls.jasmine.format.JasmineResultLogger;
import com.github.searls.jasmine.io.RelativizesFilePaths;
import com.github.searls.jasmine.model.JasmineResult;
import com.github.searls.jasmine.mojo.AbstractJasmineMojo;
import com.github.searls.jasmine.mojo.Capability;
import com.github.searls.jasmine.mojo.PhantomJsOptions;
import com.github.searls.jasmine.runner.CreatesRunner;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerExecutor;
import com.github.searls.jasmine.server.ResourceHandlerConfigurator;
import com.github.searls.jasmine.server.ServerManager;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.jetty.server.Server;
import org.openqa.selenium.WebDriver;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class TestMojo
extends AbstractJasmineMojo {
    @Parameter(defaultValue="org.openqa.selenium.phantomjs.PhantomJSDriver")
    protected String webDriverClassName;
    @Parameter
    protected List<Capability> webDriverCapabilities = Collections.emptyList();
    @Deprecated
    @Parameter(defaultValue="FIREFOX_17")
    protected String browserVersion;
    @Parameter(defaultValue="documentation")
    protected String format;
    @Parameter(property="phantomjs", defaultValue="${phantomJs}")
    protected PhantomJsOptions phantomjs;
    @Parameter(defaultValue="TEST-jasmine.xml")
    protected String junitXmlReportFileName;
    @Parameter(property="keepServerAlive", defaultValue="false")
    protected boolean keepServerAlive;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    private RepositorySystem repositorySystem;
    private final RelativizesFilePaths relativizesFilePaths;

    @Inject
    public TestMojo(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
        this.relativizesFilePaths = new RelativizesFilePaths();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isSkipTests()) {
            super.execute();
        } else {
            this.getLog().info((CharSequence)"Skipping Jasmine Specs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        ServerManager serverManager = this.getServerManager();
        try {
            int port = serverManager.start();
            this.setPortProperty(port);
            this.getLog().info((CharSequence)"Executing Jasmine Specs");
            JasmineResult result = this.executeSpecs(new URL(this.uriScheme + "://" + this.serverHostname + ":" + port));
            this.logResults(result);
            this.throwAnySpecFailures(result);
        }
        finally {
            if (!this.keepServerAlive) {
                serverManager.stop();
            }
        }
    }

    private ServerManager getServerManager() throws MojoExecutionException {
        Log log = this.debug ? this.getLog() : new NullLog();
        CreatesRunner createsRunner = new CreatesRunner(this, log, this.specRunnerHtmlFileName, ReporterType.JsApiReporter);
        ResourceHandlerConfigurator configurator = new ResourceHandlerConfigurator(this, this.relativizesFilePaths, createsRunner);
        return new ServerManager(new Server(), this.getConnector(), configurator);
    }

    private void setPortProperty(int port) {
        this.mavenProject.getProperties().setProperty("jasmine.serverPort", String.valueOf(port));
    }

    private JasmineResult executeSpecs(URL runner) throws Exception {
        WebDriver driver = this.createDriver();
        JasmineResult result = new SpecRunnerExecutor().execute(runner, new File(this.jasmineTargetDir, this.junitXmlReportFileName), driver, this.timeout, this.debug, this.getLog(), this.format);
        return result;
    }

    private WebDriver createDriver() throws Exception {
        RepositoryDetails details = new RepositoryDetails();
        details.setRemoteRepositories(this.remoteRepositories);
        details.setRepositorySystem(this.repositorySystem);
        details.setRepositorySystemSession(this.repositorySystemSession);
        this.configure(this.mavenSession.getUserProperties());
        WebDriverFactory factory = new WebDriverFactory();
        factory.setWebDriverCapabilities(this.webDriverCapabilities);
        factory.setWebDriverClassName(this.webDriverClassName);
        factory.setDebug(this.debug);
        factory.setBrowserVersion(this.browserVersion);
        factory.setPhantomJsLocatorOptions(this.phantomjs);
        factory.setRepositoryDetails(details);
        return factory.createWebDriver();
    }

    private void configure(Properties properties) {
        this.phantomjs.setVersion(properties.getProperty("phantomjs.version", this.phantomjs.getVersion()));
        this.phantomjs.setSource(PhantomJsLocatorOptions.Source.valueOf((String)properties.getProperty("phantomjs.source", this.phantomjs.getSource().toString())));
        this.phantomjs.setOutputDirectory(new File(properties.getProperty("phantomjs.outputDirectory", this.phantomjs.getOutputDirectory().toString())));
        this.phantomjs.setBaseUrl(properties.getProperty("phantomjs.baseUrl", this.phantomjs.getBaseUrl()));
        this.phantomjs.setCheckSystemPath(this.configureBoolean(properties, "phantomjs.checkSystemPath", this.phantomjs.isCheckSystemPath()));
        this.phantomjs.setEnforceVersion(properties.getProperty("phantomjs.enforceVersion", this.phantomjs.getEnforceVersion()));
    }

    private boolean configureBoolean(Properties properties, String property, boolean defaultValue) {
        return Boolean.parseBoolean(properties.getProperty(property, Boolean.toString(defaultValue)));
    }

    private void logResults(JasmineResult result) {
        JasmineResultLogger resultLogger = new JasmineResultLogger();
        resultLogger.setLog(this.getLog());
        resultLogger.log(result);
    }

    private void throwAnySpecFailures(JasmineResult result) throws MojoFailureException {
        if (this.haltOnFailure && !result.didPass()) {
            throw new MojoFailureException("There were Jasmine spec failures.");
        }
    }
}

