/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.model.FileSystemReporter;
import com.github.searls.jasmine.model.Reporter;
import com.github.searls.jasmine.mojo.ResourceRetriever;
import com.google.inject.Inject;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ReporterRetriever {
    public static final String STANDARD_REPORTER = "/lib/buildReport.js";
    private static final String STANDARD_REPORTER_KEY = "STANDARD";
    private static final String JUNIT_XML_FILENAME = "TEST-jasmine.xml";
    private static final String JUNIT_XML_KEY = "JUNIT_XML";
    public static final String JUNIT_XML_REPORTER = "lib/createJunitXml.js";
    private final ResourceRetriever resourceRetriever;

    @Inject
    public ReporterRetriever(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    List<FileSystemReporter> retrieveFileSystemReporters(List<FileSystemReporter> reporters, File targetDirectory, MavenProject mavenProject) throws MojoExecutionException {
        if (reporters.isEmpty()) {
            reporters.add(new FileSystemReporter(JUNIT_XML_FILENAME, JUNIT_XML_KEY));
        }
        for (FileSystemReporter reporter : reporters) {
            if (JUNIT_XML_KEY.equals(reporter.reporterName)) {
                reporter.reporterName = JUNIT_XML_REPORTER;
            }
            reporter.reporterFile = this.getReporter(reporter.reporterName, mavenProject);
            reporter.file = new File(targetDirectory, reporter.fileName);
        }
        return reporters;
    }

    List<Reporter> retrieveReporters(List<Reporter> reporters, MavenProject mavenProject) throws MojoExecutionException {
        if (reporters.isEmpty()) {
            reporters.add(new Reporter(STANDARD_REPORTER_KEY));
        }
        for (Reporter reporter : reporters) {
            if (STANDARD_REPORTER_KEY.equals(reporter.reporterName)) {
                reporter.reporterName = STANDARD_REPORTER;
            }
            reporter.reporterFile = this.getReporter(reporter.reporterName, mavenProject);
        }
        return reporters;
    }

    private File getReporter(String reporter, MavenProject mavenProject) throws MojoExecutionException {
        return this.resourceRetriever.getResourceAsFile("reporter", reporter, mavenProject);
    }
}

