package com.github.searls.jasmine.config;

import com.github.searls.jasmine.mojo.Capability;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link WebDriverConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWebDriverConfiguration.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "WebDriverConfiguration"})
@Immutable
@CheckReturnValue
public final class ImmutableWebDriverConfiguration
    implements WebDriverConfiguration {
  private final boolean debug;
  private final String webDriverClassName;
  private final ImmutableList<Capability> webDriverCapabilities;

  private ImmutableWebDriverConfiguration(
      boolean debug,
      String webDriverClassName,
      ImmutableList<Capability> webDriverCapabilities) {
    this.debug = debug;
    this.webDriverClassName = webDriverClassName;
    this.webDriverCapabilities = webDriverCapabilities;
  }

  /**
   * @return The value of the {@code debug} attribute
   */
  @Override
  public boolean isDebug() {
    return debug;
  }

  /**
   * @return The value of the {@code webDriverClassName} attribute
   */
  @Override
  public String getWebDriverClassName() {
    return webDriverClassName;
  }

  /**
   * @return The value of the {@code webDriverCapabilities} attribute
   */
  @Override
  public ImmutableList<Capability> getWebDriverCapabilities() {
    return webDriverCapabilities;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebDriverConfiguration#isDebug() debug} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for debug
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebDriverConfiguration withDebug(boolean value) {
    if (this.debug == value) return this;
    return new ImmutableWebDriverConfiguration(value, this.webDriverClassName, this.webDriverCapabilities);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebDriverConfiguration#getWebDriverClassName() webDriverClassName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for webDriverClassName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebDriverConfiguration withWebDriverClassName(String value) {
    if (this.webDriverClassName.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "webDriverClassName");
    return new ImmutableWebDriverConfiguration(this.debug, newValue, this.webDriverCapabilities);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebDriverConfiguration withWebDriverCapabilities(Capability... elements) {
    ImmutableList<Capability> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWebDriverConfiguration(this.debug, this.webDriverClassName, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of webDriverCapabilities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebDriverConfiguration withWebDriverCapabilities(Iterable<? extends Capability> elements) {
    if (this.webDriverCapabilities == elements) return this;
    ImmutableList<Capability> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWebDriverConfiguration(this.debug, this.webDriverClassName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWebDriverConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWebDriverConfiguration
        && equalTo((ImmutableWebDriverConfiguration) another);
  }

  private boolean equalTo(ImmutableWebDriverConfiguration another) {
    return debug == another.debug
        && webDriverClassName.equals(another.webDriverClassName)
        && webDriverCapabilities.equals(another.webDriverCapabilities);
  }

  /**
   * Computes a hash code from attributes: {@code debug}, {@code webDriverClassName}, {@code webDriverCapabilities}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Booleans.hashCode(debug);
    h += (h << 5) + webDriverClassName.hashCode();
    h += (h << 5) + webDriverCapabilities.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WebDriverConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WebDriverConfiguration")
        .omitNullValues()
        .add("debug", debug)
        .add("webDriverClassName", webDriverClassName)
        .add("webDriverCapabilities", webDriverCapabilities)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link WebDriverConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebDriverConfiguration instance
   */
  public static ImmutableWebDriverConfiguration copyOf(WebDriverConfiguration instance) {
    if (instance instanceof ImmutableWebDriverConfiguration) {
      return (ImmutableWebDriverConfiguration) instance;
    }
    return ImmutableWebDriverConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWebDriverConfiguration ImmutableWebDriverConfiguration}.
   * @return A new ImmutableWebDriverConfiguration builder
   */
  public static ImmutableWebDriverConfiguration.Builder builder() {
    return new ImmutableWebDriverConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWebDriverConfiguration ImmutableWebDriverConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEBUG = 0x1L;
    private static final long INIT_BIT_WEB_DRIVER_CLASS_NAME = 0x2L;
    private long initBits = 0x3L;

    private boolean debug;
    private @Nullable String webDriverClassName;
    private ImmutableList.Builder<Capability> webDriverCapabilities = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WebDriverConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WebDriverConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      debug(instance.isDebug());
      webDriverClassName(instance.getWebDriverClassName());
      addAllWebDriverCapabilities(instance.getWebDriverCapabilities());
      return this;
    }

    /**
     * Initializes the value for the {@link WebDriverConfiguration#isDebug() debug} attribute.
     * @param debug The value for debug 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder debug(boolean debug) {
      this.debug = debug;
      initBits &= ~INIT_BIT_DEBUG;
      return this;
    }

    /**
     * Initializes the value for the {@link WebDriverConfiguration#getWebDriverClassName() webDriverClassName} attribute.
     * @param webDriverClassName The value for webDriverClassName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder webDriverClassName(String webDriverClassName) {
      this.webDriverClassName = Objects.requireNonNull(webDriverClassName, "webDriverClassName");
      initBits &= ~INIT_BIT_WEB_DRIVER_CLASS_NAME;
      return this;
    }

    /**
     * Adds one element to {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} list.
     * @param element A webDriverCapabilities element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWebDriverCapabilities(Capability element) {
      this.webDriverCapabilities.add(element);
      return this;
    }

    /**
     * Adds elements to {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} list.
     * @param elements An array of webDriverCapabilities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWebDriverCapabilities(Capability... elements) {
      this.webDriverCapabilities.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} list.
     * @param elements An iterable of webDriverCapabilities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder webDriverCapabilities(Iterable<? extends Capability> elements) {
      this.webDriverCapabilities = ImmutableList.builder();
      return addAllWebDriverCapabilities(elements);
    }

    /**
     * Adds elements to {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} list.
     * @param elements An iterable of webDriverCapabilities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllWebDriverCapabilities(Iterable<? extends Capability> elements) {
      this.webDriverCapabilities.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableWebDriverConfiguration ImmutableWebDriverConfiguration}.
     * @return An immutable instance of WebDriverConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWebDriverConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWebDriverConfiguration(debug, webDriverClassName, webDriverCapabilities.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_DEBUG) != 0) attributes.add("debug");
      if ((initBits & INIT_BIT_WEB_DRIVER_CLASS_NAME) != 0) attributes.add("webDriverClassName");
      return "Cannot build WebDriverConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
