package com.github.searls.jasmine.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractJasmineResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJasmineResult.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractJasmineResult"})
@Immutable
@CheckReturnValue
public final class ImmutableJasmineResult extends AbstractJasmineResult {
  private final String details;

  private ImmutableJasmineResult(String details) {
    this.details = details;
  }

  /**
   * @return The value of the {@code details} attribute
   */
  @Override
  public String getDetails() {
    return details;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractJasmineResult#getDetails() details} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for details
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineResult withDetails(String value) {
    if (this.details.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "details");
    return new ImmutableJasmineResult(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJasmineResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJasmineResult
        && equalTo((ImmutableJasmineResult) another);
  }

  private boolean equalTo(ImmutableJasmineResult another) {
    return details.equals(another.details);
  }

  /**
   * Computes a hash code from attributes: {@code details}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + details.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JasmineResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JasmineResult")
        .omitNullValues()
        .add("details", details)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractJasmineResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JasmineResult instance
   */
  public static ImmutableJasmineResult copyOf(AbstractJasmineResult instance) {
    if (instance instanceof ImmutableJasmineResult) {
      return (ImmutableJasmineResult) instance;
    }
    return ImmutableJasmineResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJasmineResult ImmutableJasmineResult}.
   * @return A new ImmutableJasmineResult builder
   */
  public static ImmutableJasmineResult.Builder builder() {
    return new ImmutableJasmineResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJasmineResult ImmutableJasmineResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DETAILS = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String details;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.searls.jasmine.model.JasmineResult} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JasmineResult instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.github.searls.jasmine.model.AbstractJasmineResult} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractJasmineResult instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof JasmineResult) {
        JasmineResult instance = (JasmineResult) object;
        details(instance.getDetails());
      }
    }

    /**
     * Initializes the value for the {@link AbstractJasmineResult#getDetails() details} attribute.
     * @param details The value for details 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder details(String details) {
      this.details = Objects.requireNonNull(details, "details");
      initBits &= ~INIT_BIT_DETAILS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJasmineResult ImmutableJasmineResult}.
     * @return An immutable instance of JasmineResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJasmineResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJasmineResult(details);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_DETAILS) != 0) attributes.add("details");
      return "Cannot build JasmineResult, some of required attributes are not set " + attributes;
    }
  }
}
