package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.io.scripts.ScriptResolver;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link HtmlGeneratorConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHtmlGeneratorConfiguration.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "HtmlGeneratorConfiguration"})
@Immutable
@CheckReturnValue
public final class ImmutableHtmlGeneratorConfiguration
    extends HtmlGeneratorConfiguration {
  private final String sourceEncoding;
  private final ReporterType reporterType;
  private final String runnerTemplate;
  private final SpecRunnerTemplate specRunnerTemplate;
  private final ScriptResolver scriptResolver;
  private final String customRunnerConfiguration;
  private final int autoRefreshInterval;

  private ImmutableHtmlGeneratorConfiguration(
      String sourceEncoding,
      ReporterType reporterType,
      String runnerTemplate,
      SpecRunnerTemplate specRunnerTemplate,
      ScriptResolver scriptResolver,
      String customRunnerConfiguration,
      int autoRefreshInterval) {
    this.sourceEncoding = sourceEncoding;
    this.reporterType = reporterType;
    this.runnerTemplate = runnerTemplate;
    this.specRunnerTemplate = specRunnerTemplate;
    this.scriptResolver = scriptResolver;
    this.customRunnerConfiguration = customRunnerConfiguration;
    this.autoRefreshInterval = autoRefreshInterval;
  }

  /**
   * @return The value of the {@code sourceEncoding} attribute
   */
  @Override
  public String getSourceEncoding() {
    return sourceEncoding;
  }

  /**
   * @return The value of the {@code reporterType} attribute
   */
  @Override
  public ReporterType getReporterType() {
    return reporterType;
  }

  /**
   * @return The value of the {@code runnerTemplate} attribute
   */
  @Override
  public String getRunnerTemplate() {
    return runnerTemplate;
  }

  /**
   * @return The value of the {@code specRunnerTemplate} attribute
   */
  @Override
  public SpecRunnerTemplate getSpecRunnerTemplate() {
    return specRunnerTemplate;
  }

  /**
   * @return The value of the {@code scriptResolver} attribute
   */
  @Override
  public ScriptResolver getScriptResolver() {
    return scriptResolver;
  }

  /**
   * @return The value of the {@code customRunnerConfiguration} attribute
   */
  @Override
  public String getCustomRunnerConfiguration() {
    return customRunnerConfiguration;
  }

  /**
   * @return The value of the {@code autoRefreshInterval} attribute
   */
  @Override
  public int getAutoRefreshInterval() {
    return autoRefreshInterval;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HtmlGeneratorConfiguration#getSourceEncoding() sourceEncoding} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sourceEncoding
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHtmlGeneratorConfiguration withSourceEncoding(String value) {
    if (this.sourceEncoding.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "sourceEncoding");
    return new ImmutableHtmlGeneratorConfiguration(
        newValue,
        this.reporterType,
        this.runnerTemplate,
        this.specRunnerTemplate,
        this.scriptResolver,
        this.customRunnerConfiguration,
        this.autoRefreshInterval);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HtmlGeneratorConfiguration#getReporterType() reporterType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reporterType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHtmlGeneratorConfiguration withReporterType(ReporterType value) {
    if (this.reporterType == value) return this;
    ReporterType newValue = Objects.requireNonNull(value, "reporterType");
    return new ImmutableHtmlGeneratorConfiguration(
        this.sourceEncoding,
        newValue,
        this.runnerTemplate,
        this.specRunnerTemplate,
        this.scriptResolver,
        this.customRunnerConfiguration,
        this.autoRefreshInterval);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HtmlGeneratorConfiguration#getRunnerTemplate() runnerTemplate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for runnerTemplate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHtmlGeneratorConfiguration withRunnerTemplate(String value) {
    if (this.runnerTemplate.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "runnerTemplate");
    return new ImmutableHtmlGeneratorConfiguration(
        this.sourceEncoding,
        this.reporterType,
        newValue,
        this.specRunnerTemplate,
        this.scriptResolver,
        this.customRunnerConfiguration,
        this.autoRefreshInterval);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HtmlGeneratorConfiguration#getSpecRunnerTemplate() specRunnerTemplate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specRunnerTemplate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHtmlGeneratorConfiguration withSpecRunnerTemplate(SpecRunnerTemplate value) {
    if (this.specRunnerTemplate == value) return this;
    SpecRunnerTemplate newValue = Objects.requireNonNull(value, "specRunnerTemplate");
    return new ImmutableHtmlGeneratorConfiguration(
        this.sourceEncoding,
        this.reporterType,
        this.runnerTemplate,
        newValue,
        this.scriptResolver,
        this.customRunnerConfiguration,
        this.autoRefreshInterval);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HtmlGeneratorConfiguration#getScriptResolver() scriptResolver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scriptResolver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHtmlGeneratorConfiguration withScriptResolver(ScriptResolver value) {
    if (this.scriptResolver == value) return this;
    ScriptResolver newValue = Objects.requireNonNull(value, "scriptResolver");
    return new ImmutableHtmlGeneratorConfiguration(
        this.sourceEncoding,
        this.reporterType,
        this.runnerTemplate,
        this.specRunnerTemplate,
        newValue,
        this.customRunnerConfiguration,
        this.autoRefreshInterval);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HtmlGeneratorConfiguration#getCustomRunnerConfiguration() customRunnerConfiguration} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for customRunnerConfiguration
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHtmlGeneratorConfiguration withCustomRunnerConfiguration(String value) {
    if (this.customRunnerConfiguration.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "customRunnerConfiguration");
    return new ImmutableHtmlGeneratorConfiguration(
        this.sourceEncoding,
        this.reporterType,
        this.runnerTemplate,
        this.specRunnerTemplate,
        this.scriptResolver,
        newValue,
        this.autoRefreshInterval);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HtmlGeneratorConfiguration#getAutoRefreshInterval() autoRefreshInterval} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autoRefreshInterval
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHtmlGeneratorConfiguration withAutoRefreshInterval(int value) {
    if (this.autoRefreshInterval == value) return this;
    return new ImmutableHtmlGeneratorConfiguration(
        this.sourceEncoding,
        this.reporterType,
        this.runnerTemplate,
        this.specRunnerTemplate,
        this.scriptResolver,
        this.customRunnerConfiguration,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHtmlGeneratorConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHtmlGeneratorConfiguration
        && equalTo((ImmutableHtmlGeneratorConfiguration) another);
  }

  private boolean equalTo(ImmutableHtmlGeneratorConfiguration another) {
    return sourceEncoding.equals(another.sourceEncoding)
        && reporterType.equals(another.reporterType)
        && runnerTemplate.equals(another.runnerTemplate)
        && specRunnerTemplate.equals(another.specRunnerTemplate)
        && scriptResolver.equals(another.scriptResolver)
        && customRunnerConfiguration.equals(another.customRunnerConfiguration)
        && autoRefreshInterval == another.autoRefreshInterval;
  }

  /**
   * Computes a hash code from attributes: {@code sourceEncoding}, {@code reporterType}, {@code runnerTemplate}, {@code specRunnerTemplate}, {@code scriptResolver}, {@code customRunnerConfiguration}, {@code autoRefreshInterval}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + sourceEncoding.hashCode();
    h += (h << 5) + reporterType.hashCode();
    h += (h << 5) + runnerTemplate.hashCode();
    h += (h << 5) + specRunnerTemplate.hashCode();
    h += (h << 5) + scriptResolver.hashCode();
    h += (h << 5) + customRunnerConfiguration.hashCode();
    h += (h << 5) + autoRefreshInterval;
    return h;
  }

  /**
   * Prints the immutable value {@code HtmlGeneratorConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HtmlGeneratorConfiguration")
        .omitNullValues()
        .add("sourceEncoding", sourceEncoding)
        .add("reporterType", reporterType)
        .add("runnerTemplate", runnerTemplate)
        .add("specRunnerTemplate", specRunnerTemplate)
        .add("scriptResolver", scriptResolver)
        .add("customRunnerConfiguration", customRunnerConfiguration)
        .add("autoRefreshInterval", autoRefreshInterval)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link HtmlGeneratorConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HtmlGeneratorConfiguration instance
   */
  public static ImmutableHtmlGeneratorConfiguration copyOf(HtmlGeneratorConfiguration instance) {
    if (instance instanceof ImmutableHtmlGeneratorConfiguration) {
      return (ImmutableHtmlGeneratorConfiguration) instance;
    }
    return ImmutableHtmlGeneratorConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHtmlGeneratorConfiguration ImmutableHtmlGeneratorConfiguration}.
   * @return A new ImmutableHtmlGeneratorConfiguration builder
   */
  public static ImmutableHtmlGeneratorConfiguration.Builder builder() {
    return new ImmutableHtmlGeneratorConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHtmlGeneratorConfiguration ImmutableHtmlGeneratorConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOURCE_ENCODING = 0x1L;
    private static final long INIT_BIT_REPORTER_TYPE = 0x2L;
    private static final long INIT_BIT_RUNNER_TEMPLATE = 0x4L;
    private static final long INIT_BIT_SPEC_RUNNER_TEMPLATE = 0x8L;
    private static final long INIT_BIT_SCRIPT_RESOLVER = 0x10L;
    private static final long INIT_BIT_CUSTOM_RUNNER_CONFIGURATION = 0x20L;
    private static final long INIT_BIT_AUTO_REFRESH_INTERVAL = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String sourceEncoding;
    private @Nullable ReporterType reporterType;
    private @Nullable String runnerTemplate;
    private @Nullable SpecRunnerTemplate specRunnerTemplate;
    private @Nullable ScriptResolver scriptResolver;
    private @Nullable String customRunnerConfiguration;
    private int autoRefreshInterval;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HtmlGeneratorConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HtmlGeneratorConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      sourceEncoding(instance.getSourceEncoding());
      reporterType(instance.getReporterType());
      runnerTemplate(instance.getRunnerTemplate());
      specRunnerTemplate(instance.getSpecRunnerTemplate());
      scriptResolver(instance.getScriptResolver());
      customRunnerConfiguration(instance.getCustomRunnerConfiguration());
      autoRefreshInterval(instance.getAutoRefreshInterval());
      return this;
    }

    /**
     * Initializes the value for the {@link HtmlGeneratorConfiguration#getSourceEncoding() sourceEncoding} attribute.
     * @param sourceEncoding The value for sourceEncoding 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sourceEncoding(String sourceEncoding) {
      this.sourceEncoding = Objects.requireNonNull(sourceEncoding, "sourceEncoding");
      initBits &= ~INIT_BIT_SOURCE_ENCODING;
      return this;
    }

    /**
     * Initializes the value for the {@link HtmlGeneratorConfiguration#getReporterType() reporterType} attribute.
     * @param reporterType The value for reporterType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reporterType(ReporterType reporterType) {
      this.reporterType = Objects.requireNonNull(reporterType, "reporterType");
      initBits &= ~INIT_BIT_REPORTER_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link HtmlGeneratorConfiguration#getRunnerTemplate() runnerTemplate} attribute.
     * @param runnerTemplate The value for runnerTemplate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder runnerTemplate(String runnerTemplate) {
      this.runnerTemplate = Objects.requireNonNull(runnerTemplate, "runnerTemplate");
      initBits &= ~INIT_BIT_RUNNER_TEMPLATE;
      return this;
    }

    /**
     * Initializes the value for the {@link HtmlGeneratorConfiguration#getSpecRunnerTemplate() specRunnerTemplate} attribute.
     * @param specRunnerTemplate The value for specRunnerTemplate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder specRunnerTemplate(SpecRunnerTemplate specRunnerTemplate) {
      this.specRunnerTemplate = Objects.requireNonNull(specRunnerTemplate, "specRunnerTemplate");
      initBits &= ~INIT_BIT_SPEC_RUNNER_TEMPLATE;
      return this;
    }

    /**
     * Initializes the value for the {@link HtmlGeneratorConfiguration#getScriptResolver() scriptResolver} attribute.
     * @param scriptResolver The value for scriptResolver 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder scriptResolver(ScriptResolver scriptResolver) {
      this.scriptResolver = Objects.requireNonNull(scriptResolver, "scriptResolver");
      initBits &= ~INIT_BIT_SCRIPT_RESOLVER;
      return this;
    }

    /**
     * Initializes the value for the {@link HtmlGeneratorConfiguration#getCustomRunnerConfiguration() customRunnerConfiguration} attribute.
     * @param customRunnerConfiguration The value for customRunnerConfiguration 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customRunnerConfiguration(String customRunnerConfiguration) {
      this.customRunnerConfiguration = Objects.requireNonNull(customRunnerConfiguration, "customRunnerConfiguration");
      initBits &= ~INIT_BIT_CUSTOM_RUNNER_CONFIGURATION;
      return this;
    }

    /**
     * Initializes the value for the {@link HtmlGeneratorConfiguration#getAutoRefreshInterval() autoRefreshInterval} attribute.
     * @param autoRefreshInterval The value for autoRefreshInterval 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder autoRefreshInterval(int autoRefreshInterval) {
      this.autoRefreshInterval = autoRefreshInterval;
      initBits &= ~INIT_BIT_AUTO_REFRESH_INTERVAL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHtmlGeneratorConfiguration ImmutableHtmlGeneratorConfiguration}.
     * @return An immutable instance of HtmlGeneratorConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHtmlGeneratorConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHtmlGeneratorConfiguration(
          sourceEncoding,
          reporterType,
          runnerTemplate,
          specRunnerTemplate,
          scriptResolver,
          customRunnerConfiguration,
          autoRefreshInterval);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_SOURCE_ENCODING) != 0) attributes.add("sourceEncoding");
      if ((initBits & INIT_BIT_REPORTER_TYPE) != 0) attributes.add("reporterType");
      if ((initBits & INIT_BIT_RUNNER_TEMPLATE) != 0) attributes.add("runnerTemplate");
      if ((initBits & INIT_BIT_SPEC_RUNNER_TEMPLATE) != 0) attributes.add("specRunnerTemplate");
      if ((initBits & INIT_BIT_SCRIPT_RESOLVER) != 0) attributes.add("scriptResolver");
      if ((initBits & INIT_BIT_CUSTOM_RUNNER_CONFIGURATION) != 0) attributes.add("customRunnerConfiguration");
      if ((initBits & INIT_BIT_AUTO_REFRESH_INTERVAL) != 0) attributes.add("autoRefreshInterval");
      return "Cannot build HtmlGeneratorConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
