/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.config;

import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.model.FileSystemReporter;
import com.github.searls.jasmine.model.Reporter;
import com.github.searls.jasmine.model.ScriptSearch;
import com.github.searls.jasmine.mojo.Context;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerTemplate;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableJasmineConfiguration
extends JasmineConfiguration {
    private final File basedir;
    private final File jasmineTargetDir;
    private final String srcDirectoryName;
    private final String specDirectoryName;
    private final ScriptSearch sources;
    private final ScriptSearch specs;
    private final List<Context> contexts;
    private final List<String> preloadSources;
    private final String sourceEncoding;
    private final SpecRunnerTemplate specRunnerTemplate;
    @Nullable
    private final File customRunnerTemplate;
    @Nullable
    private final File customRunnerConfiguration;
    private final String specRunnerHtmlFileName;
    private final ReporterType reporterType;
    private final List<Reporter> reporters;
    private final List<FileSystemReporter> fileSystemReporters;
    private final int autoRefreshInterval;
    private final ClassLoader projectClassLoader;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableJasmineConfiguration(Builder builder) {
        this.basedir = builder.basedir;
        this.jasmineTargetDir = builder.jasmineTargetDir;
        this.sources = builder.sources;
        this.specs = builder.specs;
        this.contexts = ImmutableJasmineConfiguration.createUnmodifiableList(true, builder.contexts);
        this.preloadSources = ImmutableJasmineConfiguration.createUnmodifiableList(true, builder.preloadSources);
        this.customRunnerTemplate = builder.customRunnerTemplate;
        this.customRunnerConfiguration = builder.customRunnerConfiguration;
        if (builder.srcDirectoryName != null) {
            this.initShim.srcDirectoryName(builder.srcDirectoryName);
        }
        if (builder.specDirectoryName != null) {
            this.initShim.specDirectoryName(builder.specDirectoryName);
        }
        if (builder.sourceEncoding != null) {
            this.initShim.sourceEncoding(builder.sourceEncoding);
        }
        if (builder.specRunnerTemplate != null) {
            this.initShim.specRunnerTemplate(builder.specRunnerTemplate);
        }
        if (builder.specRunnerHtmlFileName != null) {
            this.initShim.specRunnerHtmlFileName(builder.specRunnerHtmlFileName);
        }
        if (builder.reporterType != null) {
            this.initShim.reporterType(builder.reporterType);
        }
        if (builder.reportersIsSet()) {
            this.initShim.reporters(ImmutableJasmineConfiguration.createUnmodifiableList(true, builder.reporters));
        }
        if (builder.fileSystemReportersIsSet()) {
            this.initShim.fileSystemReporters(ImmutableJasmineConfiguration.createUnmodifiableList(true, builder.fileSystemReporters));
        }
        if (builder.autoRefreshIntervalIsSet()) {
            this.initShim.autoRefreshInterval(builder.autoRefreshInterval);
        }
        if (builder.projectClassLoader != null) {
            this.initShim.projectClassLoader(builder.projectClassLoader);
        }
        this.srcDirectoryName = this.initShim.getSrcDirectoryName();
        this.specDirectoryName = this.initShim.getSpecDirectoryName();
        this.sourceEncoding = this.initShim.getSourceEncoding();
        this.specRunnerTemplate = this.initShim.getSpecRunnerTemplate();
        this.specRunnerHtmlFileName = this.initShim.getSpecRunnerHtmlFileName();
        this.reporterType = this.initShim.getReporterType();
        this.reporters = this.initShim.getReporters();
        this.fileSystemReporters = this.initShim.getFileSystemReporters();
        this.autoRefreshInterval = this.initShim.getAutoRefreshInterval();
        this.projectClassLoader = this.initShim.getProjectClassLoader();
        this.initShim = null;
    }

    private ImmutableJasmineConfiguration(File basedir, File jasmineTargetDir, String srcDirectoryName, String specDirectoryName, ScriptSearch sources, ScriptSearch specs, List<Context> contexts, List<String> preloadSources, String sourceEncoding, SpecRunnerTemplate specRunnerTemplate, @Nullable File customRunnerTemplate, @Nullable File customRunnerConfiguration, String specRunnerHtmlFileName, ReporterType reporterType, List<Reporter> reporters, List<FileSystemReporter> fileSystemReporters, int autoRefreshInterval, ClassLoader projectClassLoader) {
        this.basedir = basedir;
        this.jasmineTargetDir = jasmineTargetDir;
        this.srcDirectoryName = srcDirectoryName;
        this.specDirectoryName = specDirectoryName;
        this.sources = sources;
        this.specs = specs;
        this.contexts = contexts;
        this.preloadSources = preloadSources;
        this.sourceEncoding = sourceEncoding;
        this.specRunnerTemplate = specRunnerTemplate;
        this.customRunnerTemplate = customRunnerTemplate;
        this.customRunnerConfiguration = customRunnerConfiguration;
        this.specRunnerHtmlFileName = specRunnerHtmlFileName;
        this.reporterType = reporterType;
        this.reporters = reporters;
        this.fileSystemReporters = fileSystemReporters;
        this.autoRefreshInterval = autoRefreshInterval;
        this.projectClassLoader = projectClassLoader;
        this.initShim = null;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public File getJasmineTargetDir() {
        return this.jasmineTargetDir;
    }

    @Override
    public String getSrcDirectoryName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSrcDirectoryName() : this.srcDirectoryName;
    }

    @Override
    public String getSpecDirectoryName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSpecDirectoryName() : this.specDirectoryName;
    }

    @Override
    public ScriptSearch getSources() {
        return this.sources;
    }

    @Override
    public ScriptSearch getSpecs() {
        return this.specs;
    }

    @Override
    public List<Context> getContexts() {
        return this.contexts;
    }

    @Override
    public List<String> getPreloadSources() {
        return this.preloadSources;
    }

    @Override
    public String getSourceEncoding() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSourceEncoding() : this.sourceEncoding;
    }

    @Override
    public SpecRunnerTemplate getSpecRunnerTemplate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSpecRunnerTemplate() : this.specRunnerTemplate;
    }

    @Override
    public Optional<File> getCustomRunnerTemplate() {
        return Optional.ofNullable(this.customRunnerTemplate);
    }

    @Override
    public Optional<File> getCustomRunnerConfiguration() {
        return Optional.ofNullable(this.customRunnerConfiguration);
    }

    @Override
    public String getSpecRunnerHtmlFileName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSpecRunnerHtmlFileName() : this.specRunnerHtmlFileName;
    }

    @Override
    public ReporterType getReporterType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getReporterType() : this.reporterType;
    }

    @Override
    public List<Reporter> getReporters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getReporters() : this.reporters;
    }

    @Override
    public List<FileSystemReporter> getFileSystemReporters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFileSystemReporters() : this.fileSystemReporters;
    }

    @Override
    public int getAutoRefreshInterval() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAutoRefreshInterval() : this.autoRefreshInterval;
    }

    @Override
    public ClassLoader getProjectClassLoader() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getProjectClassLoader() : this.projectClassLoader;
    }

    public final ImmutableJasmineConfiguration withBasedir(File value) {
        if (this.basedir == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "basedir");
        return new ImmutableJasmineConfiguration(newValue, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withJasmineTargetDir(File value) {
        if (this.jasmineTargetDir == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "jasmineTargetDir");
        return new ImmutableJasmineConfiguration(this.basedir, newValue, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withSrcDirectoryName(String value) {
        if (this.srcDirectoryName.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "srcDirectoryName");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, newValue, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withSpecDirectoryName(String value) {
        if (this.specDirectoryName.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "specDirectoryName");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, newValue, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withSources(ScriptSearch value) {
        if (this.sources == value) {
            return this;
        }
        ScriptSearch newValue = Objects.requireNonNull(value, "sources");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, newValue, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withSpecs(ScriptSearch value) {
        if (this.specs == value) {
            return this;
        }
        ScriptSearch newValue = Objects.requireNonNull(value, "specs");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, newValue, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withContexts(Context ... elements) {
        List<Context> newValue = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, newValue, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withContexts(Iterable<? extends Context> elements) {
        if (this.contexts == elements) {
            return this;
        }
        List<Context> newValue = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(elements, true, false));
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, newValue, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withPreloadSources(String ... elements) {
        List<String> newValue = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, newValue, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withPreloadSources(Iterable<String> elements) {
        if (this.preloadSources == elements) {
            return this;
        }
        List<String> newValue = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(elements, true, false));
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, newValue, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withSourceEncoding(String value) {
        if (this.sourceEncoding.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "sourceEncoding");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, newValue, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withSpecRunnerTemplate(SpecRunnerTemplate value) {
        if (this.specRunnerTemplate == value) {
            return this;
        }
        SpecRunnerTemplate newValue = Objects.requireNonNull(value, "specRunnerTemplate");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, newValue, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withCustomRunnerTemplate(File value) {
        File newValue = Objects.requireNonNull(value, "customRunnerTemplate");
        if (this.customRunnerTemplate == newValue) {
            return this;
        }
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, newValue, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withCustomRunnerTemplate(Optional<? extends File> optional) {
        File value = optional.orElse(null);
        if (this.customRunnerTemplate == value) {
            return this;
        }
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, value, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withCustomRunnerConfiguration(File value) {
        File newValue = Objects.requireNonNull(value, "customRunnerConfiguration");
        if (this.customRunnerConfiguration == newValue) {
            return this;
        }
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, newValue, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withCustomRunnerConfiguration(Optional<? extends File> optional) {
        File value = optional.orElse(null);
        if (this.customRunnerConfiguration == value) {
            return this;
        }
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, value, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withSpecRunnerHtmlFileName(String value) {
        if (this.specRunnerHtmlFileName.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "specRunnerHtmlFileName");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, newValue, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withReporterType(ReporterType value) {
        if (this.reporterType == value) {
            return this;
        }
        ReporterType newValue = Objects.requireNonNull(value, "reporterType");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, newValue, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withReporters(Reporter ... elements) {
        List<Reporter> newValue = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, newValue, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withReporters(Iterable<? extends Reporter> elements) {
        if (this.reporters == elements) {
            return this;
        }
        List<Reporter> newValue = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(elements, true, false));
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, newValue, this.fileSystemReporters, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withFileSystemReporters(FileSystemReporter ... elements) {
        List<FileSystemReporter> newValue = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, newValue, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withFileSystemReporters(Iterable<? extends FileSystemReporter> elements) {
        if (this.fileSystemReporters == elements) {
            return this;
        }
        List<FileSystemReporter> newValue = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(elements, true, false));
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, newValue, this.autoRefreshInterval, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withAutoRefreshInterval(int value) {
        if (this.autoRefreshInterval == value) {
            return this;
        }
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, value, this.projectClassLoader);
    }

    public final ImmutableJasmineConfiguration withProjectClassLoader(ClassLoader value) {
        if (this.projectClassLoader == value) {
            return this;
        }
        ClassLoader newValue = Objects.requireNonNull(value, "projectClassLoader");
        return new ImmutableJasmineConfiguration(this.basedir, this.jasmineTargetDir, this.srcDirectoryName, this.specDirectoryName, this.sources, this.specs, this.contexts, this.preloadSources, this.sourceEncoding, this.specRunnerTemplate, this.customRunnerTemplate, this.customRunnerConfiguration, this.specRunnerHtmlFileName, this.reporterType, this.reporters, this.fileSystemReporters, this.autoRefreshInterval, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJasmineConfiguration && this.equalTo((ImmutableJasmineConfiguration)another);
    }

    private boolean equalTo(ImmutableJasmineConfiguration another) {
        return this.basedir.equals(another.basedir) && this.jasmineTargetDir.equals(another.jasmineTargetDir) && this.srcDirectoryName.equals(another.srcDirectoryName) && this.specDirectoryName.equals(another.specDirectoryName) && this.sources.equals(another.sources) && this.specs.equals(another.specs) && this.contexts.equals(another.contexts) && this.preloadSources.equals(another.preloadSources) && this.sourceEncoding.equals(another.sourceEncoding) && this.specRunnerTemplate.equals((Object)another.specRunnerTemplate) && Objects.equals(this.customRunnerTemplate, another.customRunnerTemplate) && Objects.equals(this.customRunnerConfiguration, another.customRunnerConfiguration) && this.specRunnerHtmlFileName.equals(another.specRunnerHtmlFileName) && this.reporterType.equals((Object)another.reporterType) && this.reporters.equals(another.reporters) && this.fileSystemReporters.equals(another.fileSystemReporters) && this.autoRefreshInterval == another.autoRefreshInterval && this.projectClassLoader.equals(another.projectClassLoader);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.basedir.hashCode();
        h += (h << 5) + this.jasmineTargetDir.hashCode();
        h += (h << 5) + this.srcDirectoryName.hashCode();
        h += (h << 5) + this.specDirectoryName.hashCode();
        h += (h << 5) + this.sources.hashCode();
        h += (h << 5) + this.specs.hashCode();
        h += (h << 5) + this.contexts.hashCode();
        h += (h << 5) + this.preloadSources.hashCode();
        h += (h << 5) + this.sourceEncoding.hashCode();
        h += (h << 5) + this.specRunnerTemplate.hashCode();
        h += (h << 5) + Objects.hashCode(this.customRunnerTemplate);
        h += (h << 5) + Objects.hashCode(this.customRunnerConfiguration);
        h += (h << 5) + this.specRunnerHtmlFileName.hashCode();
        h += (h << 5) + this.reporterType.hashCode();
        h += (h << 5) + this.reporters.hashCode();
        h += (h << 5) + this.fileSystemReporters.hashCode();
        h += (h << 5) + this.autoRefreshInterval;
        h += (h << 5) + this.projectClassLoader.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JasmineConfiguration{");
        builder.append("basedir=").append(this.basedir);
        builder.append(", ");
        builder.append("jasmineTargetDir=").append(this.jasmineTargetDir);
        builder.append(", ");
        builder.append("srcDirectoryName=").append(this.srcDirectoryName);
        builder.append(", ");
        builder.append("specDirectoryName=").append(this.specDirectoryName);
        builder.append(", ");
        builder.append("sources=").append(this.sources);
        builder.append(", ");
        builder.append("specs=").append(this.specs);
        builder.append(", ");
        builder.append("contexts=").append(this.contexts);
        builder.append(", ");
        builder.append("preloadSources=").append(this.preloadSources);
        builder.append(", ");
        builder.append("sourceEncoding=").append(this.sourceEncoding);
        builder.append(", ");
        builder.append("specRunnerTemplate=").append((Object)this.specRunnerTemplate);
        if (this.customRunnerTemplate != null) {
            builder.append(", ");
            builder.append("customRunnerTemplate=").append(this.customRunnerTemplate);
        }
        if (this.customRunnerConfiguration != null) {
            builder.append(", ");
            builder.append("customRunnerConfiguration=").append(this.customRunnerConfiguration);
        }
        builder.append(", ");
        builder.append("specRunnerHtmlFileName=").append(this.specRunnerHtmlFileName);
        builder.append(", ");
        builder.append("reporterType=").append((Object)this.reporterType);
        builder.append(", ");
        builder.append("reporters=").append(this.reporters);
        builder.append(", ");
        builder.append("fileSystemReporters=").append(this.fileSystemReporters);
        builder.append(", ");
        builder.append("autoRefreshInterval=").append(this.autoRefreshInterval);
        builder.append(", ");
        builder.append("projectClassLoader=").append(this.projectClassLoader);
        return builder.append("}").toString();
    }

    public static ImmutableJasmineConfiguration copyOf(JasmineConfiguration instance) {
        if (instance instanceof ImmutableJasmineConfiguration) {
            return (ImmutableJasmineConfiguration)instance;
        }
        return ImmutableJasmineConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BASEDIR = 1L;
        private static final long INIT_BIT_JASMINE_TARGET_DIR = 2L;
        private static final long INIT_BIT_SOURCES = 4L;
        private static final long INIT_BIT_SPECS = 8L;
        private static final long OPT_BIT_REPORTERS = 1L;
        private static final long OPT_BIT_FILE_SYSTEM_REPORTERS = 2L;
        private static final long OPT_BIT_AUTO_REFRESH_INTERVAL = 4L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private File basedir;
        @Nullable
        private File jasmineTargetDir;
        @Nullable
        private String srcDirectoryName;
        @Nullable
        private String specDirectoryName;
        @Nullable
        private ScriptSearch sources;
        @Nullable
        private ScriptSearch specs;
        private List<Context> contexts = new ArrayList<Context>();
        private List<String> preloadSources = new ArrayList<String>();
        @Nullable
        private String sourceEncoding;
        @Nullable
        private SpecRunnerTemplate specRunnerTemplate;
        @Nullable
        private File customRunnerTemplate;
        @Nullable
        private File customRunnerConfiguration;
        @Nullable
        private String specRunnerHtmlFileName;
        @Nullable
        private ReporterType reporterType;
        private List<Reporter> reporters = new ArrayList<Reporter>();
        private List<FileSystemReporter> fileSystemReporters = new ArrayList<FileSystemReporter>();
        private int autoRefreshInterval;
        @Nullable
        private ClassLoader projectClassLoader;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JasmineConfiguration instance) {
            Optional<File> customRunnerConfigurationOptional;
            Objects.requireNonNull(instance, "instance");
            this.basedir(instance.getBasedir());
            this.jasmineTargetDir(instance.getJasmineTargetDir());
            this.srcDirectoryName(instance.getSrcDirectoryName());
            this.specDirectoryName(instance.getSpecDirectoryName());
            this.sources(instance.getSources());
            this.specs(instance.getSpecs());
            this.addAllContexts(instance.getContexts());
            this.addAllPreloadSources(instance.getPreloadSources());
            this.sourceEncoding(instance.getSourceEncoding());
            this.specRunnerTemplate(instance.getSpecRunnerTemplate());
            Optional<File> customRunnerTemplateOptional = instance.getCustomRunnerTemplate();
            if (customRunnerTemplateOptional.isPresent()) {
                this.customRunnerTemplate(customRunnerTemplateOptional);
            }
            if ((customRunnerConfigurationOptional = instance.getCustomRunnerConfiguration()).isPresent()) {
                this.customRunnerConfiguration(customRunnerConfigurationOptional);
            }
            this.specRunnerHtmlFileName(instance.getSpecRunnerHtmlFileName());
            this.reporterType(instance.getReporterType());
            this.addAllReporters(instance.getReporters());
            this.addAllFileSystemReporters(instance.getFileSystemReporters());
            this.autoRefreshInterval(instance.getAutoRefreshInterval());
            this.projectClassLoader(instance.getProjectClassLoader());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder basedir(File basedir) {
            this.basedir = Objects.requireNonNull(basedir, "basedir");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jasmineTargetDir(File jasmineTargetDir) {
            this.jasmineTargetDir = Objects.requireNonNull(jasmineTargetDir, "jasmineTargetDir");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder srcDirectoryName(String srcDirectoryName) {
            this.srcDirectoryName = Objects.requireNonNull(srcDirectoryName, "srcDirectoryName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specDirectoryName(String specDirectoryName) {
            this.specDirectoryName = Objects.requireNonNull(specDirectoryName, "specDirectoryName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sources(ScriptSearch sources) {
            this.sources = Objects.requireNonNull(sources, "sources");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specs(ScriptSearch specs) {
            this.specs = Objects.requireNonNull(specs, "specs");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addContexts(Context element) {
            this.contexts.add(Objects.requireNonNull(element, "contexts element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addContexts(Context ... elements) {
            for (Context element : elements) {
                this.contexts.add(Objects.requireNonNull(element, "contexts element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contexts(Iterable<? extends Context> elements) {
            this.contexts.clear();
            return this.addAllContexts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllContexts(Iterable<? extends Context> elements) {
            for (Context context : elements) {
                this.contexts.add(Objects.requireNonNull(context, "contexts element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPreloadSources(String element) {
            this.preloadSources.add(Objects.requireNonNull(element, "preloadSources element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPreloadSources(String ... elements) {
            for (String element : elements) {
                this.preloadSources.add(Objects.requireNonNull(element, "preloadSources element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder preloadSources(Iterable<String> elements) {
            this.preloadSources.clear();
            return this.addAllPreloadSources(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPreloadSources(Iterable<String> elements) {
            for (String element : elements) {
                this.preloadSources.add(Objects.requireNonNull(element, "preloadSources element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceEncoding(String sourceEncoding) {
            this.sourceEncoding = Objects.requireNonNull(sourceEncoding, "sourceEncoding");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specRunnerTemplate(SpecRunnerTemplate specRunnerTemplate) {
            this.specRunnerTemplate = Objects.requireNonNull(specRunnerTemplate, "specRunnerTemplate");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customRunnerTemplate(File customRunnerTemplate) {
            this.customRunnerTemplate = Objects.requireNonNull(customRunnerTemplate, "customRunnerTemplate");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customRunnerTemplate(Optional<? extends File> customRunnerTemplate) {
            this.customRunnerTemplate = customRunnerTemplate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customRunnerConfiguration(File customRunnerConfiguration) {
            this.customRunnerConfiguration = Objects.requireNonNull(customRunnerConfiguration, "customRunnerConfiguration");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customRunnerConfiguration(Optional<? extends File> customRunnerConfiguration) {
            this.customRunnerConfiguration = customRunnerConfiguration.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specRunnerHtmlFileName(String specRunnerHtmlFileName) {
            this.specRunnerHtmlFileName = Objects.requireNonNull(specRunnerHtmlFileName, "specRunnerHtmlFileName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reporterType(ReporterType reporterType) {
            this.reporterType = Objects.requireNonNull(reporterType, "reporterType");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReporters(Reporter element) {
            this.reporters.add(Objects.requireNonNull(element, "reporters element"));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReporters(Reporter ... elements) {
            for (Reporter element : elements) {
                this.reporters.add(Objects.requireNonNull(element, "reporters element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reporters(Iterable<? extends Reporter> elements) {
            this.reporters.clear();
            return this.addAllReporters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllReporters(Iterable<? extends Reporter> elements) {
            for (Reporter reporter : elements) {
                this.reporters.add(Objects.requireNonNull(reporter, "reporters element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFileSystemReporters(FileSystemReporter element) {
            this.fileSystemReporters.add(Objects.requireNonNull(element, "fileSystemReporters element"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFileSystemReporters(FileSystemReporter ... elements) {
            for (FileSystemReporter element : elements) {
                this.fileSystemReporters.add(Objects.requireNonNull(element, "fileSystemReporters element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fileSystemReporters(Iterable<? extends FileSystemReporter> elements) {
            this.fileSystemReporters.clear();
            return this.addAllFileSystemReporters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFileSystemReporters(Iterable<? extends FileSystemReporter> elements) {
            for (FileSystemReporter fileSystemReporter : elements) {
                this.fileSystemReporters.add(Objects.requireNonNull(fileSystemReporter, "fileSystemReporters element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder autoRefreshInterval(int autoRefreshInterval) {
            this.autoRefreshInterval = autoRefreshInterval;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projectClassLoader(ClassLoader projectClassLoader) {
            this.projectClassLoader = Objects.requireNonNull(projectClassLoader, "projectClassLoader");
            return this;
        }

        public ImmutableJasmineConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJasmineConfiguration(this);
        }

        private boolean reportersIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fileSystemReportersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean autoRefreshIntervalIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("basedir");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("jasmineTargetDir");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sources");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("specs");
            }
            return "Cannot build JasmineConfiguration, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private String srcDirectoryName;
        private int srcDirectoryNameBuildStage;
        private String specDirectoryName;
        private int specDirectoryNameBuildStage;
        private String sourceEncoding;
        private int sourceEncodingBuildStage;
        private SpecRunnerTemplate specRunnerTemplate;
        private int specRunnerTemplateBuildStage;
        private String specRunnerHtmlFileName;
        private int specRunnerHtmlFileNameBuildStage;
        private ReporterType reporterType;
        private int reporterTypeBuildStage;
        private List<Reporter> reporters;
        private int reportersBuildStage;
        private List<FileSystemReporter> fileSystemReporters;
        private int fileSystemReportersBuildStage;
        private int autoRefreshInterval;
        private int autoRefreshIntervalBuildStage;
        private ClassLoader projectClassLoader;
        private int projectClassLoaderBuildStage;

        private InitShim() {
        }

        String getSrcDirectoryName() {
            if (this.srcDirectoryNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.srcDirectoryNameBuildStage == 0) {
                this.srcDirectoryNameBuildStage = -1;
                this.srcDirectoryName = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSrcDirectoryName(), "srcDirectoryName");
                this.srcDirectoryNameBuildStage = 1;
            }
            return this.srcDirectoryName;
        }

        void srcDirectoryName(String srcDirectoryName) {
            this.srcDirectoryName = srcDirectoryName;
            this.srcDirectoryNameBuildStage = 1;
        }

        String getSpecDirectoryName() {
            if (this.specDirectoryNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.specDirectoryNameBuildStage == 0) {
                this.specDirectoryNameBuildStage = -1;
                this.specDirectoryName = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSpecDirectoryName(), "specDirectoryName");
                this.specDirectoryNameBuildStage = 1;
            }
            return this.specDirectoryName;
        }

        void specDirectoryName(String specDirectoryName) {
            this.specDirectoryName = specDirectoryName;
            this.specDirectoryNameBuildStage = 1;
        }

        String getSourceEncoding() {
            if (this.sourceEncodingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceEncodingBuildStage == 0) {
                this.sourceEncodingBuildStage = -1;
                this.sourceEncoding = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSourceEncoding(), "sourceEncoding");
                this.sourceEncodingBuildStage = 1;
            }
            return this.sourceEncoding;
        }

        void sourceEncoding(String sourceEncoding) {
            this.sourceEncoding = sourceEncoding;
            this.sourceEncodingBuildStage = 1;
        }

        SpecRunnerTemplate getSpecRunnerTemplate() {
            if (this.specRunnerTemplateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.specRunnerTemplateBuildStage == 0) {
                this.specRunnerTemplateBuildStage = -1;
                this.specRunnerTemplate = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSpecRunnerTemplate(), "specRunnerTemplate");
                this.specRunnerTemplateBuildStage = 1;
            }
            return this.specRunnerTemplate;
        }

        void specRunnerTemplate(SpecRunnerTemplate specRunnerTemplate) {
            this.specRunnerTemplate = specRunnerTemplate;
            this.specRunnerTemplateBuildStage = 1;
        }

        String getSpecRunnerHtmlFileName() {
            if (this.specRunnerHtmlFileNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.specRunnerHtmlFileNameBuildStage == 0) {
                this.specRunnerHtmlFileNameBuildStage = -1;
                this.specRunnerHtmlFileName = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSpecRunnerHtmlFileName(), "specRunnerHtmlFileName");
                this.specRunnerHtmlFileNameBuildStage = 1;
            }
            return this.specRunnerHtmlFileName;
        }

        void specRunnerHtmlFileName(String specRunnerHtmlFileName) {
            this.specRunnerHtmlFileName = specRunnerHtmlFileName;
            this.specRunnerHtmlFileNameBuildStage = 1;
        }

        ReporterType getReporterType() {
            if (this.reporterTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.reporterTypeBuildStage == 0) {
                this.reporterTypeBuildStage = -1;
                this.reporterType = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getReporterType(), "reporterType");
                this.reporterTypeBuildStage = 1;
            }
            return this.reporterType;
        }

        void reporterType(ReporterType reporterType) {
            this.reporterType = reporterType;
            this.reporterTypeBuildStage = 1;
        }

        List<Reporter> getReporters() {
            if (this.reportersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.reportersBuildStage == 0) {
                this.reportersBuildStage = -1;
                this.reporters = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(ImmutableJasmineConfiguration.super.getReporters(), true, false));
                this.reportersBuildStage = 1;
            }
            return this.reporters;
        }

        void reporters(List<Reporter> reporters) {
            this.reporters = reporters;
            this.reportersBuildStage = 1;
        }

        List<FileSystemReporter> getFileSystemReporters() {
            if (this.fileSystemReportersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSystemReportersBuildStage == 0) {
                this.fileSystemReportersBuildStage = -1;
                this.fileSystemReporters = ImmutableJasmineConfiguration.createUnmodifiableList(false, ImmutableJasmineConfiguration.createSafeList(ImmutableJasmineConfiguration.super.getFileSystemReporters(), true, false));
                this.fileSystemReportersBuildStage = 1;
            }
            return this.fileSystemReporters;
        }

        void fileSystemReporters(List<FileSystemReporter> fileSystemReporters) {
            this.fileSystemReporters = fileSystemReporters;
            this.fileSystemReportersBuildStage = 1;
        }

        int getAutoRefreshInterval() {
            if (this.autoRefreshIntervalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.autoRefreshIntervalBuildStage == 0) {
                this.autoRefreshIntervalBuildStage = -1;
                this.autoRefreshInterval = ImmutableJasmineConfiguration.super.getAutoRefreshInterval();
                this.autoRefreshIntervalBuildStage = 1;
            }
            return this.autoRefreshInterval;
        }

        void autoRefreshInterval(int autoRefreshInterval) {
            this.autoRefreshInterval = autoRefreshInterval;
            this.autoRefreshIntervalBuildStage = 1;
        }

        ClassLoader getProjectClassLoader() {
            if (this.projectClassLoaderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.projectClassLoaderBuildStage == 0) {
                this.projectClassLoaderBuildStage = -1;
                this.projectClassLoader = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getProjectClassLoader(), "projectClassLoader");
                this.projectClassLoaderBuildStage = 1;
            }
            return this.projectClassLoader;
        }

        void projectClassLoader(ClassLoader projectClassLoader) {
            this.projectClassLoader = projectClassLoader;
            this.projectClassLoaderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.srcDirectoryNameBuildStage == -1) {
                attributes.add("srcDirectoryName");
            }
            if (this.specDirectoryNameBuildStage == -1) {
                attributes.add("specDirectoryName");
            }
            if (this.sourceEncodingBuildStage == -1) {
                attributes.add("sourceEncoding");
            }
            if (this.specRunnerTemplateBuildStage == -1) {
                attributes.add("specRunnerTemplate");
            }
            if (this.specRunnerHtmlFileNameBuildStage == -1) {
                attributes.add("specRunnerHtmlFileName");
            }
            if (this.reporterTypeBuildStage == -1) {
                attributes.add("reporterType");
            }
            if (this.reportersBuildStage == -1) {
                attributes.add("reporters");
            }
            if (this.fileSystemReportersBuildStage == -1) {
                attributes.add("fileSystemReporters");
            }
            if (this.autoRefreshIntervalBuildStage == -1) {
                attributes.add("autoRefreshInterval");
            }
            if (this.projectClassLoaderBuildStage == -1) {
                attributes.add("projectClassLoader");
            }
            return "Cannot build JasmineConfiguration, attribute initializers form cycle" + attributes;
        }
    }
}

