/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.config;

import com.github.searls.jasmine.config.WebDriverConfiguration;
import com.github.searls.jasmine.mojo.Capability;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableWebDriverConfiguration
implements WebDriverConfiguration {
    private final boolean debug;
    private final String webDriverClassName;
    private final ImmutableList<Capability> webDriverCapabilities;

    private ImmutableWebDriverConfiguration(boolean debug, String webDriverClassName, ImmutableList<Capability> webDriverCapabilities) {
        this.debug = debug;
        this.webDriverClassName = webDriverClassName;
        this.webDriverCapabilities = webDriverCapabilities;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public String getWebDriverClassName() {
        return this.webDriverClassName;
    }

    public ImmutableList<Capability> getWebDriverCapabilities() {
        return this.webDriverCapabilities;
    }

    public final ImmutableWebDriverConfiguration withDebug(boolean value) {
        if (this.debug == value) {
            return this;
        }
        return new ImmutableWebDriverConfiguration(value, this.webDriverClassName, this.webDriverCapabilities);
    }

    public final ImmutableWebDriverConfiguration withWebDriverClassName(String value) {
        if (this.webDriverClassName.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "webDriverClassName");
        return new ImmutableWebDriverConfiguration(this.debug, newValue, this.webDriverCapabilities);
    }

    public final ImmutableWebDriverConfiguration withWebDriverCapabilities(Capability ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableWebDriverConfiguration(this.debug, this.webDriverClassName, (ImmutableList<Capability>)newValue);
    }

    public final ImmutableWebDriverConfiguration withWebDriverCapabilities(Iterable<? extends Capability> elements) {
        if (this.webDriverCapabilities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableWebDriverConfiguration(this.debug, this.webDriverClassName, (ImmutableList<Capability>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebDriverConfiguration && this.equalTo((ImmutableWebDriverConfiguration)another);
    }

    private boolean equalTo(ImmutableWebDriverConfiguration another) {
        return this.debug == another.debug && this.webDriverClassName.equals(another.webDriverClassName) && this.webDriverCapabilities.equals(another.webDriverCapabilities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.debug);
        h += (h << 5) + this.webDriverClassName.hashCode();
        h += (h << 5) + this.webDriverCapabilities.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WebDriverConfiguration").omitNullValues().add("debug", this.debug).add("webDriverClassName", (Object)this.webDriverClassName).add("webDriverCapabilities", this.webDriverCapabilities).toString();
    }

    public static ImmutableWebDriverConfiguration copyOf(WebDriverConfiguration instance) {
        if (instance instanceof ImmutableWebDriverConfiguration) {
            return (ImmutableWebDriverConfiguration)instance;
        }
        return ImmutableWebDriverConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DEBUG = 1L;
        private static final long INIT_BIT_WEB_DRIVER_CLASS_NAME = 2L;
        private long initBits = 3L;
        private boolean debug;
        @Nullable
        private String webDriverClassName;
        private ImmutableList.Builder<Capability> webDriverCapabilities = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WebDriverConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.debug(instance.isDebug());
            this.webDriverClassName(instance.getWebDriverClassName());
            this.addAllWebDriverCapabilities(instance.getWebDriverCapabilities());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder debug(boolean debug) {
            this.debug = debug;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder webDriverClassName(String webDriverClassName) {
            this.webDriverClassName = Objects.requireNonNull(webDriverClassName, "webDriverClassName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWebDriverCapabilities(Capability element) {
            this.webDriverCapabilities.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWebDriverCapabilities(Capability ... elements) {
            this.webDriverCapabilities.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder webDriverCapabilities(Iterable<? extends Capability> elements) {
            this.webDriverCapabilities = ImmutableList.builder();
            return this.addAllWebDriverCapabilities(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllWebDriverCapabilities(Iterable<? extends Capability> elements) {
            this.webDriverCapabilities.addAll(elements);
            return this;
        }

        public ImmutableWebDriverConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebDriverConfiguration(this.debug, this.webDriverClassName, this.webDriverCapabilities.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("debug");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("webDriverClassName");
            }
            return "Cannot build WebDriverConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

