/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.driver;

import com.github.searls.jasmine.config.WebDriverConfiguration;
import com.github.searls.jasmine.driver.QuietHtmlUnitDriver;
import com.github.searls.jasmine.driver.WebDriverFactoryException;
import com.github.searls.jasmine.mojo.Capability;
import com.google.common.collect.ImmutableMap;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

@Named
public class WebDriverFactory {
    private static final Map<String, Function<WebDriverConfiguration, WebDriver>> SUPPORTED_DRIVERS = ImmutableMap.builder().put((Object)ChromeDriver.class.getName(), WebDriverFactory::createChromeDriver).put((Object)HtmlUnitDriver.class.getName(), WebDriverFactory::createHtmlUnitWebDriver).build();

    public WebDriver createWebDriver(WebDriverConfiguration config) {
        return SUPPORTED_DRIVERS.getOrDefault(config.getWebDriverClassName(), WebDriverFactory::createCustomWebDriver).apply(config);
    }

    private static Class<? extends WebDriver> getWebDriverClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new WebDriverFactoryException(e);
        }
    }

    private static Constructor<? extends WebDriver> getWebDriverConstructor(Class<? extends WebDriver> webDriverClass, List<Capability> capabilities) {
        boolean hasCapabilities;
        WebDriverManager.getInstance(webDriverClass).setup();
        boolean bl = hasCapabilities = !capabilities.isEmpty();
        if (hasCapabilities) {
            return WebDriverFactory.getConstructorWithCapabilities(webDriverClass);
        }
        return WebDriverFactory.getConstructorWithoutCapabilities(webDriverClass);
    }

    private static <E extends WebDriver> Constructor<E> getConstructorWithoutCapabilities(Class<E> webDriverClass) {
        try {
            return webDriverClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException originalException) {
            try {
                return webDriverClass.getConstructor(Capabilities.class);
            }
            catch (NoSuchMethodException e) {
                throw new WebDriverFactoryException(originalException);
            }
        }
    }

    private static <E extends WebDriver> Constructor<E> getConstructorWithCapabilities(Class<E> webDriverClass) {
        try {
            return webDriverClass.getConstructor(Capabilities.class);
        }
        catch (NoSuchMethodException originalException) {
            try {
                return webDriverClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new WebDriverFactoryException(originalException);
            }
        }
    }

    private static WebDriver createCustomWebDriver(WebDriverConfiguration config) {
        Class<? extends WebDriver> webDriverClass = WebDriverFactory.getWebDriverClass(config.getWebDriverClassName());
        return WebDriverFactory.createCustomWebDriver(webDriverClass, config.getWebDriverCapabilities());
    }

    private static WebDriver createCustomWebDriver(Class<? extends WebDriver> webDriverClass, List<Capability> capabilities) {
        Constructor<? extends WebDriver> constructor = WebDriverFactory.getWebDriverConstructor(webDriverClass, capabilities);
        try {
            return constructor.newInstance(WebDriverFactory.getWebDriverConstructorArguments(constructor, capabilities));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new WebDriverFactoryException(e);
        }
    }

    private static Object[] getWebDriverConstructorArguments(Constructor<? extends WebDriver> constructor, List<Capability> customCapabilities) {
        if (constructor.getParameterTypes().length == 0) {
            return new Object[0];
        }
        return new Object[]{WebDriverFactory.getCapabilities(customCapabilities)};
    }

    private static DesiredCapabilities getCapabilities(List<Capability> customCapabilities) {
        return WebDriverFactory.customizeCapabilities(new DesiredCapabilities(), customCapabilities);
    }

    private static <E extends MutableCapabilities> E customizeCapabilities(E capabilities, WebDriverConfiguration config) {
        return WebDriverFactory.customizeCapabilities(capabilities, config.getWebDriverCapabilities());
    }

    private static <E extends MutableCapabilities> E customizeCapabilities(E capabilities, List<Capability> customCapabilities) {
        for (Capability capability : customCapabilities) {
            Object value = capability.getValue();
            if (value != null && (!String.class.isInstance(value) || StringUtils.isNotBlank((String)((String)value)))) {
                capabilities.setCapability(capability.getName(), capability.getValue());
                continue;
            }
            if (capability.getList() != null && !capability.getList().isEmpty()) {
                capabilities.setCapability(capability.getName(), capability.getList());
                continue;
            }
            if (capability.getMap() == null || capability.getMap().isEmpty()) continue;
            capabilities.setCapability(capability.getName(), capability.getMap());
        }
        return capabilities;
    }

    private static WebDriver createHtmlUnitWebDriver(WebDriverConfiguration config) {
        return new QuietHtmlUnitDriver((Capabilities)WebDriverFactory.customizeCapabilities(DesiredCapabilities.htmlUnit(), config), config.isDebug());
    }

    private static WebDriver createChromeDriver(WebDriverConfiguration config) {
        WebDriverManager.getInstance(ChromeDriver.class).setup();
        return new ChromeDriver(WebDriverFactory.customizeCapabilities(new ChromeOptions().setHeadless(true), config));
    }
}

