/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.model;

import com.github.searls.jasmine.model.AbstractJasmineResult;
import com.github.searls.jasmine.model.JasmineResult;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableJasmineResult
extends AbstractJasmineResult {
    private final String details;

    private ImmutableJasmineResult(String details) {
        this.details = details;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    public final ImmutableJasmineResult withDetails(String value) {
        if (this.details.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "details");
        return new ImmutableJasmineResult(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJasmineResult && this.equalTo((ImmutableJasmineResult)another);
    }

    private boolean equalTo(ImmutableJasmineResult another) {
        return this.details.equals(another.details);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.details.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JasmineResult").omitNullValues().add("details", (Object)this.details).toString();
    }

    public static ImmutableJasmineResult copyOf(AbstractJasmineResult instance) {
        if (instance instanceof ImmutableJasmineResult) {
            return (ImmutableJasmineResult)instance;
        }
        return ImmutableJasmineResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DETAILS = 1L;
        private long initBits = 1L;
        @Nullable
        private String details;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JasmineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractJasmineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof JasmineResult) {
                JasmineResult instance = (JasmineResult)object;
                this.details(instance.getDetails());
            }
        }

        @CanIgnoreReturnValue
        public final Builder details(String details) {
            this.details = Objects.requireNonNull(details, "details");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableJasmineResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJasmineResult(this.details);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("details");
            }
            return "Cannot build JasmineResult, some of required attributes are not set " + attributes;
        }
    }
}

