/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.model;

import com.github.searls.jasmine.model.ScriptSearch;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableScriptSearch
implements ScriptSearch {
    private final File directory;
    private final ImmutableList<String> includes;
    private final ImmutableList<String> excludes;

    private ImmutableScriptSearch(File directory, ImmutableList<String> includes, ImmutableList<String> excludes) {
        this.directory = directory;
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    public ImmutableList<String> getIncludes() {
        return this.includes;
    }

    public ImmutableList<String> getExcludes() {
        return this.excludes;
    }

    public final ImmutableScriptSearch withDirectory(File value) {
        if (this.directory == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "directory");
        return new ImmutableScriptSearch(newValue, this.includes, this.excludes);
    }

    public final ImmutableScriptSearch withIncludes(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableScriptSearch(this.directory, (ImmutableList<String>)newValue, this.excludes);
    }

    public final ImmutableScriptSearch withIncludes(Iterable<String> elements) {
        if (this.includes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableScriptSearch(this.directory, (ImmutableList<String>)newValue, this.excludes);
    }

    public final ImmutableScriptSearch withExcludes(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableScriptSearch(this.directory, this.includes, (ImmutableList<String>)newValue);
    }

    public final ImmutableScriptSearch withExcludes(Iterable<String> elements) {
        if (this.excludes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableScriptSearch(this.directory, this.includes, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScriptSearch && this.equalTo((ImmutableScriptSearch)another);
    }

    private boolean equalTo(ImmutableScriptSearch another) {
        return this.directory.equals(another.directory) && this.includes.equals(another.includes) && this.excludes.equals(another.excludes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.directory.hashCode();
        h += (h << 5) + this.includes.hashCode();
        h += (h << 5) + this.excludes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ScriptSearch").omitNullValues().add("directory", (Object)this.directory).add("includes", this.includes).add("excludes", this.excludes).toString();
    }

    public static ImmutableScriptSearch copyOf(ScriptSearch instance) {
        if (instance instanceof ImmutableScriptSearch) {
            return (ImmutableScriptSearch)instance;
        }
        return ImmutableScriptSearch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DIRECTORY = 1L;
        private long initBits = 1L;
        @Nullable
        private File directory;
        private ImmutableList.Builder<String> includes = ImmutableList.builder();
        private ImmutableList.Builder<String> excludes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ScriptSearch instance) {
            Objects.requireNonNull(instance, "instance");
            this.directory(instance.getDirectory());
            this.addAllIncludes(instance.getIncludes());
            this.addAllExcludes(instance.getExcludes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder directory(File directory) {
            this.directory = Objects.requireNonNull(directory, "directory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIncludes(String element) {
            this.includes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIncludes(String ... elements) {
            this.includes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder includes(Iterable<String> elements) {
            this.includes = ImmutableList.builder();
            return this.addAllIncludes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllIncludes(Iterable<String> elements) {
            this.includes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExcludes(String element) {
            this.excludes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExcludes(String ... elements) {
            this.excludes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder excludes(Iterable<String> elements) {
            this.excludes = ImmutableList.builder();
            return this.addAllExcludes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExcludes(Iterable<String> elements) {
            this.excludes.addAll(elements);
            return this;
        }

        public ImmutableScriptSearch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScriptSearch(this.directory, this.includes.build(), this.excludes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("directory");
            }
            return "Cannot build ScriptSearch, some of required attributes are not set " + attributes;
        }
    }
}

