/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.config.ImmutableJasmineConfiguration;
import com.github.searls.jasmine.config.ImmutableServerConfiguration;
import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.config.ServerConfiguration;
import com.github.searls.jasmine.io.ScansDirectory;
import com.github.searls.jasmine.model.FileSystemReporter;
import com.github.searls.jasmine.model.ImmutableScriptSearch;
import com.github.searls.jasmine.model.Reporter;
import com.github.searls.jasmine.model.ScriptSearch;
import com.github.searls.jasmine.mojo.Context;
import com.github.searls.jasmine.mojo.ReporterRetriever;
import com.github.searls.jasmine.mojo.ResourceRetriever;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerTemplate;
import com.github.searls.jasmine.thirdpartylibs.ProjectClassLoaderFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractJasmineMojo
extends AbstractMojo {
    protected static final String CUSTOM_RUNNER_CONFIGURATION_PARAM = "customRunnerConfiguration";
    protected static final String CUSTOM_RUNNER_TEMPLATE_PARAM = "customRunnerTemplate";
    @Parameter(property="jsSrcDir", defaultValue="${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript")
    private File jsSrcDir = null;
    @Parameter(property="jsTestSrcDir", defaultValue="${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript")
    private File jsTestSrcDir = null;
    @Parameter
    private List<String> preloadSources = Collections.emptyList();
    @Parameter
    private String customRunnerTemplate = null;
    @Parameter
    private String customRunnerConfiguration = null;
    @Parameter
    private List<Reporter> reporters = new ArrayList<Reporter>();
    @Parameter
    private List<FileSystemReporter> fileSystemReporters = new ArrayList<FileSystemReporter>();
    @Parameter(defaultValue="${project.build.directory}${file.separator}jasmine")
    private File jasmineTargetDir = null;
    @Parameter(defaultValue="SpecRunner.html")
    private String specRunnerHtmlFileName = "SpecRunner.html";
    @Parameter(defaultValue="spec")
    private String specDirectoryName = "spec";
    @Parameter(defaultValue="src")
    private String srcDirectoryName = "src";
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding = StandardCharsets.UTF_8.name();
    @Parameter
    private final List<String> sourceIncludes = ScansDirectory.DEFAULT_INCLUDES;
    @Parameter
    private final List<String> sourceExcludes = Collections.emptyList();
    @Parameter
    private final List<String> specIncludes = ScansDirectory.DEFAULT_INCLUDES;
    @Parameter
    private final List<String> specExcludes = Collections.emptyList();
    @Parameter(property="jasmine.serverPort", defaultValue="8234")
    private int serverPort = 8234;
    @Parameter(property="jasmine.uriScheme", defaultValue="http")
    private String uriScheme = "http";
    @Parameter(property="jasmine.serverHostname", defaultValue="localhost")
    private String serverHostname = "localhost";
    @Parameter(property="jasmine.specRunnerTemplate", defaultValue="DEFAULT")
    private SpecRunnerTemplate specRunnerTemplate = SpecRunnerTemplate.DEFAULT;
    @Parameter(property="jasmine.autoRefreshInterval", defaultValue="0")
    private int autoRefreshInterval = 0;
    @Parameter
    private List<Context> additionalContexts = Collections.emptyList();
    private final MavenProject mavenProject;
    private final ReporterType reporterType;
    private final ResourceRetriever resourceRetriever;
    private final ReporterRetriever reporterRetriever;

    AbstractJasmineMojo(MavenProject mavenProject, ReporterType reporterType, ResourceRetriever resourceRetriever, ReporterRetriever reporterRetriever) {
        this.mavenProject = mavenProject;
        this.reporterType = reporterType;
        this.resourceRetriever = resourceRetriever;
        this.reporterRetriever = reporterRetriever;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.run(this.getServerConfiguration(), this.getJasmineConfiguration());
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The jasmine-maven-plugin encountered an exception:", e);
        }
    }

    protected final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    protected abstract void run(ServerConfiguration var1, JasmineConfiguration var2) throws Exception;

    private ServerConfiguration getServerConfiguration() {
        return ImmutableServerConfiguration.builder().uriScheme(this.uriScheme).serverHostname(this.serverHostname).serverPort(this.serverPort).build();
    }

    private JasmineConfiguration getJasmineConfiguration() throws MojoExecutionException {
        return ImmutableJasmineConfiguration.builder().customRunnerConfiguration(this.getCustomRunnerConfigurationFile()).customRunnerTemplate(this.getCustomRunnerTemplateFile()).contexts(this.getContexts()).projectClassLoader(this.getProjectClassLoader()).autoRefreshInterval(this.autoRefreshInterval).preloadSources(this.preloadSources).basedir(this.mavenProject.getBasedir()).srcDirectoryName(this.srcDirectoryName).sources(this.getSources()).specDirectoryName(this.specDirectoryName).specs(this.getSpecs()).specRunnerHtmlFileName(this.specRunnerHtmlFileName).specRunnerTemplate(this.specRunnerTemplate).reporters(this.getReporters()).fileSystemReporters(this.getFileSystemReporters()).reporterType(this.reporterType).jasmineTargetDir(this.jasmineTargetDir).sourceEncoding(this.sourceEncoding).build();
    }

    private List<FileSystemReporter> getFileSystemReporters() throws MojoExecutionException {
        return this.reporterRetriever.retrieveFileSystemReporters(this.fileSystemReporters, this.jasmineTargetDir, this.mavenProject);
    }

    private Optional<File> getCustomRunnerTemplateFile() throws MojoExecutionException {
        return this.resourceRetriever.getResourceAsFile(CUSTOM_RUNNER_TEMPLATE_PARAM, this.customRunnerTemplate, this.mavenProject);
    }

    private Optional<File> getCustomRunnerConfigurationFile() throws MojoExecutionException {
        return this.resourceRetriever.getResourceAsFile(CUSTOM_RUNNER_CONFIGURATION_PARAM, this.customRunnerConfiguration, this.mavenProject);
    }

    private List<Reporter> getReporters() throws MojoExecutionException {
        return this.reporterRetriever.retrieveReporters(this.reporters, this.mavenProject);
    }

    private ClassLoader getProjectClassLoader() {
        return new ProjectClassLoaderFactory(this.mavenProject.getArtifacts()).create();
    }

    private List<Context> getContexts() {
        ArrayList<Context> contexts = new ArrayList<Context>();
        contexts.add(new Context(this.srcDirectoryName, this.jsSrcDir));
        contexts.add(new Context(this.specDirectoryName, this.jsTestSrcDir));
        contexts.addAll(this.additionalContexts);
        return contexts;
    }

    private ScriptSearch getSpecs() {
        return ImmutableScriptSearch.builder().directory(this.jsTestSrcDir).includes(this.specIncludes).excludes(this.specExcludes).build();
    }

    private ScriptSearch getSources() {
        return ImmutableScriptSearch.builder().directory(this.jsSrcDir).includes(this.sourceIncludes).excludes(this.sourceExcludes).build();
    }

    @VisibleForTesting
    void setJsSrcDir(File jsSrcDir) {
        this.jsSrcDir = jsSrcDir;
    }

    @VisibleForTesting
    void setJsTestSrcDir(File jsTestSrcDir) {
        this.jsTestSrcDir = jsTestSrcDir;
    }

    @VisibleForTesting
    void setJasmineTargetDir(File jasmineTargetDir) {
        this.jasmineTargetDir = jasmineTargetDir;
    }

    @VisibleForTesting
    void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    @VisibleForTesting
    void setCustomRunnerConfiguration(String customRunnerConfiguration) {
        this.customRunnerConfiguration = customRunnerConfiguration;
    }

    @VisibleForTesting
    void setCustomRunnerTemplate(String customRunnerTemplate) {
        this.customRunnerTemplate = customRunnerTemplate;
    }

    @VisibleForTesting
    void setReporters(List<Reporter> reporters) {
        this.reporters = reporters;
    }

    @VisibleForTesting
    void setFileSystemReporters(List<FileSystemReporter> fileSystemReporters) {
        this.fileSystemReporters = fileSystemReporters;
    }

    void setAutoRefreshInterval(int autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }
}

