/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;

@Named
public class ResourceRetriever {
    private static final String ERROR_FILE_DNE = "Invalid value for parameter '%s'. File does not exist: %s";
    private final ResourceManager locator;

    @Inject
    public ResourceRetriever(ResourceManager locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<File> getResourceAsFile(String parameter, String resourceLocation, MavenProject mavenProject) throws MojoExecutionException {
        File file = null;
        if (resourceLocation != null) {
            this.locator.addSearchPath("url", "");
            this.locator.addSearchPath("file", mavenProject.getFile().getParentFile().getAbsolutePath());
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    file = this.locator.getResourceAsFile(resourceLocation);
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format(ERROR_FILE_DNE, parameter, resourceLocation));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
        return Optional.ofNullable(file);
    }
}

