/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.config.ServerConfiguration;
import com.github.searls.jasmine.io.RelativizesFilePaths;
import com.github.searls.jasmine.mojo.AbstractJasmineMojo;
import com.github.searls.jasmine.mojo.ReporterRetriever;
import com.github.searls.jasmine.mojo.ResourceRetriever;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.server.ResourceHandlerConfigurator;
import com.github.searls.jasmine.server.ServerManager;
import com.github.searls.jasmine.server.ServerManagerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="bdd", requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ServerMojo
extends AbstractJasmineMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerMojo.class);
    private static final String INSTRUCTION_FORMAT = ServerMojo.getInstructionsTemplate();
    private final RelativizesFilePaths relativizesFilePaths;
    private final ResourceHandlerConfigurator resourceHandlerConfigurator;
    private final ServerManagerFactory serverManagerFactory;

    @Inject
    public ServerMojo(MavenProject mavenProject, ResourceRetriever resourceRetriever, ReporterRetriever reporterRetriever, RelativizesFilePaths relativizesFilePaths, ResourceHandlerConfigurator resourceHandlerConfigurator, ServerManagerFactory serverManagerFactory) {
        super(mavenProject, ReporterType.HtmlReporter, resourceRetriever, reporterRetriever);
        this.relativizesFilePaths = relativizesFilePaths;
        this.resourceHandlerConfigurator = resourceHandlerConfigurator;
        this.serverManagerFactory = serverManagerFactory;
    }

    @Override
    public void run(ServerConfiguration serverConfiguration, JasmineConfiguration jasmineConfiguration) throws Exception {
        ServerManager serverManager = this.serverManagerFactory.create();
        serverManager.start(serverConfiguration.getServerPort(), this.resourceHandlerConfigurator.createHandler(jasmineConfiguration));
        LOGGER.info(this.buildServerInstructions(serverConfiguration, jasmineConfiguration));
        serverManager.join();
    }

    private String buildServerInstructions(ServerConfiguration serverConfiguration, JasmineConfiguration jasmineConfiguration) throws IOException {
        return String.format(INSTRUCTION_FORMAT, serverConfiguration.getServerURL(), this.getSourcePath(jasmineConfiguration), this.getSpecPath(jasmineConfiguration));
    }

    private String getSourcePath(JasmineConfiguration config) throws IOException {
        return this.getRelativePath(config.getBasedir(), config.getSources().getDirectory());
    }

    private String getSpecPath(JasmineConfiguration config) throws IOException {
        return this.getRelativePath(config.getBasedir(), config.getSpecs().getDirectory());
    }

    private String getRelativePath(File basedir, File absolutePath) throws IOException {
        return this.relativizesFilePaths.relativize(basedir, absolutePath);
    }

    private static String getInstructionsTemplate() {
        String template;
        try {
            template = IOUtils.toString((InputStream)ServerMojo.class.getResourceAsStream("/instructions.template"));
        }
        catch (IOException e) {
            template = "";
            LOGGER.error("Unable to read instructions template: ", (Throwable)e);
        }
        return template;
    }
}

