/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.config.ImmutableServerConfiguration;
import com.github.searls.jasmine.config.ImmutableWebDriverConfiguration;
import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.config.ServerConfiguration;
import com.github.searls.jasmine.config.WebDriverConfiguration;
import com.github.searls.jasmine.driver.WebDriverFactory;
import com.github.searls.jasmine.format.JasmineResultLogger;
import com.github.searls.jasmine.model.JasmineResult;
import com.github.searls.jasmine.mojo.AbstractJasmineMojo;
import com.github.searls.jasmine.mojo.Capability;
import com.github.searls.jasmine.mojo.ReporterRetriever;
import com.github.searls.jasmine.mojo.ResourceRetriever;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerExecutor;
import com.github.searls.jasmine.server.ResourceHandlerConfigurator;
import com.github.searls.jasmine.server.ServerManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class TestMojo
extends AbstractJasmineMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestMojo.class);
    @Parameter(defaultValue="org.openqa.selenium.chrome.ChromeDriver")
    private String webDriverClassName = ChromeDriver.class.getName();
    @Parameter
    private List<Capability> webDriverCapabilities = Collections.emptyList();
    @Parameter(defaultValue="documentation")
    private String format = "documentation";
    @Parameter(property="keepServerAlive", defaultValue="false")
    private boolean keepServerAlive = false;
    @Parameter(defaultValue="300")
    private int timeout = 300;
    @Parameter(property="haltOnFailure", defaultValue="true")
    private boolean haltOnFailure = true;
    @Parameter(defaultValue="false")
    private boolean debug = false;
    @Parameter(property="skipTests")
    private boolean skipTests = false;
    @Parameter(property="maven.test.skip")
    private boolean mvnTestSkip = false;
    @Parameter(property="skipJasmineTests")
    private boolean skipJasmineTests = false;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession = null;
    private final WebDriverFactory webDriverFactory;
    private final SpecRunnerExecutor specRunnerExecutor;
    private final JasmineResultLogger jasmineResultLogger;
    private final ResourceHandlerConfigurator resourceHandlerConfigurator;

    @Inject
    public TestMojo(MavenProject mavenProject, ResourceRetriever resourceRetriever, ReporterRetriever reporterRetriever, WebDriverFactory webDriverFactory, SpecRunnerExecutor specRunnerExecutor, JasmineResultLogger jasmineResultLogger, ResourceHandlerConfigurator resourceHandlerConfigurator) {
        super(mavenProject, ReporterType.JsApiReporter, resourceRetriever, reporterRetriever);
        this.webDriverFactory = webDriverFactory;
        this.specRunnerExecutor = specRunnerExecutor;
        this.jasmineResultLogger = jasmineResultLogger;
        this.resourceHandlerConfigurator = resourceHandlerConfigurator;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isSkipTests()) {
            super.execute();
        } else {
            LOGGER.info("Skipping Jasmine Specs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ServerConfiguration serverConfiguration, JasmineConfiguration configuration) throws Exception {
        ServerManager serverManager = ServerManager.newInstance();
        try {
            int port = serverManager.start(this.resourceHandlerConfigurator.createHandler(configuration));
            this.setPortProperty(port);
            LOGGER.info("Executing Jasmine Specs");
            JasmineResult result = this.executeSpecs(ImmutableServerConfiguration.copyOf(serverConfiguration).withServerPort(port), configuration);
            this.logResults(result);
            this.throwAnySpecFailures(result);
        }
        finally {
            if (!this.keepServerAlive) {
                serverManager.stop();
            }
        }
    }

    private void setPortProperty(int port) {
        this.getMavenProject().getProperties().setProperty("jasmine.serverPort", String.valueOf(port));
    }

    private JasmineResult executeSpecs(ServerConfiguration serverConfiguration, JasmineConfiguration configuration) throws Exception {
        WebDriver driver = this.createDriver();
        return this.specRunnerExecutor.execute(serverConfiguration.getServerURL(), driver, this.timeout, this.debug, this.format, configuration.getReporters(), configuration.getFileSystemReporters());
    }

    private WebDriver createDriver() {
        return this.webDriverFactory.createWebDriver(this.getWebDriverConfiguration());
    }

    private void logResults(JasmineResult result) {
        this.jasmineResultLogger.log(result);
    }

    private void throwAnySpecFailures(JasmineResult result) throws MojoFailureException {
        if (this.haltOnFailure && !result.didPass()) {
            throw new MojoFailureException("There were Jasmine spec failures.");
        }
    }

    private WebDriverConfiguration getWebDriverConfiguration() {
        return ImmutableWebDriverConfiguration.builder().debug(this.debug).webDriverCapabilities(this.webDriverCapabilities).webDriverClassName(this.webDriverClassName).build();
    }

    private boolean isSkipTests() {
        return this.skipTests || this.mvnTestSkip || this.skipJasmineTests;
    }

    @VisibleForTesting
    void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }
}

