/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class ConsoleErrorChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleErrorChecker.class);

    ConsoleErrorChecker() {
    }

    void checkForConsoleErrors(WebDriver driver) {
        String jserrors;
        WebElement head = driver.findElement(By.tagName((String)"head"));
        if (head != null && StringUtils.isNotBlank((CharSequence)(jserrors = head.getAttribute("jmp_jserror")))) {
            String errors = "JavaScript Console Errors:\n\n  * " + jserrors.replaceAll(":!:", "\n  * ") + "\n\n";
            LOGGER.warn(errors);
            throw new RuntimeException("There were javascript console errors.\n\n" + errors);
        }
    }
}

