/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.io.IoUtilities;
import com.github.searls.jasmine.model.FileSystemReporter;
import com.github.searls.jasmine.model.ImmutableJasmineResult;
import com.github.searls.jasmine.model.JasmineResult;
import com.github.searls.jasmine.model.Reporter;
import com.github.searls.jasmine.runner.ConsoleErrorChecker;
import com.github.searls.jasmine.runner.WebDriverWaiter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SpecRunnerExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecRunnerExecutor.class);
    private final IoUtilities ioUtilities;
    private final WebDriverWaiter webDriverWaiter;
    private final ConsoleErrorChecker consoleErrorChecker;

    @Inject
    public SpecRunnerExecutor(IoUtilities ioUtilities, WebDriverWaiter webDriverWaiter, ConsoleErrorChecker consoleErrorChecker) {
        this.ioUtilities = ioUtilities;
        this.webDriverWaiter = webDriverWaiter;
        this.consoleErrorChecker = consoleErrorChecker;
    }

    public JasmineResult execute(URL runnerUrl, WebDriver driver, int timeout, boolean debug, String format, List<Reporter> reporters, List<FileSystemReporter> fileSystemReporters) {
        try {
            if (!(driver instanceof JavascriptExecutor)) {
                throw new RuntimeException("The provided web driver can't execute JavaScript: " + driver.getClass());
            }
            JavascriptExecutor executor = (JavascriptExecutor)driver;
            driver.get(runnerUrl.toString());
            this.webDriverWaiter.waitForRunnerToFinish(driver, timeout, debug);
            this.consoleErrorChecker.checkForConsoleErrors(driver);
            this.storeFileSystemReports(fileSystemReporters, executor, debug);
            ImmutableJasmineResult immutableJasmineResult = ImmutableJasmineResult.builder().details(this.buildReports(reporters, executor, format)).build();
            return immutableJasmineResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                driver.quit();
            }
            catch (Exception e) {
                LOGGER.error("There was an exception quitting WebDriver.", (Throwable)e);
            }
        }
    }

    private void storeFileSystemReports(List<FileSystemReporter> fileSystemReporters, JavascriptExecutor executor, boolean debug) throws IOException {
        for (FileSystemReporter reporter : fileSystemReporters) {
            this.ioUtilities.writeStringToFile(reporter.getFile(), this.buildFileSystemReport(executor, reporter.getReporterFile(), debug));
        }
    }

    private String buildFileSystemReport(JavascriptExecutor driver, File reporter, boolean debug) throws IOException {
        String command = "return fileSystemReporter.report(window.jsApiReporter," + debug + ");";
        return this.executeReportCommand(driver, reporter, command);
    }

    private String buildReports(List<Reporter> reporters, JavascriptExecutor executor, String format) throws IOException {
        StringBuilder report = new StringBuilder();
        for (Reporter reporter : reporters) {
            report.append(this.buildReport(executor, reporter.getReporterFile(), format));
        }
        return report.toString();
    }

    private String buildReport(JavascriptExecutor driver, File reporter, String format) throws IOException {
        String command = "return jasmineMavenPlugin.printReport(window.jsApiReporter,{format:'" + format + "'});";
        return this.executeReportCommand(driver, reporter, command);
    }

    private String executeReportCommand(JavascriptExecutor driver, File reporter, String command) throws IOException {
        String script = this.ioUtilities.readFileToString(reporter) + command;
        Object report = driver.executeScript(script, new Object[0]);
        return report.toString();
    }
}

