/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.thirdpartylibs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ResourceHandler;

public abstract class AbstractThirdPartyLibsResourceHandler
extends ResourceHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.isHandled()) {
            return;
        }
        String resourcePath = this.getResourcePath(target);
        InputStream resource = this.findResource(resourcePath);
        if (resource != null) {
            String javascript = IOUtils.toString((InputStream)resource, (String)"UTF-8");
            if ("/jasmine-core/boot.js".equals(target)) {
                javascript = javascript.replaceAll("window.onload =", "jasmine.boot =");
            }
            this.setHeaders(response, resourcePath, javascript);
            this.writeResponse(response, javascript);
            baseRequest.setHandled(true);
        }
    }

    protected abstract InputStream findResource(String var1);

    private String getResourcePath(String url) {
        return url.replaceFirst("^/", "");
    }

    private void setHeaders(HttpServletResponse response, String resourcePath, String content) {
        response.setCharacterEncoding("UTF-8");
        if (resourcePath.endsWith(".css")) {
            response.setContentType("text/css");
        } else {
            response.setContentType("text/javascript");
        }
        response.addDateHeader("EXPIRES", 0L);
        response.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), new Date().getTime());
        try {
            int contentLength = content.getBytes("UTF-8").length;
            response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Integer.toString(contentLength));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The JVM does not support javascript default encoding.", e);
        }
    }

    private void writeResponse(HttpServletResponse response, String javascript) throws IOException {
        response.getWriter().write(javascript);
    }
}

