/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.thirdpartylibs;

import com.github.searls.jasmine.thirdpartylibs.AbstractThirdPartyLibsResourceHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.webjars.WebJarAssetLocator;

public class WebJarResourceHandler
extends AbstractThirdPartyLibsResourceHandler {
    private static final Pattern WILDCARD = Pattern.compile(".*");
    private final List<WebJarAssetLocator> webJarAssetLocators;
    private final ClassLoader projectClassLoader;

    public WebJarResourceHandler(ClassLoader projectClassLoader) {
        this.projectClassLoader = projectClassLoader;
        this.webJarAssetLocators = this.createWebJarAssetLocators(WebJarResourceHandler.class.getClassLoader(), projectClassLoader);
    }

    @Override
    protected InputStream findResource(String resourcePath) {
        String fullPath = this.findFullPath(resourcePath);
        return fullPath != null ? this.projectClassLoader.getResourceAsStream(fullPath) : null;
    }

    private String findFullPath(String resourcePath) {
        WebJarAssetLocator locator;
        String fullPath = null;
        Iterator<WebJarAssetLocator> iterator = this.webJarAssetLocators.iterator();
        while (iterator.hasNext() && (fullPath = this.findFullPath(locator = iterator.next(), resourcePath)) == null) {
        }
        return fullPath;
    }

    private String findFullPath(WebJarAssetLocator locator, String resourcePath) {
        String fullPath;
        try {
            fullPath = locator.getFullPath(resourcePath);
        }
        catch (Exception e) {
            fullPath = this.findFullPathByPartial(locator, resourcePath);
        }
        return fullPath;
    }

    private String findFullPathByPartial(WebJarAssetLocator locator, String resourcePath) {
        String fullPath = null;
        int splitAt = resourcePath.indexOf("/");
        if (splitAt > 0) {
            String webjar = resourcePath.substring(0, splitAt);
            String partialPath = resourcePath.substring(splitAt + 1);
            try {
                fullPath = locator.getFullPath(webjar, partialPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fullPath;
    }

    private List<WebJarAssetLocator> createWebJarAssetLocators(ClassLoader ... classLoaders) {
        ArrayList<WebJarAssetLocator> locators = new ArrayList<WebJarAssetLocator>();
        for (ClassLoader classLoader : classLoaders) {
            locators.add(new WebJarAssetLocator(WebJarAssetLocator.getFullPathIndex((Pattern)WILDCARD, (ClassLoader[])new ClassLoader[]{classLoader})));
        }
        return locators;
    }
}

