package com.github.searls.jasmine.config;

import com.github.searls.jasmine.model.FileSystemReporter;
import com.github.searls.jasmine.model.Reporter;
import com.github.searls.jasmine.model.ScriptSearch;
import com.github.searls.jasmine.mojo.Context;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerTemplate;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JasmineConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJasmineConfiguration.builder()}.
 */
@Generated(from = "JasmineConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJasmineConfiguration extends JasmineConfiguration {
  private final File basedir;
  private final File jasmineTargetDir;
  private final String srcDirectoryName;
  private final String specDirectoryName;
  private final ScriptSearch sources;
  private final ScriptSearch specs;
  private final List<Context> contexts;
  private final List<String> preloadSources;
  private final String sourceEncoding;
  private final SpecRunnerTemplate specRunnerTemplate;
  private final @Nullable File customRunnerTemplate;
  private final @Nullable File customRunnerConfiguration;
  private final String specRunnerHtmlFileName;
  private final ReporterType reporterType;
  private final List<Reporter> reporters;
  private final List<FileSystemReporter> fileSystemReporters;
  private final int autoRefreshInterval;
  private final ClassLoader projectClassLoader;
  private final boolean debug;

  private ImmutableJasmineConfiguration(ImmutableJasmineConfiguration.Builder builder) {
    this.basedir = builder.basedir;
    this.jasmineTargetDir = builder.jasmineTargetDir;
    this.sources = builder.sources;
    this.specs = builder.specs;
    this.contexts = createUnmodifiableList(true, builder.contexts);
    this.preloadSources = createUnmodifiableList(true, builder.preloadSources);
    this.customRunnerTemplate = builder.customRunnerTemplate;
    this.customRunnerConfiguration = builder.customRunnerConfiguration;
    this.debug = builder.debug;
    if (builder.srcDirectoryName != null) {
      initShim.srcDirectoryName(builder.srcDirectoryName);
    }
    if (builder.specDirectoryName != null) {
      initShim.specDirectoryName(builder.specDirectoryName);
    }
    if (builder.sourceEncoding != null) {
      initShim.sourceEncoding(builder.sourceEncoding);
    }
    if (builder.specRunnerTemplate != null) {
      initShim.specRunnerTemplate(builder.specRunnerTemplate);
    }
    if (builder.specRunnerHtmlFileName != null) {
      initShim.specRunnerHtmlFileName(builder.specRunnerHtmlFileName);
    }
    if (builder.reporterType != null) {
      initShim.reporterType(builder.reporterType);
    }
    if (builder.reportersIsSet()) {
      initShim.reporters(createUnmodifiableList(true, builder.reporters));
    }
    if (builder.fileSystemReportersIsSet()) {
      initShim.fileSystemReporters(createUnmodifiableList(true, builder.fileSystemReporters));
    }
    if (builder.autoRefreshIntervalIsSet()) {
      initShim.autoRefreshInterval(builder.autoRefreshInterval);
    }
    if (builder.projectClassLoader != null) {
      initShim.projectClassLoader(builder.projectClassLoader);
    }
    this.srcDirectoryName = initShim.getSrcDirectoryName();
    this.specDirectoryName = initShim.getSpecDirectoryName();
    this.sourceEncoding = initShim.getSourceEncoding();
    this.specRunnerTemplate = initShim.getSpecRunnerTemplate();
    this.specRunnerHtmlFileName = initShim.getSpecRunnerHtmlFileName();
    this.reporterType = initShim.getReporterType();
    this.reporters = initShim.getReporters();
    this.fileSystemReporters = initShim.getFileSystemReporters();
    this.autoRefreshInterval = initShim.getAutoRefreshInterval();
    this.projectClassLoader = initShim.getProjectClassLoader();
    this.initShim = null;
  }

  private ImmutableJasmineConfiguration(
      File basedir,
      File jasmineTargetDir,
      String srcDirectoryName,
      String specDirectoryName,
      ScriptSearch sources,
      ScriptSearch specs,
      List<Context> contexts,
      List<String> preloadSources,
      String sourceEncoding,
      SpecRunnerTemplate specRunnerTemplate,
      @Nullable File customRunnerTemplate,
      @Nullable File customRunnerConfiguration,
      String specRunnerHtmlFileName,
      ReporterType reporterType,
      List<Reporter> reporters,
      List<FileSystemReporter> fileSystemReporters,
      int autoRefreshInterval,
      ClassLoader projectClassLoader,
      boolean debug) {
    this.basedir = basedir;
    this.jasmineTargetDir = jasmineTargetDir;
    this.srcDirectoryName = srcDirectoryName;
    this.specDirectoryName = specDirectoryName;
    this.sources = sources;
    this.specs = specs;
    this.contexts = contexts;
    this.preloadSources = preloadSources;
    this.sourceEncoding = sourceEncoding;
    this.specRunnerTemplate = specRunnerTemplate;
    this.customRunnerTemplate = customRunnerTemplate;
    this.customRunnerConfiguration = customRunnerConfiguration;
    this.specRunnerHtmlFileName = specRunnerHtmlFileName;
    this.reporterType = reporterType;
    this.reporters = reporters;
    this.fileSystemReporters = fileSystemReporters;
    this.autoRefreshInterval = autoRefreshInterval;
    this.projectClassLoader = projectClassLoader;
    this.debug = debug;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "JasmineConfiguration", generator = "Immutables")
  private final class InitShim {
    private byte srcDirectoryNameBuildStage = STAGE_UNINITIALIZED;
    private String srcDirectoryName;

    String getSrcDirectoryName() {
      if (srcDirectoryNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (srcDirectoryNameBuildStage == STAGE_UNINITIALIZED) {
        srcDirectoryNameBuildStage = STAGE_INITIALIZING;
        this.srcDirectoryName = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSrcDirectoryName(), "srcDirectoryName");
        srcDirectoryNameBuildStage = STAGE_INITIALIZED;
      }
      return this.srcDirectoryName;
    }

    void srcDirectoryName(String srcDirectoryName) {
      this.srcDirectoryName = srcDirectoryName;
      srcDirectoryNameBuildStage = STAGE_INITIALIZED;
    }

    private byte specDirectoryNameBuildStage = STAGE_UNINITIALIZED;
    private String specDirectoryName;

    String getSpecDirectoryName() {
      if (specDirectoryNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (specDirectoryNameBuildStage == STAGE_UNINITIALIZED) {
        specDirectoryNameBuildStage = STAGE_INITIALIZING;
        this.specDirectoryName = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSpecDirectoryName(), "specDirectoryName");
        specDirectoryNameBuildStage = STAGE_INITIALIZED;
      }
      return this.specDirectoryName;
    }

    void specDirectoryName(String specDirectoryName) {
      this.specDirectoryName = specDirectoryName;
      specDirectoryNameBuildStage = STAGE_INITIALIZED;
    }

    private byte sourceEncodingBuildStage = STAGE_UNINITIALIZED;
    private String sourceEncoding;

    String getSourceEncoding() {
      if (sourceEncodingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sourceEncodingBuildStage == STAGE_UNINITIALIZED) {
        sourceEncodingBuildStage = STAGE_INITIALIZING;
        this.sourceEncoding = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSourceEncoding(), "sourceEncoding");
        sourceEncodingBuildStage = STAGE_INITIALIZED;
      }
      return this.sourceEncoding;
    }

    void sourceEncoding(String sourceEncoding) {
      this.sourceEncoding = sourceEncoding;
      sourceEncodingBuildStage = STAGE_INITIALIZED;
    }

    private byte specRunnerTemplateBuildStage = STAGE_UNINITIALIZED;
    private SpecRunnerTemplate specRunnerTemplate;

    SpecRunnerTemplate getSpecRunnerTemplate() {
      if (specRunnerTemplateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (specRunnerTemplateBuildStage == STAGE_UNINITIALIZED) {
        specRunnerTemplateBuildStage = STAGE_INITIALIZING;
        this.specRunnerTemplate = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSpecRunnerTemplate(), "specRunnerTemplate");
        specRunnerTemplateBuildStage = STAGE_INITIALIZED;
      }
      return this.specRunnerTemplate;
    }

    void specRunnerTemplate(SpecRunnerTemplate specRunnerTemplate) {
      this.specRunnerTemplate = specRunnerTemplate;
      specRunnerTemplateBuildStage = STAGE_INITIALIZED;
    }

    private byte specRunnerHtmlFileNameBuildStage = STAGE_UNINITIALIZED;
    private String specRunnerHtmlFileName;

    String getSpecRunnerHtmlFileName() {
      if (specRunnerHtmlFileNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (specRunnerHtmlFileNameBuildStage == STAGE_UNINITIALIZED) {
        specRunnerHtmlFileNameBuildStage = STAGE_INITIALIZING;
        this.specRunnerHtmlFileName = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getSpecRunnerHtmlFileName(), "specRunnerHtmlFileName");
        specRunnerHtmlFileNameBuildStage = STAGE_INITIALIZED;
      }
      return this.specRunnerHtmlFileName;
    }

    void specRunnerHtmlFileName(String specRunnerHtmlFileName) {
      this.specRunnerHtmlFileName = specRunnerHtmlFileName;
      specRunnerHtmlFileNameBuildStage = STAGE_INITIALIZED;
    }

    private byte reporterTypeBuildStage = STAGE_UNINITIALIZED;
    private ReporterType reporterType;

    ReporterType getReporterType() {
      if (reporterTypeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (reporterTypeBuildStage == STAGE_UNINITIALIZED) {
        reporterTypeBuildStage = STAGE_INITIALIZING;
        this.reporterType = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getReporterType(), "reporterType");
        reporterTypeBuildStage = STAGE_INITIALIZED;
      }
      return this.reporterType;
    }

    void reporterType(ReporterType reporterType) {
      this.reporterType = reporterType;
      reporterTypeBuildStage = STAGE_INITIALIZED;
    }

    private byte reportersBuildStage = STAGE_UNINITIALIZED;
    private List<Reporter> reporters;

    List<Reporter> getReporters() {
      if (reportersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (reportersBuildStage == STAGE_UNINITIALIZED) {
        reportersBuildStage = STAGE_INITIALIZING;
        this.reporters = createUnmodifiableList(false, createSafeList(ImmutableJasmineConfiguration.super.getReporters(), true, false));
        reportersBuildStage = STAGE_INITIALIZED;
      }
      return this.reporters;
    }

    void reporters(List<Reporter> reporters) {
      this.reporters = reporters;
      reportersBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSystemReportersBuildStage = STAGE_UNINITIALIZED;
    private List<FileSystemReporter> fileSystemReporters;

    List<FileSystemReporter> getFileSystemReporters() {
      if (fileSystemReportersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSystemReportersBuildStage == STAGE_UNINITIALIZED) {
        fileSystemReportersBuildStage = STAGE_INITIALIZING;
        this.fileSystemReporters = createUnmodifiableList(false, createSafeList(ImmutableJasmineConfiguration.super.getFileSystemReporters(), true, false));
        fileSystemReportersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSystemReporters;
    }

    void fileSystemReporters(List<FileSystemReporter> fileSystemReporters) {
      this.fileSystemReporters = fileSystemReporters;
      fileSystemReportersBuildStage = STAGE_INITIALIZED;
    }

    private byte autoRefreshIntervalBuildStage = STAGE_UNINITIALIZED;
    private int autoRefreshInterval;

    int getAutoRefreshInterval() {
      if (autoRefreshIntervalBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (autoRefreshIntervalBuildStage == STAGE_UNINITIALIZED) {
        autoRefreshIntervalBuildStage = STAGE_INITIALIZING;
        this.autoRefreshInterval = ImmutableJasmineConfiguration.super.getAutoRefreshInterval();
        autoRefreshIntervalBuildStage = STAGE_INITIALIZED;
      }
      return this.autoRefreshInterval;
    }

    void autoRefreshInterval(int autoRefreshInterval) {
      this.autoRefreshInterval = autoRefreshInterval;
      autoRefreshIntervalBuildStage = STAGE_INITIALIZED;
    }

    private byte projectClassLoaderBuildStage = STAGE_UNINITIALIZED;
    private ClassLoader projectClassLoader;

    ClassLoader getProjectClassLoader() {
      if (projectClassLoaderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (projectClassLoaderBuildStage == STAGE_UNINITIALIZED) {
        projectClassLoaderBuildStage = STAGE_INITIALIZING;
        this.projectClassLoader = Objects.requireNonNull(ImmutableJasmineConfiguration.super.getProjectClassLoader(), "projectClassLoader");
        projectClassLoaderBuildStage = STAGE_INITIALIZED;
      }
      return this.projectClassLoader;
    }

    void projectClassLoader(ClassLoader projectClassLoader) {
      this.projectClassLoader = projectClassLoader;
      projectClassLoaderBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (srcDirectoryNameBuildStage == STAGE_INITIALIZING) attributes.add("srcDirectoryName");
      if (specDirectoryNameBuildStage == STAGE_INITIALIZING) attributes.add("specDirectoryName");
      if (sourceEncodingBuildStage == STAGE_INITIALIZING) attributes.add("sourceEncoding");
      if (specRunnerTemplateBuildStage == STAGE_INITIALIZING) attributes.add("specRunnerTemplate");
      if (specRunnerHtmlFileNameBuildStage == STAGE_INITIALIZING) attributes.add("specRunnerHtmlFileName");
      if (reporterTypeBuildStage == STAGE_INITIALIZING) attributes.add("reporterType");
      if (reportersBuildStage == STAGE_INITIALIZING) attributes.add("reporters");
      if (fileSystemReportersBuildStage == STAGE_INITIALIZING) attributes.add("fileSystemReporters");
      if (autoRefreshIntervalBuildStage == STAGE_INITIALIZING) attributes.add("autoRefreshInterval");
      if (projectClassLoaderBuildStage == STAGE_INITIALIZING) attributes.add("projectClassLoader");
      return "Cannot build JasmineConfiguration, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code basedir} attribute
   */
  @Override
  public File getBasedir() {
    return basedir;
  }

  /**
   * @return The value of the {@code jasmineTargetDir} attribute
   */
  @Override
  public File getJasmineTargetDir() {
    return jasmineTargetDir;
  }

  /**
   * @return The value of the {@code srcDirectoryName} attribute
   */
  @Override
  public String getSrcDirectoryName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSrcDirectoryName()
        : this.srcDirectoryName;
  }

  /**
   * @return The value of the {@code specDirectoryName} attribute
   */
  @Override
  public String getSpecDirectoryName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSpecDirectoryName()
        : this.specDirectoryName;
  }

  /**
   * @return The value of the {@code sources} attribute
   */
  @Override
  public ScriptSearch getSources() {
    return sources;
  }

  /**
   * @return The value of the {@code specs} attribute
   */
  @Override
  public ScriptSearch getSpecs() {
    return specs;
  }

  /**
   * @return The value of the {@code contexts} attribute
   */
  @Override
  public List<Context> getContexts() {
    return contexts;
  }

  /**
   * @return The value of the {@code preloadSources} attribute
   */
  @Override
  public List<String> getPreloadSources() {
    return preloadSources;
  }

  /**
   * @return The value of the {@code sourceEncoding} attribute
   */
  @Override
  public String getSourceEncoding() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSourceEncoding()
        : this.sourceEncoding;
  }

  /**
   * @return The value of the {@code specRunnerTemplate} attribute
   */
  @Override
  public SpecRunnerTemplate getSpecRunnerTemplate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSpecRunnerTemplate()
        : this.specRunnerTemplate;
  }

  /**
   * @return The value of the {@code customRunnerTemplate} attribute
   */
  @Override
  public Optional<File> getCustomRunnerTemplate() {
    return Optional.ofNullable(customRunnerTemplate);
  }

  /**
   * @return The value of the {@code customRunnerConfiguration} attribute
   */
  @Override
  public Optional<File> getCustomRunnerConfiguration() {
    return Optional.ofNullable(customRunnerConfiguration);
  }

  /**
   * @return The value of the {@code specRunnerHtmlFileName} attribute
   */
  @Override
  public String getSpecRunnerHtmlFileName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSpecRunnerHtmlFileName()
        : this.specRunnerHtmlFileName;
  }

  /**
   * @return The value of the {@code reporterType} attribute
   */
  @Override
  public ReporterType getReporterType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getReporterType()
        : this.reporterType;
  }

  /**
   * @return The value of the {@code reporters} attribute
   */
  @Override
  public List<Reporter> getReporters() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getReporters()
        : this.reporters;
  }

  /**
   * @return The value of the {@code fileSystemReporters} attribute
   */
  @Override
  public List<FileSystemReporter> getFileSystemReporters() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFileSystemReporters()
        : this.fileSystemReporters;
  }

  /**
   * @return The value of the {@code autoRefreshInterval} attribute
   */
  @Override
  public int getAutoRefreshInterval() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAutoRefreshInterval()
        : this.autoRefreshInterval;
  }

  /**
   * @return The value of the {@code projectClassLoader} attribute
   */
  @Override
  public ClassLoader getProjectClassLoader() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getProjectClassLoader()
        : this.projectClassLoader;
  }

  /**
   * @return The value of the {@code debug} attribute
   */
  @Override
  public boolean isDebug() {
    return debug;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getBasedir() basedir} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for basedir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withBasedir(File value) {
    if (this.basedir == value) return this;
    File newValue = Objects.requireNonNull(value, "basedir");
    return new ImmutableJasmineConfiguration(
        newValue,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getJasmineTargetDir() jasmineTargetDir} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jasmineTargetDir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withJasmineTargetDir(File value) {
    if (this.jasmineTargetDir == value) return this;
    File newValue = Objects.requireNonNull(value, "jasmineTargetDir");
    return new ImmutableJasmineConfiguration(
        this.basedir,
        newValue,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getSrcDirectoryName() srcDirectoryName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for srcDirectoryName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withSrcDirectoryName(String value) {
    String newValue = Objects.requireNonNull(value, "srcDirectoryName");
    if (this.srcDirectoryName.equals(newValue)) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        newValue,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getSpecDirectoryName() specDirectoryName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specDirectoryName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withSpecDirectoryName(String value) {
    String newValue = Objects.requireNonNull(value, "specDirectoryName");
    if (this.specDirectoryName.equals(newValue)) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        newValue,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getSources() sources} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sources
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withSources(ScriptSearch value) {
    if (this.sources == value) return this;
    ScriptSearch newValue = Objects.requireNonNull(value, "sources");
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        newValue,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getSpecs() specs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withSpecs(ScriptSearch value) {
    if (this.specs == value) return this;
    ScriptSearch newValue = Objects.requireNonNull(value, "specs");
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        newValue,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JasmineConfiguration#getContexts() contexts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withContexts(Context... elements) {
    List<Context> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        newValue,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JasmineConfiguration#getContexts() contexts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of contexts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withContexts(Iterable<? extends Context> elements) {
    if (this.contexts == elements) return this;
    List<Context> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        newValue,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JasmineConfiguration#getPreloadSources() preloadSources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withPreloadSources(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        newValue,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JasmineConfiguration#getPreloadSources() preloadSources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of preloadSources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withPreloadSources(Iterable<String> elements) {
    if (this.preloadSources == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        newValue,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getSourceEncoding() sourceEncoding} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sourceEncoding
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withSourceEncoding(String value) {
    String newValue = Objects.requireNonNull(value, "sourceEncoding");
    if (this.sourceEncoding.equals(newValue)) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        newValue,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getSpecRunnerTemplate() specRunnerTemplate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specRunnerTemplate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withSpecRunnerTemplate(SpecRunnerTemplate value) {
    if (this.specRunnerTemplate == value) return this;
    SpecRunnerTemplate newValue = Objects.requireNonNull(value, "specRunnerTemplate");
    if (this.specRunnerTemplate.equals(newValue)) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        newValue,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JasmineConfiguration#getCustomRunnerTemplate() customRunnerTemplate} attribute.
   * @param value The value for customRunnerTemplate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withCustomRunnerTemplate(File value) {
    @Nullable File newValue = Objects.requireNonNull(value, "customRunnerTemplate");
    if (this.customRunnerTemplate == newValue) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        newValue,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JasmineConfiguration#getCustomRunnerTemplate() customRunnerTemplate} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for customRunnerTemplate
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableJasmineConfiguration withCustomRunnerTemplate(Optional<? extends File> optional) {
    @Nullable File value = optional.orElse(null);
    if (this.customRunnerTemplate == value) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        value,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JasmineConfiguration#getCustomRunnerConfiguration() customRunnerConfiguration} attribute.
   * @param value The value for customRunnerConfiguration
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withCustomRunnerConfiguration(File value) {
    @Nullable File newValue = Objects.requireNonNull(value, "customRunnerConfiguration");
    if (this.customRunnerConfiguration == newValue) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        newValue,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JasmineConfiguration#getCustomRunnerConfiguration() customRunnerConfiguration} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for customRunnerConfiguration
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableJasmineConfiguration withCustomRunnerConfiguration(Optional<? extends File> optional) {
    @Nullable File value = optional.orElse(null);
    if (this.customRunnerConfiguration == value) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        value,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getSpecRunnerHtmlFileName() specRunnerHtmlFileName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specRunnerHtmlFileName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withSpecRunnerHtmlFileName(String value) {
    String newValue = Objects.requireNonNull(value, "specRunnerHtmlFileName");
    if (this.specRunnerHtmlFileName.equals(newValue)) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        newValue,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getReporterType() reporterType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reporterType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withReporterType(ReporterType value) {
    if (this.reporterType == value) return this;
    ReporterType newValue = Objects.requireNonNull(value, "reporterType");
    if (this.reporterType.equals(newValue)) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        newValue,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JasmineConfiguration#getReporters() reporters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withReporters(Reporter... elements) {
    List<Reporter> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        newValue,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JasmineConfiguration#getReporters() reporters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of reporters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withReporters(Iterable<? extends Reporter> elements) {
    if (this.reporters == elements) return this;
    List<Reporter> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        newValue,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JasmineConfiguration#getFileSystemReporters() fileSystemReporters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withFileSystemReporters(FileSystemReporter... elements) {
    List<FileSystemReporter> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        newValue,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JasmineConfiguration#getFileSystemReporters() fileSystemReporters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSystemReporters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJasmineConfiguration withFileSystemReporters(Iterable<? extends FileSystemReporter> elements) {
    if (this.fileSystemReporters == elements) return this;
    List<FileSystemReporter> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        newValue,
        this.autoRefreshInterval,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getAutoRefreshInterval() autoRefreshInterval} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autoRefreshInterval
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withAutoRefreshInterval(int value) {
    if (this.autoRefreshInterval == value) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        value,
        this.projectClassLoader,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#getProjectClassLoader() projectClassLoader} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projectClassLoader
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withProjectClassLoader(ClassLoader value) {
    if (this.projectClassLoader == value) return this;
    ClassLoader newValue = Objects.requireNonNull(value, "projectClassLoader");
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        newValue,
        this.debug);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JasmineConfiguration#isDebug() debug} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for debug
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJasmineConfiguration withDebug(boolean value) {
    if (this.debug == value) return this;
    return new ImmutableJasmineConfiguration(
        this.basedir,
        this.jasmineTargetDir,
        this.srcDirectoryName,
        this.specDirectoryName,
        this.sources,
        this.specs,
        this.contexts,
        this.preloadSources,
        this.sourceEncoding,
        this.specRunnerTemplate,
        this.customRunnerTemplate,
        this.customRunnerConfiguration,
        this.specRunnerHtmlFileName,
        this.reporterType,
        this.reporters,
        this.fileSystemReporters,
        this.autoRefreshInterval,
        this.projectClassLoader,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJasmineConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJasmineConfiguration
        && equalTo((ImmutableJasmineConfiguration) another);
  }

  private boolean equalTo(ImmutableJasmineConfiguration another) {
    return basedir.equals(another.basedir)
        && jasmineTargetDir.equals(another.jasmineTargetDir)
        && srcDirectoryName.equals(another.srcDirectoryName)
        && specDirectoryName.equals(another.specDirectoryName)
        && sources.equals(another.sources)
        && specs.equals(another.specs)
        && contexts.equals(another.contexts)
        && preloadSources.equals(another.preloadSources)
        && sourceEncoding.equals(another.sourceEncoding)
        && specRunnerTemplate.equals(another.specRunnerTemplate)
        && Objects.equals(customRunnerTemplate, another.customRunnerTemplate)
        && Objects.equals(customRunnerConfiguration, another.customRunnerConfiguration)
        && specRunnerHtmlFileName.equals(another.specRunnerHtmlFileName)
        && reporterType.equals(another.reporterType)
        && reporters.equals(another.reporters)
        && fileSystemReporters.equals(another.fileSystemReporters)
        && autoRefreshInterval == another.autoRefreshInterval
        && projectClassLoader.equals(another.projectClassLoader)
        && debug == another.debug;
  }

  /**
   * Computes a hash code from attributes: {@code basedir}, {@code jasmineTargetDir}, {@code srcDirectoryName}, {@code specDirectoryName}, {@code sources}, {@code specs}, {@code contexts}, {@code preloadSources}, {@code sourceEncoding}, {@code specRunnerTemplate}, {@code customRunnerTemplate}, {@code customRunnerConfiguration}, {@code specRunnerHtmlFileName}, {@code reporterType}, {@code reporters}, {@code fileSystemReporters}, {@code autoRefreshInterval}, {@code projectClassLoader}, {@code debug}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + basedir.hashCode();
    h += (h << 5) + jasmineTargetDir.hashCode();
    h += (h << 5) + srcDirectoryName.hashCode();
    h += (h << 5) + specDirectoryName.hashCode();
    h += (h << 5) + sources.hashCode();
    h += (h << 5) + specs.hashCode();
    h += (h << 5) + contexts.hashCode();
    h += (h << 5) + preloadSources.hashCode();
    h += (h << 5) + sourceEncoding.hashCode();
    h += (h << 5) + specRunnerTemplate.hashCode();
    h += (h << 5) + Objects.hashCode(customRunnerTemplate);
    h += (h << 5) + Objects.hashCode(customRunnerConfiguration);
    h += (h << 5) + specRunnerHtmlFileName.hashCode();
    h += (h << 5) + reporterType.hashCode();
    h += (h << 5) + reporters.hashCode();
    h += (h << 5) + fileSystemReporters.hashCode();
    h += (h << 5) + autoRefreshInterval;
    h += (h << 5) + projectClassLoader.hashCode();
    h += (h << 5) + Boolean.hashCode(debug);
    return h;
  }

  /**
   * Prints the immutable value {@code JasmineConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("JasmineConfiguration{");
    builder.append("basedir=").append(basedir);
    builder.append(", ");
    builder.append("jasmineTargetDir=").append(jasmineTargetDir);
    builder.append(", ");
    builder.append("srcDirectoryName=").append(srcDirectoryName);
    builder.append(", ");
    builder.append("specDirectoryName=").append(specDirectoryName);
    builder.append(", ");
    builder.append("sources=").append(sources);
    builder.append(", ");
    builder.append("specs=").append(specs);
    builder.append(", ");
    builder.append("contexts=").append(contexts);
    builder.append(", ");
    builder.append("preloadSources=").append(preloadSources);
    builder.append(", ");
    builder.append("sourceEncoding=").append(sourceEncoding);
    builder.append(", ");
    builder.append("specRunnerTemplate=").append(specRunnerTemplate);
    if (customRunnerTemplate != null) {
      builder.append(", ");
      builder.append("customRunnerTemplate=").append(customRunnerTemplate);
    }
    if (customRunnerConfiguration != null) {
      builder.append(", ");
      builder.append("customRunnerConfiguration=").append(customRunnerConfiguration);
    }
    builder.append(", ");
    builder.append("specRunnerHtmlFileName=").append(specRunnerHtmlFileName);
    builder.append(", ");
    builder.append("reporterType=").append(reporterType);
    builder.append(", ");
    builder.append("reporters=").append(reporters);
    builder.append(", ");
    builder.append("fileSystemReporters=").append(fileSystemReporters);
    builder.append(", ");
    builder.append("autoRefreshInterval=").append(autoRefreshInterval);
    builder.append(", ");
    builder.append("projectClassLoader=").append(projectClassLoader);
    builder.append(", ");
    builder.append("debug=").append(debug);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link JasmineConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JasmineConfiguration instance
   */
  public static ImmutableJasmineConfiguration copyOf(JasmineConfiguration instance) {
    if (instance instanceof ImmutableJasmineConfiguration) {
      return (ImmutableJasmineConfiguration) instance;
    }
    return ImmutableJasmineConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJasmineConfiguration ImmutableJasmineConfiguration}.
   * <pre>
   * ImmutableJasmineConfiguration.builder()
   *    .basedir(java.io.File) // required {@link JasmineConfiguration#getBasedir() basedir}
   *    .jasmineTargetDir(java.io.File) // required {@link JasmineConfiguration#getJasmineTargetDir() jasmineTargetDir}
   *    .srcDirectoryName(String) // optional {@link JasmineConfiguration#getSrcDirectoryName() srcDirectoryName}
   *    .specDirectoryName(String) // optional {@link JasmineConfiguration#getSpecDirectoryName() specDirectoryName}
   *    .sources(com.github.searls.jasmine.model.ScriptSearch) // required {@link JasmineConfiguration#getSources() sources}
   *    .specs(com.github.searls.jasmine.model.ScriptSearch) // required {@link JasmineConfiguration#getSpecs() specs}
   *    .addContexts|addAllContexts(com.github.searls.jasmine.mojo.Context) // {@link JasmineConfiguration#getContexts() contexts} elements
   *    .addPreloadSources|addAllPreloadSources(String) // {@link JasmineConfiguration#getPreloadSources() preloadSources} elements
   *    .sourceEncoding(String) // optional {@link JasmineConfiguration#getSourceEncoding() sourceEncoding}
   *    .specRunnerTemplate(com.github.searls.jasmine.runner.SpecRunnerTemplate) // optional {@link JasmineConfiguration#getSpecRunnerTemplate() specRunnerTemplate}
   *    .customRunnerTemplate(java.io.File) // optional {@link JasmineConfiguration#getCustomRunnerTemplate() customRunnerTemplate}
   *    .customRunnerConfiguration(java.io.File) // optional {@link JasmineConfiguration#getCustomRunnerConfiguration() customRunnerConfiguration}
   *    .specRunnerHtmlFileName(String) // optional {@link JasmineConfiguration#getSpecRunnerHtmlFileName() specRunnerHtmlFileName}
   *    .reporterType(com.github.searls.jasmine.runner.ReporterType) // optional {@link JasmineConfiguration#getReporterType() reporterType}
   *    .addReporters|addAllReporters(com.github.searls.jasmine.model.Reporter) // {@link JasmineConfiguration#getReporters() reporters} elements
   *    .addFileSystemReporters|addAllFileSystemReporters(com.github.searls.jasmine.model.FileSystemReporter) // {@link JasmineConfiguration#getFileSystemReporters() fileSystemReporters} elements
   *    .autoRefreshInterval(int) // optional {@link JasmineConfiguration#getAutoRefreshInterval() autoRefreshInterval}
   *    .projectClassLoader(ClassLoader) // optional {@link JasmineConfiguration#getProjectClassLoader() projectClassLoader}
   *    .debug(boolean) // required {@link JasmineConfiguration#isDebug() debug}
   *    .build();
   * </pre>
   * @return A new ImmutableJasmineConfiguration builder
   */
  public static ImmutableJasmineConfiguration.Builder builder() {
    return new ImmutableJasmineConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJasmineConfiguration ImmutableJasmineConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JasmineConfiguration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BASEDIR = 0x1L;
    private static final long INIT_BIT_JASMINE_TARGET_DIR = 0x2L;
    private static final long INIT_BIT_SOURCES = 0x4L;
    private static final long INIT_BIT_SPECS = 0x8L;
    private static final long INIT_BIT_DEBUG = 0x10L;
    private static final long OPT_BIT_REPORTERS = 0x1L;
    private static final long OPT_BIT_FILE_SYSTEM_REPORTERS = 0x2L;
    private static final long OPT_BIT_AUTO_REFRESH_INTERVAL = 0x4L;
    private long initBits = 0x1fL;
    private long optBits;

    private @Nullable File basedir;
    private @Nullable File jasmineTargetDir;
    private @Nullable String srcDirectoryName;
    private @Nullable String specDirectoryName;
    private @Nullable ScriptSearch sources;
    private @Nullable ScriptSearch specs;
    private List<Context> contexts = new ArrayList<Context>();
    private List<String> preloadSources = new ArrayList<String>();
    private @Nullable String sourceEncoding;
    private @Nullable SpecRunnerTemplate specRunnerTemplate;
    private @Nullable File customRunnerTemplate;
    private @Nullable File customRunnerConfiguration;
    private @Nullable String specRunnerHtmlFileName;
    private @Nullable ReporterType reporterType;
    private List<Reporter> reporters = new ArrayList<Reporter>();
    private List<FileSystemReporter> fileSystemReporters = new ArrayList<FileSystemReporter>();
    private int autoRefreshInterval;
    private @Nullable ClassLoader projectClassLoader;
    private boolean debug;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JasmineConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JasmineConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      basedir(instance.getBasedir());
      jasmineTargetDir(instance.getJasmineTargetDir());
      srcDirectoryName(instance.getSrcDirectoryName());
      specDirectoryName(instance.getSpecDirectoryName());
      sources(instance.getSources());
      specs(instance.getSpecs());
      addAllContexts(instance.getContexts());
      addAllPreloadSources(instance.getPreloadSources());
      sourceEncoding(instance.getSourceEncoding());
      specRunnerTemplate(instance.getSpecRunnerTemplate());
      Optional<File> customRunnerTemplateOptional = instance.getCustomRunnerTemplate();
      if (customRunnerTemplateOptional.isPresent()) {
        customRunnerTemplate(customRunnerTemplateOptional);
      }
      Optional<File> customRunnerConfigurationOptional = instance.getCustomRunnerConfiguration();
      if (customRunnerConfigurationOptional.isPresent()) {
        customRunnerConfiguration(customRunnerConfigurationOptional);
      }
      specRunnerHtmlFileName(instance.getSpecRunnerHtmlFileName());
      reporterType(instance.getReporterType());
      addAllReporters(instance.getReporters());
      addAllFileSystemReporters(instance.getFileSystemReporters());
      autoRefreshInterval(instance.getAutoRefreshInterval());
      projectClassLoader(instance.getProjectClassLoader());
      debug(instance.isDebug());
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getBasedir() basedir} attribute.
     * @param basedir The value for basedir 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder basedir(File basedir) {
      this.basedir = Objects.requireNonNull(basedir, "basedir");
      initBits &= ~INIT_BIT_BASEDIR;
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getJasmineTargetDir() jasmineTargetDir} attribute.
     * @param jasmineTargetDir The value for jasmineTargetDir 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder jasmineTargetDir(File jasmineTargetDir) {
      this.jasmineTargetDir = Objects.requireNonNull(jasmineTargetDir, "jasmineTargetDir");
      initBits &= ~INIT_BIT_JASMINE_TARGET_DIR;
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getSrcDirectoryName() srcDirectoryName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link JasmineConfiguration#getSrcDirectoryName() srcDirectoryName}.</em>
     * @param srcDirectoryName The value for srcDirectoryName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder srcDirectoryName(String srcDirectoryName) {
      this.srcDirectoryName = Objects.requireNonNull(srcDirectoryName, "srcDirectoryName");
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getSpecDirectoryName() specDirectoryName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link JasmineConfiguration#getSpecDirectoryName() specDirectoryName}.</em>
     * @param specDirectoryName The value for specDirectoryName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder specDirectoryName(String specDirectoryName) {
      this.specDirectoryName = Objects.requireNonNull(specDirectoryName, "specDirectoryName");
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getSources() sources} attribute.
     * @param sources The value for sources 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sources(ScriptSearch sources) {
      this.sources = Objects.requireNonNull(sources, "sources");
      initBits &= ~INIT_BIT_SOURCES;
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getSpecs() specs} attribute.
     * @param specs The value for specs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder specs(ScriptSearch specs) {
      this.specs = Objects.requireNonNull(specs, "specs");
      initBits &= ~INIT_BIT_SPECS;
      return this;
    }

    /**
     * Adds one element to {@link JasmineConfiguration#getContexts() contexts} list.
     * @param element A contexts element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addContexts(Context element) {
      this.contexts.add(Objects.requireNonNull(element, "contexts element"));
      return this;
    }

    /**
     * Adds elements to {@link JasmineConfiguration#getContexts() contexts} list.
     * @param elements An array of contexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addContexts(Context... elements) {
      for (Context element : elements) {
        this.contexts.add(Objects.requireNonNull(element, "contexts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JasmineConfiguration#getContexts() contexts} list.
     * @param elements An iterable of contexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contexts(Iterable<? extends Context> elements) {
      this.contexts.clear();
      return addAllContexts(elements);
    }

    /**
     * Adds elements to {@link JasmineConfiguration#getContexts() contexts} list.
     * @param elements An iterable of contexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllContexts(Iterable<? extends Context> elements) {
      for (Context element : elements) {
        this.contexts.add(Objects.requireNonNull(element, "contexts element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link JasmineConfiguration#getPreloadSources() preloadSources} list.
     * @param element A preloadSources element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPreloadSources(String element) {
      this.preloadSources.add(Objects.requireNonNull(element, "preloadSources element"));
      return this;
    }

    /**
     * Adds elements to {@link JasmineConfiguration#getPreloadSources() preloadSources} list.
     * @param elements An array of preloadSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPreloadSources(String... elements) {
      for (String element : elements) {
        this.preloadSources.add(Objects.requireNonNull(element, "preloadSources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JasmineConfiguration#getPreloadSources() preloadSources} list.
     * @param elements An iterable of preloadSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder preloadSources(Iterable<String> elements) {
      this.preloadSources.clear();
      return addAllPreloadSources(elements);
    }

    /**
     * Adds elements to {@link JasmineConfiguration#getPreloadSources() preloadSources} list.
     * @param elements An iterable of preloadSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPreloadSources(Iterable<String> elements) {
      for (String element : elements) {
        this.preloadSources.add(Objects.requireNonNull(element, "preloadSources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getSourceEncoding() sourceEncoding} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link JasmineConfiguration#getSourceEncoding() sourceEncoding}.</em>
     * @param sourceEncoding The value for sourceEncoding 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sourceEncoding(String sourceEncoding) {
      this.sourceEncoding = Objects.requireNonNull(sourceEncoding, "sourceEncoding");
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getSpecRunnerTemplate() specRunnerTemplate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link JasmineConfiguration#getSpecRunnerTemplate() specRunnerTemplate}.</em>
     * @param specRunnerTemplate The value for specRunnerTemplate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder specRunnerTemplate(SpecRunnerTemplate specRunnerTemplate) {
      this.specRunnerTemplate = Objects.requireNonNull(specRunnerTemplate, "specRunnerTemplate");
      return this;
    }

    /**
     * Initializes the optional value {@link JasmineConfiguration#getCustomRunnerTemplate() customRunnerTemplate} to customRunnerTemplate.
     * @param customRunnerTemplate The value for customRunnerTemplate
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customRunnerTemplate(File customRunnerTemplate) {
      this.customRunnerTemplate = Objects.requireNonNull(customRunnerTemplate, "customRunnerTemplate");
      return this;
    }

    /**
     * Initializes the optional value {@link JasmineConfiguration#getCustomRunnerTemplate() customRunnerTemplate} to customRunnerTemplate.
     * @param customRunnerTemplate The value for customRunnerTemplate
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customRunnerTemplate(Optional<? extends File> customRunnerTemplate) {
      this.customRunnerTemplate = customRunnerTemplate.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link JasmineConfiguration#getCustomRunnerConfiguration() customRunnerConfiguration} to customRunnerConfiguration.
     * @param customRunnerConfiguration The value for customRunnerConfiguration
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customRunnerConfiguration(File customRunnerConfiguration) {
      this.customRunnerConfiguration = Objects.requireNonNull(customRunnerConfiguration, "customRunnerConfiguration");
      return this;
    }

    /**
     * Initializes the optional value {@link JasmineConfiguration#getCustomRunnerConfiguration() customRunnerConfiguration} to customRunnerConfiguration.
     * @param customRunnerConfiguration The value for customRunnerConfiguration
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customRunnerConfiguration(Optional<? extends File> customRunnerConfiguration) {
      this.customRunnerConfiguration = customRunnerConfiguration.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getSpecRunnerHtmlFileName() specRunnerHtmlFileName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link JasmineConfiguration#getSpecRunnerHtmlFileName() specRunnerHtmlFileName}.</em>
     * @param specRunnerHtmlFileName The value for specRunnerHtmlFileName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder specRunnerHtmlFileName(String specRunnerHtmlFileName) {
      this.specRunnerHtmlFileName = Objects.requireNonNull(specRunnerHtmlFileName, "specRunnerHtmlFileName");
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getReporterType() reporterType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link JasmineConfiguration#getReporterType() reporterType}.</em>
     * @param reporterType The value for reporterType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reporterType(ReporterType reporterType) {
      this.reporterType = Objects.requireNonNull(reporterType, "reporterType");
      return this;
    }

    /**
     * Adds one element to {@link JasmineConfiguration#getReporters() reporters} list.
     * @param element A reporters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReporters(Reporter element) {
      this.reporters.add(Objects.requireNonNull(element, "reporters element"));
      optBits |= OPT_BIT_REPORTERS;
      return this;
    }

    /**
     * Adds elements to {@link JasmineConfiguration#getReporters() reporters} list.
     * @param elements An array of reporters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReporters(Reporter... elements) {
      for (Reporter element : elements) {
        this.reporters.add(Objects.requireNonNull(element, "reporters element"));
      }
      optBits |= OPT_BIT_REPORTERS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JasmineConfiguration#getReporters() reporters} list.
     * @param elements An iterable of reporters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reporters(Iterable<? extends Reporter> elements) {
      this.reporters.clear();
      return addAllReporters(elements);
    }

    /**
     * Adds elements to {@link JasmineConfiguration#getReporters() reporters} list.
     * @param elements An iterable of reporters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllReporters(Iterable<? extends Reporter> elements) {
      for (Reporter element : elements) {
        this.reporters.add(Objects.requireNonNull(element, "reporters element"));
      }
      optBits |= OPT_BIT_REPORTERS;
      return this;
    }

    /**
     * Adds one element to {@link JasmineConfiguration#getFileSystemReporters() fileSystemReporters} list.
     * @param element A fileSystemReporters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSystemReporters(FileSystemReporter element) {
      this.fileSystemReporters.add(Objects.requireNonNull(element, "fileSystemReporters element"));
      optBits |= OPT_BIT_FILE_SYSTEM_REPORTERS;
      return this;
    }

    /**
     * Adds elements to {@link JasmineConfiguration#getFileSystemReporters() fileSystemReporters} list.
     * @param elements An array of fileSystemReporters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSystemReporters(FileSystemReporter... elements) {
      for (FileSystemReporter element : elements) {
        this.fileSystemReporters.add(Objects.requireNonNull(element, "fileSystemReporters element"));
      }
      optBits |= OPT_BIT_FILE_SYSTEM_REPORTERS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JasmineConfiguration#getFileSystemReporters() fileSystemReporters} list.
     * @param elements An iterable of fileSystemReporters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fileSystemReporters(Iterable<? extends FileSystemReporter> elements) {
      this.fileSystemReporters.clear();
      return addAllFileSystemReporters(elements);
    }

    /**
     * Adds elements to {@link JasmineConfiguration#getFileSystemReporters() fileSystemReporters} list.
     * @param elements An iterable of fileSystemReporters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFileSystemReporters(Iterable<? extends FileSystemReporter> elements) {
      for (FileSystemReporter element : elements) {
        this.fileSystemReporters.add(Objects.requireNonNull(element, "fileSystemReporters element"));
      }
      optBits |= OPT_BIT_FILE_SYSTEM_REPORTERS;
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getAutoRefreshInterval() autoRefreshInterval} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link JasmineConfiguration#getAutoRefreshInterval() autoRefreshInterval}.</em>
     * @param autoRefreshInterval The value for autoRefreshInterval 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder autoRefreshInterval(int autoRefreshInterval) {
      this.autoRefreshInterval = autoRefreshInterval;
      optBits |= OPT_BIT_AUTO_REFRESH_INTERVAL;
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#getProjectClassLoader() projectClassLoader} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link JasmineConfiguration#getProjectClassLoader() projectClassLoader}.</em>
     * @param projectClassLoader The value for projectClassLoader 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder projectClassLoader(ClassLoader projectClassLoader) {
      this.projectClassLoader = Objects.requireNonNull(projectClassLoader, "projectClassLoader");
      return this;
    }

    /**
     * Initializes the value for the {@link JasmineConfiguration#isDebug() debug} attribute.
     * @param debug The value for debug 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder debug(boolean debug) {
      this.debug = debug;
      initBits &= ~INIT_BIT_DEBUG;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJasmineConfiguration ImmutableJasmineConfiguration}.
     * @return An immutable instance of JasmineConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJasmineConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJasmineConfiguration(this);
    }

    private boolean reportersIsSet() {
      return (optBits & OPT_BIT_REPORTERS) != 0;
    }

    private boolean fileSystemReportersIsSet() {
      return (optBits & OPT_BIT_FILE_SYSTEM_REPORTERS) != 0;
    }

    private boolean autoRefreshIntervalIsSet() {
      return (optBits & OPT_BIT_AUTO_REFRESH_INTERVAL) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BASEDIR) != 0) attributes.add("basedir");
      if ((initBits & INIT_BIT_JASMINE_TARGET_DIR) != 0) attributes.add("jasmineTargetDir");
      if ((initBits & INIT_BIT_SOURCES) != 0) attributes.add("sources");
      if ((initBits & INIT_BIT_SPECS) != 0) attributes.add("specs");
      if ((initBits & INIT_BIT_DEBUG) != 0) attributes.add("debug");
      return "Cannot build JasmineConfiguration, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
