package com.github.searls.jasmine.config;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ServerConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServerConfiguration.builder()}.
 */
@Generated(from = "ServerConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableServerConfiguration extends ServerConfiguration {
  private final String uriScheme;
  private final String serverHostname;
  private final int serverPort;

  private ImmutableServerConfiguration(ImmutableServerConfiguration.Builder builder) {
    if (builder.uriScheme != null) {
      initShim.uriScheme(builder.uriScheme);
    }
    if (builder.serverHostname != null) {
      initShim.serverHostname(builder.serverHostname);
    }
    if (builder.serverPortIsSet()) {
      initShim.serverPort(builder.serverPort);
    }
    this.uriScheme = initShim.getUriScheme();
    this.serverHostname = initShim.getServerHostname();
    this.serverPort = initShim.getServerPort();
    this.initShim = null;
  }

  private ImmutableServerConfiguration(String uriScheme, String serverHostname, int serverPort) {
    this.uriScheme = uriScheme;
    this.serverHostname = serverHostname;
    this.serverPort = serverPort;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ServerConfiguration", generator = "Immutables")
  private final class InitShim {
    private byte uriSchemeBuildStage = STAGE_UNINITIALIZED;
    private String uriScheme;

    String getUriScheme() {
      if (uriSchemeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (uriSchemeBuildStage == STAGE_UNINITIALIZED) {
        uriSchemeBuildStage = STAGE_INITIALIZING;
        this.uriScheme = Objects.requireNonNull(ImmutableServerConfiguration.super.getUriScheme(), "uriScheme");
        uriSchemeBuildStage = STAGE_INITIALIZED;
      }
      return this.uriScheme;
    }

    void uriScheme(String uriScheme) {
      this.uriScheme = uriScheme;
      uriSchemeBuildStage = STAGE_INITIALIZED;
    }

    private byte serverHostnameBuildStage = STAGE_UNINITIALIZED;
    private String serverHostname;

    String getServerHostname() {
      if (serverHostnameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serverHostnameBuildStage == STAGE_UNINITIALIZED) {
        serverHostnameBuildStage = STAGE_INITIALIZING;
        this.serverHostname = Objects.requireNonNull(ImmutableServerConfiguration.super.getServerHostname(), "serverHostname");
        serverHostnameBuildStage = STAGE_INITIALIZED;
      }
      return this.serverHostname;
    }

    void serverHostname(String serverHostname) {
      this.serverHostname = serverHostname;
      serverHostnameBuildStage = STAGE_INITIALIZED;
    }

    private byte serverPortBuildStage = STAGE_UNINITIALIZED;
    private int serverPort;

    int getServerPort() {
      if (serverPortBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serverPortBuildStage == STAGE_UNINITIALIZED) {
        serverPortBuildStage = STAGE_INITIALIZING;
        this.serverPort = ImmutableServerConfiguration.super.getServerPort();
        serverPortBuildStage = STAGE_INITIALIZED;
      }
      return this.serverPort;
    }

    void serverPort(int serverPort) {
      this.serverPort = serverPort;
      serverPortBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (uriSchemeBuildStage == STAGE_INITIALIZING) attributes.add("uriScheme");
      if (serverHostnameBuildStage == STAGE_INITIALIZING) attributes.add("serverHostname");
      if (serverPortBuildStage == STAGE_INITIALIZING) attributes.add("serverPort");
      return "Cannot build ServerConfiguration, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code uriScheme} attribute
   */
  @Override
  public String getUriScheme() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUriScheme()
        : this.uriScheme;
  }

  /**
   * @return The value of the {@code serverHostname} attribute
   */
  @Override
  public String getServerHostname() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getServerHostname()
        : this.serverHostname;
  }

  /**
   * @return The value of the {@code serverPort} attribute
   */
  @Override
  public int getServerPort() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getServerPort()
        : this.serverPort;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServerConfiguration#getUriScheme() uriScheme} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uriScheme
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServerConfiguration withUriScheme(String value) {
    String newValue = Objects.requireNonNull(value, "uriScheme");
    if (this.uriScheme.equals(newValue)) return this;
    return new ImmutableServerConfiguration(newValue, this.serverHostname, this.serverPort);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServerConfiguration#getServerHostname() serverHostname} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serverHostname
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServerConfiguration withServerHostname(String value) {
    String newValue = Objects.requireNonNull(value, "serverHostname");
    if (this.serverHostname.equals(newValue)) return this;
    return new ImmutableServerConfiguration(this.uriScheme, newValue, this.serverPort);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServerConfiguration#getServerPort() serverPort} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serverPort
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServerConfiguration withServerPort(int value) {
    if (this.serverPort == value) return this;
    return new ImmutableServerConfiguration(this.uriScheme, this.serverHostname, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServerConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServerConfiguration
        && equalTo((ImmutableServerConfiguration) another);
  }

  private boolean equalTo(ImmutableServerConfiguration another) {
    return uriScheme.equals(another.uriScheme)
        && serverHostname.equals(another.serverHostname)
        && serverPort == another.serverPort;
  }

  /**
   * Computes a hash code from attributes: {@code uriScheme}, {@code serverHostname}, {@code serverPort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + uriScheme.hashCode();
    h += (h << 5) + serverHostname.hashCode();
    h += (h << 5) + serverPort;
    return h;
  }

  /**
   * Prints the immutable value {@code ServerConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServerConfiguration")
        .omitNullValues()
        .add("uriScheme", uriScheme)
        .add("serverHostname", serverHostname)
        .add("serverPort", serverPort)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ServerConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServerConfiguration instance
   */
  public static ImmutableServerConfiguration copyOf(ServerConfiguration instance) {
    if (instance instanceof ImmutableServerConfiguration) {
      return (ImmutableServerConfiguration) instance;
    }
    return ImmutableServerConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServerConfiguration ImmutableServerConfiguration}.
   * <pre>
   * ImmutableServerConfiguration.builder()
   *    .uriScheme(String) // optional {@link ServerConfiguration#getUriScheme() uriScheme}
   *    .serverHostname(String) // optional {@link ServerConfiguration#getServerHostname() serverHostname}
   *    .serverPort(int) // optional {@link ServerConfiguration#getServerPort() serverPort}
   *    .build();
   * </pre>
   * @return A new ImmutableServerConfiguration builder
   */
  public static ImmutableServerConfiguration.Builder builder() {
    return new ImmutableServerConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServerConfiguration ImmutableServerConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ServerConfiguration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_SERVER_PORT = 0x1L;
    private long optBits;

    private @Nullable String uriScheme;
    private @Nullable String serverHostname;
    private int serverPort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServerConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ServerConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      uriScheme(instance.getUriScheme());
      serverHostname(instance.getServerHostname());
      serverPort(instance.getServerPort());
      return this;
    }

    /**
     * Initializes the value for the {@link ServerConfiguration#getUriScheme() uriScheme} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ServerConfiguration#getUriScheme() uriScheme}.</em>
     * @param uriScheme The value for uriScheme 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder uriScheme(String uriScheme) {
      this.uriScheme = Objects.requireNonNull(uriScheme, "uriScheme");
      return this;
    }

    /**
     * Initializes the value for the {@link ServerConfiguration#getServerHostname() serverHostname} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ServerConfiguration#getServerHostname() serverHostname}.</em>
     * @param serverHostname The value for serverHostname 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serverHostname(String serverHostname) {
      this.serverHostname = Objects.requireNonNull(serverHostname, "serverHostname");
      return this;
    }

    /**
     * Initializes the value for the {@link ServerConfiguration#getServerPort() serverPort} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ServerConfiguration#getServerPort() serverPort}.</em>
     * @param serverPort The value for serverPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serverPort(int serverPort) {
      this.serverPort = serverPort;
      optBits |= OPT_BIT_SERVER_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableServerConfiguration ImmutableServerConfiguration}.
     * @return An immutable instance of ServerConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServerConfiguration build() {
      return new ImmutableServerConfiguration(this);
    }

    private boolean serverPortIsSet() {
      return (optBits & OPT_BIT_SERVER_PORT) != 0;
    }
  }
}
