package com.github.searls.jasmine.config;

import com.github.searls.jasmine.mojo.Capability;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WebDriverConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWebDriverConfiguration.builder()}.
 */
@Generated(from = "WebDriverConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWebDriverConfiguration
    implements WebDriverConfiguration {
  private final String webDriverClassName;
  private final ImmutableList<Capability> webDriverCapabilities;
  private final URL remoteWebDriverUrl;

  private ImmutableWebDriverConfiguration(
      String webDriverClassName,
      ImmutableList<Capability> webDriverCapabilities,
      URL remoteWebDriverUrl) {
    this.webDriverClassName = webDriverClassName;
    this.webDriverCapabilities = webDriverCapabilities;
    this.remoteWebDriverUrl = remoteWebDriverUrl;
  }

  /**
   * @return The value of the {@code webDriverClassName} attribute
   */
  @Override
  public String getWebDriverClassName() {
    return webDriverClassName;
  }

  /**
   * @return The value of the {@code webDriverCapabilities} attribute
   */
  @Override
  public ImmutableList<Capability> getWebDriverCapabilities() {
    return webDriverCapabilities;
  }

  /**
   * @return The value of the {@code remoteWebDriverUrl} attribute
   */
  @Override
  public URL getRemoteWebDriverUrl() {
    return remoteWebDriverUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebDriverConfiguration#getWebDriverClassName() webDriverClassName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for webDriverClassName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebDriverConfiguration withWebDriverClassName(String value) {
    String newValue = Objects.requireNonNull(value, "webDriverClassName");
    if (this.webDriverClassName.equals(newValue)) return this;
    return new ImmutableWebDriverConfiguration(newValue, this.webDriverCapabilities, this.remoteWebDriverUrl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebDriverConfiguration withWebDriverCapabilities(Capability... elements) {
    ImmutableList<Capability> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWebDriverConfiguration(this.webDriverClassName, newValue, this.remoteWebDriverUrl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of webDriverCapabilities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebDriverConfiguration withWebDriverCapabilities(Iterable<? extends Capability> elements) {
    if (this.webDriverCapabilities == elements) return this;
    ImmutableList<Capability> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWebDriverConfiguration(this.webDriverClassName, newValue, this.remoteWebDriverUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebDriverConfiguration#getRemoteWebDriverUrl() remoteWebDriverUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for remoteWebDriverUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebDriverConfiguration withRemoteWebDriverUrl(URL value) {
    if (this.remoteWebDriverUrl == value) return this;
    URL newValue = Objects.requireNonNull(value, "remoteWebDriverUrl");
    return new ImmutableWebDriverConfiguration(this.webDriverClassName, this.webDriverCapabilities, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWebDriverConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWebDriverConfiguration
        && equalTo((ImmutableWebDriverConfiguration) another);
  }

  private boolean equalTo(ImmutableWebDriverConfiguration another) {
    return webDriverClassName.equals(another.webDriverClassName)
        && webDriverCapabilities.equals(another.webDriverCapabilities)
        && remoteWebDriverUrl.equals(another.remoteWebDriverUrl);
  }

  /**
   * Computes a hash code from attributes: {@code webDriverClassName}, {@code webDriverCapabilities}, {@code remoteWebDriverUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + webDriverClassName.hashCode();
    h += (h << 5) + webDriverCapabilities.hashCode();
    h += (h << 5) + remoteWebDriverUrl.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WebDriverConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WebDriverConfiguration")
        .omitNullValues()
        .add("webDriverClassName", webDriverClassName)
        .add("webDriverCapabilities", webDriverCapabilities)
        .add("remoteWebDriverUrl", remoteWebDriverUrl)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link WebDriverConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebDriverConfiguration instance
   */
  public static ImmutableWebDriverConfiguration copyOf(WebDriverConfiguration instance) {
    if (instance instanceof ImmutableWebDriverConfiguration) {
      return (ImmutableWebDriverConfiguration) instance;
    }
    return ImmutableWebDriverConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWebDriverConfiguration ImmutableWebDriverConfiguration}.
   * <pre>
   * ImmutableWebDriverConfiguration.builder()
   *    .webDriverClassName(String) // required {@link WebDriverConfiguration#getWebDriverClassName() webDriverClassName}
   *    .addWebDriverCapabilities|addAllWebDriverCapabilities(com.github.searls.jasmine.mojo.Capability) // {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} elements
   *    .remoteWebDriverUrl(java.net.URL) // required {@link WebDriverConfiguration#getRemoteWebDriverUrl() remoteWebDriverUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableWebDriverConfiguration builder
   */
  public static ImmutableWebDriverConfiguration.Builder builder() {
    return new ImmutableWebDriverConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWebDriverConfiguration ImmutableWebDriverConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WebDriverConfiguration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WEB_DRIVER_CLASS_NAME = 0x1L;
    private static final long INIT_BIT_REMOTE_WEB_DRIVER_URL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String webDriverClassName;
    private ImmutableList.Builder<Capability> webDriverCapabilities = ImmutableList.builder();
    private @Nullable URL remoteWebDriverUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WebDriverConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WebDriverConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      webDriverClassName(instance.getWebDriverClassName());
      addAllWebDriverCapabilities(instance.getWebDriverCapabilities());
      remoteWebDriverUrl(instance.getRemoteWebDriverUrl());
      return this;
    }

    /**
     * Initializes the value for the {@link WebDriverConfiguration#getWebDriverClassName() webDriverClassName} attribute.
     * @param webDriverClassName The value for webDriverClassName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder webDriverClassName(String webDriverClassName) {
      this.webDriverClassName = Objects.requireNonNull(webDriverClassName, "webDriverClassName");
      initBits &= ~INIT_BIT_WEB_DRIVER_CLASS_NAME;
      return this;
    }

    /**
     * Adds one element to {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} list.
     * @param element A webDriverCapabilities element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWebDriverCapabilities(Capability element) {
      this.webDriverCapabilities.add(element);
      return this;
    }

    /**
     * Adds elements to {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} list.
     * @param elements An array of webDriverCapabilities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWebDriverCapabilities(Capability... elements) {
      this.webDriverCapabilities.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} list.
     * @param elements An iterable of webDriverCapabilities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder webDriverCapabilities(Iterable<? extends Capability> elements) {
      this.webDriverCapabilities = ImmutableList.builder();
      return addAllWebDriverCapabilities(elements);
    }

    /**
     * Adds elements to {@link WebDriverConfiguration#getWebDriverCapabilities() webDriverCapabilities} list.
     * @param elements An iterable of webDriverCapabilities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllWebDriverCapabilities(Iterable<? extends Capability> elements) {
      this.webDriverCapabilities.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link WebDriverConfiguration#getRemoteWebDriverUrl() remoteWebDriverUrl} attribute.
     * @param remoteWebDriverUrl The value for remoteWebDriverUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder remoteWebDriverUrl(URL remoteWebDriverUrl) {
      this.remoteWebDriverUrl = Objects.requireNonNull(remoteWebDriverUrl, "remoteWebDriverUrl");
      initBits &= ~INIT_BIT_REMOTE_WEB_DRIVER_URL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWebDriverConfiguration ImmutableWebDriverConfiguration}.
     * @return An immutable instance of WebDriverConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWebDriverConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWebDriverConfiguration(webDriverClassName, webDriverCapabilities.build(), remoteWebDriverUrl);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WEB_DRIVER_CLASS_NAME) != 0) attributes.add("webDriverClassName");
      if ((initBits & INIT_BIT_REMOTE_WEB_DRIVER_URL) != 0) attributes.add("remoteWebDriverUrl");
      return "Cannot build WebDriverConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
