package com.github.searls.jasmine.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ScriptSearch}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableScriptSearch.builder()}.
 */
@Generated(from = "ScriptSearch", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableScriptSearch implements ScriptSearch {
  private final File directory;
  private final ImmutableList<String> includes;
  private final ImmutableList<String> excludes;

  private ImmutableScriptSearch(
      File directory,
      ImmutableList<String> includes,
      ImmutableList<String> excludes) {
    this.directory = directory;
    this.includes = includes;
    this.excludes = excludes;
  }

  /**
   * @return The value of the {@code directory} attribute
   */
  @Override
  public File getDirectory() {
    return directory;
  }

  /**
   * @return The value of the {@code includes} attribute
   */
  @Override
  public ImmutableList<String> getIncludes() {
    return includes;
  }

  /**
   * @return The value of the {@code excludes} attribute
   */
  @Override
  public ImmutableList<String> getExcludes() {
    return excludes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ScriptSearch#getDirectory() directory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for directory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableScriptSearch withDirectory(File value) {
    if (this.directory == value) return this;
    File newValue = Objects.requireNonNull(value, "directory");
    return new ImmutableScriptSearch(newValue, this.includes, this.excludes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ScriptSearch#getIncludes() includes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableScriptSearch withIncludes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableScriptSearch(this.directory, newValue, this.excludes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ScriptSearch#getIncludes() includes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of includes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableScriptSearch withIncludes(Iterable<String> elements) {
    if (this.includes == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableScriptSearch(this.directory, newValue, this.excludes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ScriptSearch#getExcludes() excludes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableScriptSearch withExcludes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableScriptSearch(this.directory, this.includes, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ScriptSearch#getExcludes() excludes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of excludes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableScriptSearch withExcludes(Iterable<String> elements) {
    if (this.excludes == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableScriptSearch(this.directory, this.includes, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableScriptSearch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableScriptSearch
        && equalTo((ImmutableScriptSearch) another);
  }

  private boolean equalTo(ImmutableScriptSearch another) {
    return directory.equals(another.directory)
        && includes.equals(another.includes)
        && excludes.equals(another.excludes);
  }

  /**
   * Computes a hash code from attributes: {@code directory}, {@code includes}, {@code excludes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + directory.hashCode();
    h += (h << 5) + includes.hashCode();
    h += (h << 5) + excludes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ScriptSearch} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ScriptSearch")
        .omitNullValues()
        .add("directory", directory)
        .add("includes", includes)
        .add("excludes", excludes)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ScriptSearch} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ScriptSearch instance
   */
  public static ImmutableScriptSearch copyOf(ScriptSearch instance) {
    if (instance instanceof ImmutableScriptSearch) {
      return (ImmutableScriptSearch) instance;
    }
    return ImmutableScriptSearch.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableScriptSearch ImmutableScriptSearch}.
   * <pre>
   * ImmutableScriptSearch.builder()
   *    .directory(java.io.File) // required {@link ScriptSearch#getDirectory() directory}
   *    .addIncludes|addAllIncludes(String) // {@link ScriptSearch#getIncludes() includes} elements
   *    .addExcludes|addAllExcludes(String) // {@link ScriptSearch#getExcludes() excludes} elements
   *    .build();
   * </pre>
   * @return A new ImmutableScriptSearch builder
   */
  public static ImmutableScriptSearch.Builder builder() {
    return new ImmutableScriptSearch.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableScriptSearch ImmutableScriptSearch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ScriptSearch", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DIRECTORY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable File directory;
    private ImmutableList.Builder<String> includes = ImmutableList.builder();
    private ImmutableList.Builder<String> excludes = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ScriptSearch} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ScriptSearch instance) {
      Objects.requireNonNull(instance, "instance");
      directory(instance.getDirectory());
      addAllIncludes(instance.getIncludes());
      addAllExcludes(instance.getExcludes());
      return this;
    }

    /**
     * Initializes the value for the {@link ScriptSearch#getDirectory() directory} attribute.
     * @param directory The value for directory 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder directory(File directory) {
      this.directory = Objects.requireNonNull(directory, "directory");
      initBits &= ~INIT_BIT_DIRECTORY;
      return this;
    }

    /**
     * Adds one element to {@link ScriptSearch#getIncludes() includes} list.
     * @param element A includes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIncludes(String element) {
      this.includes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ScriptSearch#getIncludes() includes} list.
     * @param elements An array of includes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIncludes(String... elements) {
      this.includes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ScriptSearch#getIncludes() includes} list.
     * @param elements An iterable of includes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder includes(Iterable<String> elements) {
      this.includes = ImmutableList.builder();
      return addAllIncludes(elements);
    }

    /**
     * Adds elements to {@link ScriptSearch#getIncludes() includes} list.
     * @param elements An iterable of includes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllIncludes(Iterable<String> elements) {
      this.includes.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ScriptSearch#getExcludes() excludes} list.
     * @param element A excludes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExcludes(String element) {
      this.excludes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ScriptSearch#getExcludes() excludes} list.
     * @param elements An array of excludes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExcludes(String... elements) {
      this.excludes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ScriptSearch#getExcludes() excludes} list.
     * @param elements An iterable of excludes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder excludes(Iterable<String> elements) {
      this.excludes = ImmutableList.builder();
      return addAllExcludes(elements);
    }

    /**
     * Adds elements to {@link ScriptSearch#getExcludes() excludes} list.
     * @param elements An iterable of excludes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExcludes(Iterable<String> elements) {
      this.excludes.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableScriptSearch ImmutableScriptSearch}.
     * @return An immutable instance of ScriptSearch
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableScriptSearch build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableScriptSearch(directory, includes.build(), excludes.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DIRECTORY) != 0) attributes.add("directory");
      return "Cannot build ScriptSearch, some of required attributes are not set " + attributes;
    }
  }
}
