/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.config;

import com.github.searls.jasmine.config.ServerConfiguration;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServerConfiguration", generator="Immutables")
@Immutable
public final class ImmutableServerConfiguration
extends ServerConfiguration {
    private final String uriScheme;
    private final String serverHostname;
    private final int serverPort;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableServerConfiguration(Builder builder) {
        if (builder.uriScheme != null) {
            this.initShim.uriScheme(builder.uriScheme);
        }
        if (builder.serverHostname != null) {
            this.initShim.serverHostname(builder.serverHostname);
        }
        if (builder.serverPortIsSet()) {
            this.initShim.serverPort(builder.serverPort);
        }
        this.uriScheme = this.initShim.getUriScheme();
        this.serverHostname = this.initShim.getServerHostname();
        this.serverPort = this.initShim.getServerPort();
        this.initShim = null;
    }

    private ImmutableServerConfiguration(String uriScheme, String serverHostname, int serverPort) {
        this.uriScheme = uriScheme;
        this.serverHostname = serverHostname;
        this.serverPort = serverPort;
        this.initShim = null;
    }

    @Override
    public String getUriScheme() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUriScheme() : this.uriScheme;
    }

    @Override
    public String getServerHostname() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getServerHostname() : this.serverHostname;
    }

    @Override
    public int getServerPort() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getServerPort() : this.serverPort;
    }

    public final ImmutableServerConfiguration withUriScheme(String value) {
        String newValue = Objects.requireNonNull(value, "uriScheme");
        if (this.uriScheme.equals(newValue)) {
            return this;
        }
        return new ImmutableServerConfiguration(newValue, this.serverHostname, this.serverPort);
    }

    public final ImmutableServerConfiguration withServerHostname(String value) {
        String newValue = Objects.requireNonNull(value, "serverHostname");
        if (this.serverHostname.equals(newValue)) {
            return this;
        }
        return new ImmutableServerConfiguration(this.uriScheme, newValue, this.serverPort);
    }

    public final ImmutableServerConfiguration withServerPort(int value) {
        if (this.serverPort == value) {
            return this;
        }
        return new ImmutableServerConfiguration(this.uriScheme, this.serverHostname, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerConfiguration && this.equalTo((ImmutableServerConfiguration)another);
    }

    private boolean equalTo(ImmutableServerConfiguration another) {
        return this.uriScheme.equals(another.uriScheme) && this.serverHostname.equals(another.serverHostname) && this.serverPort == another.serverPort;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.uriScheme.hashCode();
        h += (h << 5) + this.serverHostname.hashCode();
        h += (h << 5) + this.serverPort;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServerConfiguration").omitNullValues().add("uriScheme", (Object)this.uriScheme).add("serverHostname", (Object)this.serverHostname).add("serverPort", this.serverPort).toString();
    }

    public static ImmutableServerConfiguration copyOf(ServerConfiguration instance) {
        if (instance instanceof ImmutableServerConfiguration) {
            return (ImmutableServerConfiguration)instance;
        }
        return ImmutableServerConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServerConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SERVER_PORT = 1L;
        private long optBits;
        @Nullable
        private String uriScheme;
        @Nullable
        private String serverHostname;
        private int serverPort;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.uriScheme(instance.getUriScheme());
            this.serverHostname(instance.getServerHostname());
            this.serverPort(instance.getServerPort());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uriScheme(String uriScheme) {
            this.uriScheme = Objects.requireNonNull(uriScheme, "uriScheme");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serverHostname(String serverHostname) {
            this.serverHostname = Objects.requireNonNull(serverHostname, "serverHostname");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serverPort(int serverPort) {
            this.serverPort = serverPort;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableServerConfiguration build() {
            return new ImmutableServerConfiguration(this);
        }

        private boolean serverPortIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="ServerConfiguration", generator="Immutables")
    private final class InitShim {
        private byte uriSchemeBuildStage = 0;
        private String uriScheme;
        private byte serverHostnameBuildStage = 0;
        private String serverHostname;
        private byte serverPortBuildStage = 0;
        private int serverPort;

        private InitShim() {
        }

        String getUriScheme() {
            if (this.uriSchemeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriSchemeBuildStage == 0) {
                this.uriSchemeBuildStage = (byte)-1;
                this.uriScheme = Objects.requireNonNull(ImmutableServerConfiguration.super.getUriScheme(), "uriScheme");
                this.uriSchemeBuildStage = 1;
            }
            return this.uriScheme;
        }

        void uriScheme(String uriScheme) {
            this.uriScheme = uriScheme;
            this.uriSchemeBuildStage = 1;
        }

        String getServerHostname() {
            if (this.serverHostnameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.serverHostnameBuildStage == 0) {
                this.serverHostnameBuildStage = (byte)-1;
                this.serverHostname = Objects.requireNonNull(ImmutableServerConfiguration.super.getServerHostname(), "serverHostname");
                this.serverHostnameBuildStage = 1;
            }
            return this.serverHostname;
        }

        void serverHostname(String serverHostname) {
            this.serverHostname = serverHostname;
            this.serverHostnameBuildStage = 1;
        }

        int getServerPort() {
            if (this.serverPortBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.serverPortBuildStage == 0) {
                this.serverPortBuildStage = (byte)-1;
                this.serverPort = ImmutableServerConfiguration.super.getServerPort();
                this.serverPortBuildStage = 1;
            }
            return this.serverPort;
        }

        void serverPort(int serverPort) {
            this.serverPort = serverPort;
            this.serverPortBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.uriSchemeBuildStage == -1) {
                attributes.add("uriScheme");
            }
            if (this.serverHostnameBuildStage == -1) {
                attributes.add("serverHostname");
            }
            if (this.serverPortBuildStage == -1) {
                attributes.add("serverPort");
            }
            return "Cannot build ServerConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

