/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.config;

import com.github.searls.jasmine.config.WebDriverConfiguration;
import com.github.searls.jasmine.mojo.Capability;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WebDriverConfiguration", generator="Immutables")
@Immutable
public final class ImmutableWebDriverConfiguration
implements WebDriverConfiguration {
    private final String webDriverClassName;
    private final ImmutableList<Capability> webDriverCapabilities;
    private final URL remoteWebDriverUrl;

    private ImmutableWebDriverConfiguration(String webDriverClassName, ImmutableList<Capability> webDriverCapabilities, URL remoteWebDriverUrl) {
        this.webDriverClassName = webDriverClassName;
        this.webDriverCapabilities = webDriverCapabilities;
        this.remoteWebDriverUrl = remoteWebDriverUrl;
    }

    @Override
    public String getWebDriverClassName() {
        return this.webDriverClassName;
    }

    public ImmutableList<Capability> getWebDriverCapabilities() {
        return this.webDriverCapabilities;
    }

    @Override
    public URL getRemoteWebDriverUrl() {
        return this.remoteWebDriverUrl;
    }

    public final ImmutableWebDriverConfiguration withWebDriverClassName(String value) {
        String newValue = Objects.requireNonNull(value, "webDriverClassName");
        if (this.webDriverClassName.equals(newValue)) {
            return this;
        }
        return new ImmutableWebDriverConfiguration(newValue, this.webDriverCapabilities, this.remoteWebDriverUrl);
    }

    public final ImmutableWebDriverConfiguration withWebDriverCapabilities(Capability ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableWebDriverConfiguration(this.webDriverClassName, (ImmutableList<Capability>)newValue, this.remoteWebDriverUrl);
    }

    public final ImmutableWebDriverConfiguration withWebDriverCapabilities(Iterable<? extends Capability> elements) {
        if (this.webDriverCapabilities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableWebDriverConfiguration(this.webDriverClassName, (ImmutableList<Capability>)newValue, this.remoteWebDriverUrl);
    }

    public final ImmutableWebDriverConfiguration withRemoteWebDriverUrl(URL value) {
        if (this.remoteWebDriverUrl == value) {
            return this;
        }
        URL newValue = Objects.requireNonNull(value, "remoteWebDriverUrl");
        return new ImmutableWebDriverConfiguration(this.webDriverClassName, this.webDriverCapabilities, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebDriverConfiguration && this.equalTo((ImmutableWebDriverConfiguration)another);
    }

    private boolean equalTo(ImmutableWebDriverConfiguration another) {
        return this.webDriverClassName.equals(another.webDriverClassName) && this.webDriverCapabilities.equals(another.webDriverCapabilities) && this.remoteWebDriverUrl.equals(another.remoteWebDriverUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.webDriverClassName.hashCode();
        h += (h << 5) + this.webDriverCapabilities.hashCode();
        h += (h << 5) + this.remoteWebDriverUrl.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WebDriverConfiguration").omitNullValues().add("webDriverClassName", (Object)this.webDriverClassName).add("webDriverCapabilities", this.webDriverCapabilities).add("remoteWebDriverUrl", (Object)this.remoteWebDriverUrl).toString();
    }

    public static ImmutableWebDriverConfiguration copyOf(WebDriverConfiguration instance) {
        if (instance instanceof ImmutableWebDriverConfiguration) {
            return (ImmutableWebDriverConfiguration)instance;
        }
        return ImmutableWebDriverConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebDriverConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WEB_DRIVER_CLASS_NAME = 1L;
        private static final long INIT_BIT_REMOTE_WEB_DRIVER_URL = 2L;
        private long initBits = 3L;
        @Nullable
        private String webDriverClassName;
        private ImmutableList.Builder<Capability> webDriverCapabilities = ImmutableList.builder();
        @Nullable
        private URL remoteWebDriverUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WebDriverConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.webDriverClassName(instance.getWebDriverClassName());
            this.addAllWebDriverCapabilities(instance.getWebDriverCapabilities());
            this.remoteWebDriverUrl(instance.getRemoteWebDriverUrl());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder webDriverClassName(String webDriverClassName) {
            this.webDriverClassName = Objects.requireNonNull(webDriverClassName, "webDriverClassName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWebDriverCapabilities(Capability element) {
            this.webDriverCapabilities.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWebDriverCapabilities(Capability ... elements) {
            this.webDriverCapabilities.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder webDriverCapabilities(Iterable<? extends Capability> elements) {
            this.webDriverCapabilities = ImmutableList.builder();
            return this.addAllWebDriverCapabilities(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllWebDriverCapabilities(Iterable<? extends Capability> elements) {
            this.webDriverCapabilities.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder remoteWebDriverUrl(URL remoteWebDriverUrl) {
            this.remoteWebDriverUrl = Objects.requireNonNull(remoteWebDriverUrl, "remoteWebDriverUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWebDriverConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebDriverConfiguration(this.webDriverClassName, this.webDriverCapabilities.build(), this.remoteWebDriverUrl);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("webDriverClassName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("remoteWebDriverUrl");
            }
            return "Cannot build WebDriverConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

