/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.io.scripts;

import com.github.searls.jasmine.io.ScansDirectory;
import com.github.searls.jasmine.io.scripts.ConvertsFileToUriString;
import com.github.searls.jasmine.model.ScriptSearch;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class FindsScriptLocationsInDirectory {
    private final ScansDirectory scansDirectory;
    private final ConvertsFileToUriString convertsFileToUriString;

    @Inject
    public FindsScriptLocationsInDirectory(ScansDirectory scansDirectory, ConvertsFileToUriString convertsFileToUriString) {
        this.scansDirectory = scansDirectory;
        this.convertsFileToUriString = convertsFileToUriString;
    }

    public List<String> find(ScriptSearch search) {
        ArrayList<String> scriptLocations = new ArrayList<String>();
        if (search.getDirectory().canRead()) {
            for (String script : this.scansDirectory.scan(search.getDirectory(), search.getIncludes(), search.getExcludes())) {
                scriptLocations.add(this.convertsFileToUriString.convert(new File(search.getDirectory(), script)));
            }
        }
        return scriptLocations;
    }
}

