/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.google.common.base.Function;
import javax.inject.Named;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class WebDriverWaiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverWaiter.class);
    protected static final String EXECUTION_FINISHED_SCRIPT = "return (window.jsApiReporter === undefined) ? false : window.jsApiReporter.finished";
    private static final String TIMEOUT_WARNING = "Attempted to wait for your specs to finish processing over the course of {} seconds, but it still appears to be running.";
    private static final String DEBUG_MODE_TIMEOUT_WARNING = "Debug mode: will attempt to parse the incomplete spec runner results";
    private static final String TIMEOUT_ERROR_MESSAGE = "Timeout occurred. Aborting execution of specs. (Try configuring 'debug' to 'true' for more details.)";

    WebDriverWaiter() {
    }

    public void waitForRunnerToFinish(WebDriver driver, int timeout, boolean debug) {
        JavascriptExecutor executor = (JavascriptExecutor)driver;
        try {
            new WebDriverWait(driver, (long)timeout, 1000L).until((java.util.function.Function)((Function)input -> this.executionFinished(executor)));
        }
        catch (TimeoutException e) {
            this.handleTimeout(timeout, debug);
        }
    }

    private Boolean executionFinished(JavascriptExecutor driver) {
        return (Boolean)driver.executeScript(EXECUTION_FINISHED_SCRIPT, new Object[0]);
    }

    private void handleTimeout(int timeout, boolean debug) {
        LOGGER.warn(TIMEOUT_WARNING, (Object)timeout);
        if (!debug) {
            throw new IllegalStateException(TIMEOUT_ERROR_MESSAGE);
        }
        LOGGER.warn(DEBUG_MODE_TIMEOUT_WARNING);
    }
}

