/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.server;

import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.runner.CreatesRunner;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class JasmineResourceHandler
extends ResourceHandler {
    private final CreatesRunner createsRunner;
    private final JasmineConfiguration configuration;

    public JasmineResourceHandler(CreatesRunner createsRunner, JasmineConfiguration configuration) {
        this.createsRunner = createsRunner;
        this.configuration = configuration;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.createSpecRunnerIfNecessary(target);
        response.addDateHeader("EXPIRES", 0L);
        super.handle(target, baseRequest, (HttpServletRequest)baseRequest, response);
    }

    private void createSpecRunnerIfNecessary(String target) throws IOException {
        if ("/".equals(target)) {
            this.createsRunner.create(this.configuration);
        }
    }
}

