/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Named
public class IoUtilities {
    public File createFile(File parent, String child) {
        return new File(parent, child);
    }

    public String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public void writeStringToFile(File file, String contents) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)contents, (Charset)StandardCharsets.UTF_8);
    }

    public void writeStringToFile(File file, String contents, String encoding) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)contents, (String)encoding);
    }

    public String toString(InputStream inputStream) throws IOException {
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    public String resourceToString(String name) throws IOException {
        return this.toString(this.resourceToInputStream(name));
    }

    public InputStream resourceToInputStream(String name) {
        return IoUtilities.class.getResourceAsStream(name);
    }
}

