/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.model.FileSystemReporter;
import com.github.searls.jasmine.model.Reporter;
import com.github.searls.jasmine.model.Reporters;
import com.github.searls.jasmine.mojo.ResourceRetriever;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

@Named
public class ReporterRetriever {
    protected static final String STANDARD_REPORTER = "/lib/buildReport.js";
    protected static final String JUNIT_XML_REPORTER = "lib/createJunitXml.js";
    private final ResourceRetriever resourceRetriever;

    @Inject
    public ReporterRetriever(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    List<FileSystemReporter> retrieveFileSystemReporters(List<FileSystemReporter> reporters, File targetDirectory, MavenProject mavenProject) throws MojoExecutionException {
        ArrayList<FileSystemReporter> normalizedReporters = new ArrayList<FileSystemReporter>();
        if (reporters.isEmpty()) {
            reporters.add(Reporters.JUNIT_REPORTER);
        }
        for (FileSystemReporter reporter : reporters) {
            String name = reporter.getReporterName();
            if (Reporters.JUNIT_REPORTER.getReporterName().equals(reporter.getReporterName())) {
                name = JUNIT_XML_REPORTER;
            }
            this.getReporterFile(name, mavenProject).ifPresent(file1 -> {
                File file = new File(targetDirectory, reporter.getFileName());
                normalizedReporters.add(new FileSystemReporter(file, (File)file1));
            });
        }
        return normalizedReporters;
    }

    List<Reporter> retrieveReporters(List<Reporter> reporters, MavenProject mavenProject) throws MojoExecutionException {
        ArrayList<Reporter> normalizedReporters = new ArrayList<Reporter>();
        if (reporters.isEmpty()) {
            reporters.add(Reporters.STANDARD_REPORTER);
        }
        for (Reporter reporter : reporters) {
            Optional<File> reporterFile;
            String name = reporter.getReporterName();
            if (Reporters.STANDARD_REPORTER.getReporterName().equals(name)) {
                name = STANDARD_REPORTER;
            }
            if (!(reporterFile = this.getReporterFile(name, mavenProject)).isPresent()) continue;
            normalizedReporters.add(new Reporter(name, reporterFile.get()));
        }
        return normalizedReporters;
    }

    private Optional<File> getReporterFile(String reporter, MavenProject mavenProject) throws MojoExecutionException {
        return this.resourceRetriever.getResourceAsFile("reporter", reporter, mavenProject);
    }
}

