/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class ConsoleErrorChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleErrorChecker.class);

    ConsoleErrorChecker() {
    }

    void checkForConsoleErrors(WebDriver driver) {
        List<String> errorMessages = this.getErrors(driver);
        if (!errorMessages.isEmpty()) {
            String errors = "JavaScript Console Errors:\n\n  * " + String.join((CharSequence)"\n  * ", errorMessages) + "\n\n";
            LOGGER.warn(errors);
            throw new RuntimeException("There were javascript console errors.\n\n" + errors);
        }
    }

    private List<String> getErrors(WebDriver driver) {
        JavascriptExecutor executor = (JavascriptExecutor)driver;
        List<String> errorMessages = (List<String>)executor.executeScript("return window.getConsoleErrors ? window.getConsoleErrors() : [];", new Object[0]);
        return errorMessages != null ? errorMessages : Collections.emptyList();
    }
}

