/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.format.FormatsScriptTags;
import com.github.searls.jasmine.io.scripts.ScriptResolver;
import com.github.searls.jasmine.runner.HtmlGeneratorConfiguration;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.ST;

@Named
public class DefaultSpecRunnerHtmlGenerator
implements SpecRunnerHtmlGenerator {
    private static final String SOURCE_ENCODING = "sourceEncoding";
    private static final String CSS_DEPENDENCIES_TEMPLATE_ATTR_NAME = "cssDependencies";
    private static final String JAVASCRIPT_DEPENDENCIES_TEMPLATE_ATTR_NAME = "javascriptDependencies";
    private static final String REPORTER_ATTR_NAME = "reporter";
    private static final String ALL_SCRIPT_TAGS = "allScriptTags";
    private static final String PRELOAD_SCRIPT_TAGS = "preloadScriptTags";
    private static final String SOURCE_SCRIPT_TAGS = "sourceScriptTags";
    private static final String SPEC_SCRIPT_TAGS = "specScriptTags";
    private static final String ALL_SCRIPTS_LIST = "allScriptsList";
    private static final String PRELOADS_LIST = "preloadsList";
    private static final String SOURCES_LIST = "sourcesList";
    private static final String SPECS_LIST = "specsList";
    private static final String SOURCE_DIR = "sourceDir";
    private static final String SPEC_DIR = "specDir";
    private static final String AUTO_REFRESH = "autoRefresh";
    private static final String AUTO_REFRESH_INTERVAL = "autoRefreshInterval";
    private static final String CUSTOM_RUNNER_CONFIGURATION = "customRunnerConfiguration";
    private final FormatsScriptTags formatsScriptTags;

    @Inject
    public DefaultSpecRunnerHtmlGenerator(FormatsScriptTags formatsScriptTags) {
        this.formatsScriptTags = formatsScriptTags;
    }

    @Override
    public String generate(HtmlGeneratorConfiguration configuration) {
        ScriptResolver resolver = configuration.getScriptResolver();
        return this.generateHtml(configuration, resolver.getAllScripts(), resolver.getPreloads(), resolver.getSources(), resolver.getSpecs(), resolver.getSourceDirectory(), resolver.getSpecDirectory());
    }

    private String generateHtml(HtmlGeneratorConfiguration configuration, Set<String> allScripts, Set<String> preloads, Set<String> sources, Set<String> specs, String sourceDirectory, String specDirectory) {
        ST template = this.resolveHtmlTemplate(configuration.getRunnerTemplate());
        this.applyScriptTagsToTemplate(JAVASCRIPT_DEPENDENCIES_TEMPLATE_ATTR_NAME, Arrays.asList("/webjars/jasmine-core/jasmine.js", "/webjars/jasmine-core/jasmine-html.js", "/classpath/lib/htmlSpecFilterPatch.js", "/webjars/jasmine-core/boot.js"), template);
        this.applyCssToTemplate(Collections.singletonList("/webjars/jasmine-core/jasmine.css"), template);
        this.applyScriptTagsToTemplate(ALL_SCRIPT_TAGS, allScripts, template);
        this.applyScriptTagsToTemplate(PRELOAD_SCRIPT_TAGS, preloads, template);
        this.applyScriptTagsToTemplate(SOURCE_SCRIPT_TAGS, sources, template);
        this.applyScriptTagsToTemplate(SPEC_SCRIPT_TAGS, specs, template);
        template.add(ALL_SCRIPTS_LIST, (Object)this.createJsonArray(allScripts));
        template.add(PRELOADS_LIST, (Object)this.createJsonArray(preloads));
        template.add(SOURCES_LIST, (Object)this.createJsonArray(sources));
        template.add(SPECS_LIST, (Object)this.createJsonArray(specs));
        template.add(SOURCE_DIR, (Object)sourceDirectory);
        template.add(SPEC_DIR, (Object)specDirectory);
        template.add(AUTO_REFRESH, (Object)configuration.isAutoRefresh());
        template.add(AUTO_REFRESH_INTERVAL, (Object)configuration.getAutoRefreshInterval());
        template.add(CUSTOM_RUNNER_CONFIGURATION, (Object)configuration.getCustomRunnerConfiguration());
        template.add(REPORTER_ATTR_NAME, (Object)configuration.getReporterType().name());
        this.setEncoding(configuration, template);
        return template.render();
    }

    private String createJsonArray(Set<String> scripts) {
        return scripts == null || scripts.isEmpty() ? "[]" : "['" + StringUtils.join(scripts, (String)"', '") + "']";
    }

    private void setEncoding(HtmlGeneratorConfiguration htmlGeneratorConfiguration, ST template) {
        template.add(SOURCE_ENCODING, (Object)(StringUtils.isNotBlank((CharSequence)htmlGeneratorConfiguration.getSourceEncoding()) ? htmlGeneratorConfiguration.getSourceEncoding() : "UTF-8"));
    }

    private ST resolveHtmlTemplate(String htmlTemplate) {
        return new ST(htmlTemplate, '$', '$');
    }

    private void applyCssToTemplate(List<String> styles, ST template) {
        StringBuilder css = new StringBuilder();
        for (String cssFile : styles) {
            css.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(cssFile).append("\"/>");
        }
        template.add(CSS_DEPENDENCIES_TEMPLATE_ATTR_NAME, (Object)css.toString());
    }

    private void applyScriptTagsToTemplate(String sourcesTemplateAttrName, Collection<String> scripts, ST template) {
        template.add(sourcesTemplateAttrName, (Object)this.formatsScriptTags.format(scripts));
    }
}

