/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.io.IoUtilities;
import com.github.searls.jasmine.io.scripts.ScriptResolver;
import com.github.searls.jasmine.runner.HtmlGeneratorConfiguration;
import com.github.searls.jasmine.runner.ImmutableHtmlGeneratorConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class HtmlGeneratorConfigurationFactory {
    private final IoUtilities ioUtilities;

    @Inject
    public HtmlGeneratorConfigurationFactory(IoUtilities ioUtilities) {
        this.ioUtilities = ioUtilities;
    }

    public HtmlGeneratorConfiguration create(JasmineConfiguration configuration, ScriptResolver resolver) throws IOException {
        return ImmutableHtmlGeneratorConfiguration.builder().sourceEncoding(configuration.getSourceEncoding()).autoRefreshInterval(configuration.getAutoRefreshInterval()).runnerTemplate(this.getRunnerTemplate(configuration)).customRunnerConfiguration(this.getCustomRunnerConfiguration(configuration)).specRunnerTemplate(configuration.getSpecRunnerTemplate()).reporterType(configuration.getReporterType()).scriptResolver(resolver).build();
    }

    private String getRunnerTemplate(JasmineConfiguration configuration) throws IOException {
        String template = configuration.getCustomRunnerTemplate().isPresent() ? this.readCustomRunnerTemplate(configuration) : this.readSpecRunnerTemplate(configuration);
        return template;
    }

    private String getCustomRunnerConfiguration(JasmineConfiguration configuration) throws IOException {
        Optional<File> configFile = configuration.getCustomRunnerConfiguration();
        return configFile.isPresent() ? this.ioUtilities.readFileToString(configFile.get()) : "";
    }

    private String readCustomRunnerTemplate(JasmineConfiguration configuration) throws IOException {
        Optional<File> customRunnerTemplate = configuration.getCustomRunnerTemplate();
        return customRunnerTemplate.isPresent() ? this.ioUtilities.readFileToString(customRunnerTemplate.get()) : "";
    }

    private String readSpecRunnerTemplate(JasmineConfiguration configuration) throws IOException {
        return this.ioUtilities.resourceToString(configuration.getSpecRunnerTemplate().getTemplate());
    }
}

