/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.io.scripts.ScriptResolver;
import com.github.searls.jasmine.runner.HtmlGeneratorConfiguration;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerTemplate;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HtmlGeneratorConfiguration", generator="Immutables")
@Immutable
public final class ImmutableHtmlGeneratorConfiguration
extends HtmlGeneratorConfiguration {
    private final String sourceEncoding;
    private final ReporterType reporterType;
    private final String runnerTemplate;
    private final SpecRunnerTemplate specRunnerTemplate;
    private final ScriptResolver scriptResolver;
    private final String customRunnerConfiguration;
    private final int autoRefreshInterval;

    private ImmutableHtmlGeneratorConfiguration(String sourceEncoding, ReporterType reporterType, String runnerTemplate, SpecRunnerTemplate specRunnerTemplate, ScriptResolver scriptResolver, String customRunnerConfiguration, int autoRefreshInterval) {
        this.sourceEncoding = sourceEncoding;
        this.reporterType = reporterType;
        this.runnerTemplate = runnerTemplate;
        this.specRunnerTemplate = specRunnerTemplate;
        this.scriptResolver = scriptResolver;
        this.customRunnerConfiguration = customRunnerConfiguration;
        this.autoRefreshInterval = autoRefreshInterval;
    }

    @Override
    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Override
    public ReporterType getReporterType() {
        return this.reporterType;
    }

    @Override
    public String getRunnerTemplate() {
        return this.runnerTemplate;
    }

    @Override
    public SpecRunnerTemplate getSpecRunnerTemplate() {
        return this.specRunnerTemplate;
    }

    @Override
    public ScriptResolver getScriptResolver() {
        return this.scriptResolver;
    }

    @Override
    public String getCustomRunnerConfiguration() {
        return this.customRunnerConfiguration;
    }

    @Override
    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public final ImmutableHtmlGeneratorConfiguration withSourceEncoding(String value) {
        String newValue = Objects.requireNonNull(value, "sourceEncoding");
        if (this.sourceEncoding.equals(newValue)) {
            return this;
        }
        return new ImmutableHtmlGeneratorConfiguration(newValue, this.reporterType, this.runnerTemplate, this.specRunnerTemplate, this.scriptResolver, this.customRunnerConfiguration, this.autoRefreshInterval);
    }

    public final ImmutableHtmlGeneratorConfiguration withReporterType(ReporterType value) {
        if (this.reporterType == value) {
            return this;
        }
        ReporterType newValue = Objects.requireNonNull(value, "reporterType");
        if (this.reporterType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableHtmlGeneratorConfiguration(this.sourceEncoding, newValue, this.runnerTemplate, this.specRunnerTemplate, this.scriptResolver, this.customRunnerConfiguration, this.autoRefreshInterval);
    }

    public final ImmutableHtmlGeneratorConfiguration withRunnerTemplate(String value) {
        String newValue = Objects.requireNonNull(value, "runnerTemplate");
        if (this.runnerTemplate.equals(newValue)) {
            return this;
        }
        return new ImmutableHtmlGeneratorConfiguration(this.sourceEncoding, this.reporterType, newValue, this.specRunnerTemplate, this.scriptResolver, this.customRunnerConfiguration, this.autoRefreshInterval);
    }

    public final ImmutableHtmlGeneratorConfiguration withSpecRunnerTemplate(SpecRunnerTemplate value) {
        if (this.specRunnerTemplate == value) {
            return this;
        }
        SpecRunnerTemplate newValue = Objects.requireNonNull(value, "specRunnerTemplate");
        if (this.specRunnerTemplate.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableHtmlGeneratorConfiguration(this.sourceEncoding, this.reporterType, this.runnerTemplate, newValue, this.scriptResolver, this.customRunnerConfiguration, this.autoRefreshInterval);
    }

    public final ImmutableHtmlGeneratorConfiguration withScriptResolver(ScriptResolver value) {
        if (this.scriptResolver == value) {
            return this;
        }
        ScriptResolver newValue = Objects.requireNonNull(value, "scriptResolver");
        return new ImmutableHtmlGeneratorConfiguration(this.sourceEncoding, this.reporterType, this.runnerTemplate, this.specRunnerTemplate, newValue, this.customRunnerConfiguration, this.autoRefreshInterval);
    }

    public final ImmutableHtmlGeneratorConfiguration withCustomRunnerConfiguration(String value) {
        String newValue = Objects.requireNonNull(value, "customRunnerConfiguration");
        if (this.customRunnerConfiguration.equals(newValue)) {
            return this;
        }
        return new ImmutableHtmlGeneratorConfiguration(this.sourceEncoding, this.reporterType, this.runnerTemplate, this.specRunnerTemplate, this.scriptResolver, newValue, this.autoRefreshInterval);
    }

    public final ImmutableHtmlGeneratorConfiguration withAutoRefreshInterval(int value) {
        if (this.autoRefreshInterval == value) {
            return this;
        }
        return new ImmutableHtmlGeneratorConfiguration(this.sourceEncoding, this.reporterType, this.runnerTemplate, this.specRunnerTemplate, this.scriptResolver, this.customRunnerConfiguration, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHtmlGeneratorConfiguration && this.equalTo((ImmutableHtmlGeneratorConfiguration)another);
    }

    private boolean equalTo(ImmutableHtmlGeneratorConfiguration another) {
        return this.sourceEncoding.equals(another.sourceEncoding) && this.reporterType.equals((Object)another.reporterType) && this.runnerTemplate.equals(another.runnerTemplate) && this.specRunnerTemplate.equals((Object)another.specRunnerTemplate) && this.scriptResolver.equals(another.scriptResolver) && this.customRunnerConfiguration.equals(another.customRunnerConfiguration) && this.autoRefreshInterval == another.autoRefreshInterval;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceEncoding.hashCode();
        h += (h << 5) + this.reporterType.hashCode();
        h += (h << 5) + this.runnerTemplate.hashCode();
        h += (h << 5) + this.specRunnerTemplate.hashCode();
        h += (h << 5) + this.scriptResolver.hashCode();
        h += (h << 5) + this.customRunnerConfiguration.hashCode();
        h += (h << 5) + this.autoRefreshInterval;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HtmlGeneratorConfiguration").omitNullValues().add("sourceEncoding", (Object)this.sourceEncoding).add("reporterType", (Object)this.reporterType).add("runnerTemplate", (Object)this.runnerTemplate).add("specRunnerTemplate", (Object)this.specRunnerTemplate).add("scriptResolver", (Object)this.scriptResolver).add("customRunnerConfiguration", (Object)this.customRunnerConfiguration).add("autoRefreshInterval", this.autoRefreshInterval).toString();
    }

    public static ImmutableHtmlGeneratorConfiguration copyOf(HtmlGeneratorConfiguration instance) {
        if (instance instanceof ImmutableHtmlGeneratorConfiguration) {
            return (ImmutableHtmlGeneratorConfiguration)instance;
        }
        return ImmutableHtmlGeneratorConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HtmlGeneratorConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ENCODING = 1L;
        private static final long INIT_BIT_REPORTER_TYPE = 2L;
        private static final long INIT_BIT_RUNNER_TEMPLATE = 4L;
        private static final long INIT_BIT_SPEC_RUNNER_TEMPLATE = 8L;
        private static final long INIT_BIT_SCRIPT_RESOLVER = 16L;
        private static final long INIT_BIT_CUSTOM_RUNNER_CONFIGURATION = 32L;
        private static final long INIT_BIT_AUTO_REFRESH_INTERVAL = 64L;
        private long initBits = 127L;
        @Nullable
        private String sourceEncoding;
        @Nullable
        private ReporterType reporterType;
        @Nullable
        private String runnerTemplate;
        @Nullable
        private SpecRunnerTemplate specRunnerTemplate;
        @Nullable
        private ScriptResolver scriptResolver;
        @Nullable
        private String customRunnerConfiguration;
        private int autoRefreshInterval;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HtmlGeneratorConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceEncoding(instance.getSourceEncoding());
            this.reporterType(instance.getReporterType());
            this.runnerTemplate(instance.getRunnerTemplate());
            this.specRunnerTemplate(instance.getSpecRunnerTemplate());
            this.scriptResolver(instance.getScriptResolver());
            this.customRunnerConfiguration(instance.getCustomRunnerConfiguration());
            this.autoRefreshInterval(instance.getAutoRefreshInterval());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceEncoding(String sourceEncoding) {
            this.sourceEncoding = Objects.requireNonNull(sourceEncoding, "sourceEncoding");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reporterType(ReporterType reporterType) {
            this.reporterType = Objects.requireNonNull(reporterType, "reporterType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder runnerTemplate(String runnerTemplate) {
            this.runnerTemplate = Objects.requireNonNull(runnerTemplate, "runnerTemplate");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specRunnerTemplate(SpecRunnerTemplate specRunnerTemplate) {
            this.specRunnerTemplate = Objects.requireNonNull(specRunnerTemplate, "specRunnerTemplate");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scriptResolver(ScriptResolver scriptResolver) {
            this.scriptResolver = Objects.requireNonNull(scriptResolver, "scriptResolver");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customRunnerConfiguration(String customRunnerConfiguration) {
            this.customRunnerConfiguration = Objects.requireNonNull(customRunnerConfiguration, "customRunnerConfiguration");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder autoRefreshInterval(int autoRefreshInterval) {
            this.autoRefreshInterval = autoRefreshInterval;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableHtmlGeneratorConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHtmlGeneratorConfiguration(this.sourceEncoding, this.reporterType, this.runnerTemplate, this.specRunnerTemplate, this.scriptResolver, this.customRunnerConfiguration, this.autoRefreshInterval);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceEncoding");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reporterType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("runnerTemplate");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("specRunnerTemplate");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("scriptResolver");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("customRunnerConfiguration");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("autoRefreshInterval");
            }
            return "Cannot build HtmlGeneratorConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

