/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.server;

import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerManager.class);
    private static final int ANY_PORT = 0;
    public static final String FAILED_TO_BIND = "Failed to bind";
    private final ServerConnector connector;

    protected ServerManager(ServerConnector connector) {
        this.connector = connector;
    }

    public int start(Handler handler) throws Exception {
        return this.start(0, handler);
    }

    public int start(int port, Handler handler) throws Exception {
        this.connector.setPort(port);
        this.connector.getServer().setHandler(handler);
        try {
            this.connector.getServer().start();
        }
        catch (IOException e) {
            if (0 != port && e.getMessage().contains(FAILED_TO_BIND)) {
                LOGGER.debug("Unable to start on port {}. Trying a random port.", (Object)port, (Object)e);
                this.connector.setPort(0);
                this.connector.getServer().start();
            }
            throw e;
        }
        return this.connector.getLocalPort();
    }

    public void stop() throws Exception {
        this.connector.getServer().stop();
    }

    public void join() throws Exception {
        this.connector.getServer().join();
    }

    public static ServerManager newInstance() {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        return new ServerManager(connector);
    }
}

