/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockPlugin;
import be.seeseemelk.mockbukkit.ServerMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public class MockBukkit {
    private static ServerMock mock = null;

    private MockBukkit() {
    }

    protected static void setServerInstanceToNull() {
        try {
            Field server = Bukkit.class.getDeclaredField("server");
            server.setAccessible(true);
            server.set(null, null);
            mock = null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static ServerMock mock() {
        return MockBukkit.mock(new ServerMock());
    }

    public static <T extends ServerMock> T mock(T serverMockImplementation) {
        if (mock != null) {
            throw new IllegalStateException("Already mocking");
        }
        mock = serverMockImplementation;
        Level defaultLevel = mock.getLogger().getLevel();
        mock.getLogger().setLevel(Level.WARNING);
        Bukkit.setServer((Server)mock);
        mock.getLogger().setLevel(defaultLevel);
        return serverMockImplementation;
    }

    public static ServerMock getOrCreateMock() {
        if (!MockBukkit.isMocked()) {
            MockBukkit.mock();
        }
        return mock;
    }

    public static ServerMock getMock() {
        return mock;
    }

    public static boolean isMocked() {
        return mock != null;
    }

    public static void loadJar(String path) {
        try {
            MockBukkit.loadJar(new File(path));
        }
        catch (InvalidPluginException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadJar(File jarFile) throws InvalidPluginException {
        JavaPluginLoader loader = new JavaPluginLoader((Server)mock);
        Plugin plugin = loader.loadPlugin(jarFile);
        mock.getPluginManager().registerLoadedPlugin(plugin);
        mock.getPluginManager().enablePlugin(plugin);
    }

    public static <T extends JavaPlugin> T load(Class<T> plugin) {
        return MockBukkit.load(plugin, new Object[0]);
    }

    public static <T extends JavaPlugin> T load(Class<T> plugin, Object ... parameters) {
        if (mock != null) {
            JavaPlugin instance = mock.getPluginManager().loadPlugin(plugin, parameters);
            mock.getPluginManager().enablePlugin((Plugin)instance);
            return (T)((JavaPlugin)plugin.cast(instance));
        }
        throw new IllegalStateException("Not mocking");
    }

    public static <T extends JavaPlugin> T loadWith(Class<T> plugin, PluginDescriptionFile descriptionFile, Object ... parameters) {
        if (mock != null) {
            JavaPlugin instance = mock.getPluginManager().loadPlugin(plugin, descriptionFile, parameters);
            mock.getPluginManager().enablePlugin((Plugin)instance);
            return (T)((JavaPlugin)plugin.cast(instance));
        }
        throw new IllegalStateException("Not mocking");
    }

    public static <T extends JavaPlugin> T loadWith(Class<T> plugin, InputStream descriptionInput, Object ... parameters) {
        try {
            return MockBukkit.loadWith(plugin, new PluginDescriptionFile(descriptionInput), parameters);
        }
        catch (InvalidDescriptionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends JavaPlugin> T loadWith(Class<T> plugin, File descriptionFile, Object ... parameters) {
        try {
            return MockBukkit.loadWith(plugin, new FileInputStream(descriptionFile), parameters);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends JavaPlugin> T loadWith(Class<T> plugin, String descriptionFileName, Object ... parameters) {
        return MockBukkit.loadWith(plugin, ClassLoader.getSystemResourceAsStream(descriptionFileName), parameters);
    }

    public static <T extends JavaPlugin> T loadSimple(Class<T> plugin, Object ... parameters) {
        PluginDescriptionFile description = new PluginDescriptionFile(plugin.getSimpleName(), "1.0.0", plugin.getCanonicalName());
        if (mock != null) {
            JavaPlugin instance = mock.getPluginManager().loadPlugin(plugin, description, parameters);
            mock.getPluginManager().enablePlugin((Plugin)instance);
            return (T)((JavaPlugin)plugin.cast(instance));
        }
        throw new IllegalStateException("Not mocking");
    }

    @Deprecated
    public static void unload() {
        MockBukkit.unmock();
    }

    public static void unmock() {
        if (mock == null) {
            return;
        }
        try {
            mock.getScheduler().shutdown();
        }
        finally {
            if (mock.getPluginManager() != null) {
                mock.getPluginManager().disablePlugins();
            }
            mock.getPluginManager().unload();
            MockBukkit.setServerInstanceToNull();
        }
    }

    public static MockPlugin createMockPlugin() {
        if (mock != null) {
            PluginDescriptionFile description = new PluginDescriptionFile("MockPlugin", "1.0.0", MockPlugin.class.getName());
            JavaPlugin instance = mock.getPluginManager().loadPlugin(MockPlugin.class, description);
            mock.getPluginManager().enablePlugin((Plugin)instance);
            return (MockPlugin)instance;
        }
        throw new IllegalStateException("Not mocking");
    }
}

