/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockCommandMap;
import be.seeseemelk.mockbukkit.MockUnsafeValues;
import be.seeseemelk.mockbukkit.PlayerList;
import be.seeseemelk.mockbukkit.ThreadAccessException;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.boss.BossBarMock;
import be.seeseemelk.mockbukkit.boss.KeyedBossBarMock;
import be.seeseemelk.mockbukkit.command.CommandResult;
import be.seeseemelk.mockbukkit.command.ConsoleCommandSenderMock;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentsMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMockFactory;
import be.seeseemelk.mockbukkit.inventory.ChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.ItemFactoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.plugin.PluginManagerMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import be.seeseemelk.mockbukkit.scheduler.BukkitSchedulerMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardManagerMock;
import be.seeseemelk.mockbukkit.tags.TagRegistry;
import be.seeseemelk.mockbukkit.tags.TagWrapperMock;
import be.seeseemelk.mockbukkit.tags.TagsMock;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapView;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.CachedServerIcon;
import org.jetbrains.annotations.NotNull;

public class ServerMock
implements Server {
    private static final String BUKKIT_VERSION = "1.16.2";
    private static final String JOIN_MESSAGE = "%s has joined the server.";
    private final Logger logger;
    private final Thread mainThread;
    private final MockUnsafeValues unsafe = new MockUnsafeValues();
    private final Map<String, TagRegistry> materialTags = new HashMap<String, TagRegistry>();
    private final List<PlayerMock> players = new ArrayList<PlayerMock>();
    private final Set<OfflinePlayer> offlinePlayers = new HashSet<OfflinePlayer>();
    private final Set<EntityMock> entities = new HashSet<EntityMock>();
    private final List<World> worlds = new ArrayList<World>();
    private final List<Recipe> recipes = new LinkedList<Recipe>();
    private final Map<NamespacedKey, KeyedBossBarMock> bossBars = new HashMap<NamespacedKey, KeyedBossBarMock>();
    private final ItemFactory factory = new ItemFactoryMock();
    private final PlayerMockFactory playerFactory = new PlayerMockFactory(this);
    private final PluginManagerMock pluginManager = new PluginManagerMock(this);
    private final ScoreboardManagerMock scoreboardManager = new ScoreboardManagerMock();
    private final BukkitSchedulerMock scheduler = new BukkitSchedulerMock();
    private final PlayerList playerList = new PlayerList();
    private ConsoleCommandSender consoleSender;
    private GameMode defaultGameMode = GameMode.SURVIVAL;
    private MockCommandMap commandMap;

    public ServerMock() {
        this.mainThread = Thread.currentThread();
        this.logger = Logger.getLogger("ServerMock");
        this.commandMap = new MockCommandMap(this);
        ServerMock.registerSerializables();
        this.createPotionEffectTypes();
        TagsMock.loadDefaultTags(this, true);
        EnchantmentsMock.registerDefaultEnchantments();
        try {
            InputStream stream = ClassLoader.getSystemResourceAsStream("logger.properties");
            LogManager.getLogManager().readConfiguration(stream);
        }
        catch (IOException e) {
            this.logger.warning("Could not load file logger.properties");
        }
        this.logger.setLevel(Level.ALL);
    }

    public boolean isOnMainThread() {
        return this.mainThread.equals(Thread.currentThread());
    }

    public void assertMainThread() {
        if (!this.isOnMainThread()) {
            throw new ThreadAccessException("The Bukkit API was accessed from asynchronous code.");
        }
    }

    public void registerEntity(EntityMock entity) {
        this.assertMainThread();
        this.entities.add(entity);
    }

    public Set<EntityMock> getEntities() {
        return Collections.unmodifiableSet(this.entities);
    }

    public void addPlayer(PlayerMock player) {
        this.assertMainThread();
        this.players.add(player);
        this.offlinePlayers.add((OfflinePlayer)player);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)player, String.format(JOIN_MESSAGE, player.getDisplayName()));
        Bukkit.getPluginManager().callEvent((Event)playerJoinEvent);
        player.setLastPlayed(this.getCurrentServerTime());
        this.registerEntity(player);
    }

    public PlayerMock addPlayer() {
        this.assertMainThread();
        PlayerMock player = this.playerFactory.createRandomPlayer();
        this.addPlayer(player);
        return player;
    }

    public PlayerMock addPlayer(String name) {
        this.assertMainThread();
        PlayerMock player = new PlayerMock(this, name);
        this.addPlayer(player);
        return player;
    }

    public void setPlayers(int num) {
        this.assertMainThread();
        this.players.clear();
        for (int i = 0; i < num; ++i) {
            this.addPlayer();
        }
    }

    public void setOfflinePlayers(int num) {
        this.assertMainThread();
        this.offlinePlayers.clear();
        this.offlinePlayers.addAll(this.players);
        for (int i = 0; i < num; ++i) {
            OfflinePlayerMock player = this.playerFactory.createRandomOfflinePlayer();
            this.offlinePlayers.add(player);
        }
    }

    public PlayerMock getPlayer(int num) {
        if (num < 0 || num >= this.players.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.players.get(num);
    }

    public WorldMock addSimpleWorld(String name) {
        this.assertMainThread();
        WorldMock world = new WorldMock();
        world.setName(name);
        this.worlds.add(world);
        return world;
    }

    public void addWorld(WorldMock world) {
        this.assertMainThread();
        this.worlds.add(world);
    }

    public CommandResult executeConsole(Command command, String ... args) {
        this.assertMainThread();
        return this.execute(command, (CommandSender)this.getConsoleSender(), args);
    }

    public CommandResult executeConsole(String command, String ... args) {
        this.assertMainThread();
        return this.executeConsole((Command)this.getPluginCommand(command), args);
    }

    public CommandResult executePlayer(Command command, String ... args) {
        this.assertMainThread();
        if (!this.players.isEmpty()) {
            return this.execute(command, (CommandSender)this.players.get(0), args);
        }
        throw new IllegalStateException("Need at least one player to run the command");
    }

    public CommandResult executePlayer(String command, String ... args) {
        this.assertMainThread();
        return this.executePlayer((Command)this.getPluginCommand(command), args);
    }

    public CommandResult execute(Command command, CommandSender sender, String ... args) {
        this.assertMainThread();
        if (!(sender instanceof MessageTarget)) {
            throw new IllegalArgumentException("Only a MessageTarget can be the sender of the command");
        }
        boolean status = command.execute(sender, command.getName(), args);
        return new CommandResult(status, (MessageTarget)sender);
    }

    public CommandResult execute(String command, CommandSender sender, String ... args) {
        this.assertMainThread();
        return this.execute((Command)this.getPluginCommand(command), sender, args);
    }

    public String getName() {
        return "ServerMock";
    }

    public String getVersion() {
        return "0.1.0";
    }

    public String getBukkitVersion() {
        return BUKKIT_VERSION;
    }

    public Collection<? extends PlayerMock> getOnlinePlayers() {
        this.assertMainThread();
        return this.players;
    }

    public OfflinePlayer[] getOfflinePlayers() {
        return this.offlinePlayers.toArray(new OfflinePlayer[0]);
    }

    public Player getPlayer(String name) {
        Player player = this.getPlayerExact(name);
        if (player != null) {
            return player;
        }
        String lowercase = name.toLowerCase(Locale.ENGLISH);
        int delta = Integer.MAX_VALUE;
        for (Player player2 : this.players) {
            int currentDelta;
            if (!player2.getName().toLowerCase(Locale.ENGLISH).startsWith(lowercase) || (currentDelta = Math.abs(player2.getName().length() - lowercase.length())) >= delta) continue;
            delta = currentDelta;
            player = player2;
        }
        return player;
    }

    public Player getPlayerExact(String name) {
        this.assertMainThread();
        return this.players.stream().filter(playerMock -> playerMock.getName().toLowerCase(Locale.ENGLISH).equals(name.toLowerCase(Locale.ENGLISH))).findFirst().orElse(null);
    }

    public List<Player> matchPlayer(String name) {
        this.assertMainThread();
        return this.players.stream().filter(player -> player.getName().toLowerCase(Locale.ENGLISH).startsWith(name.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    public Player getPlayer(UUID id) {
        this.assertMainThread();
        for (Player player : this.getOnlinePlayers()) {
            if (!id.equals(player.getUniqueId())) continue;
            return player;
        }
        return null;
    }

    public PluginManagerMock getPluginManager() {
        return this.pluginManager;
    }

    private boolean isLabelOfCommand(PluginCommand command, String label) {
        this.assertMainThread();
        if (label.equals(command.getName())) {
            return true;
        }
        for (String alias : command.getAliases()) {
            if (!label.equals(alias)) continue;
            return true;
        }
        return false;
    }

    public PluginCommand getPluginCommand(String name) {
        this.assertMainThread();
        for (PluginCommand command : this.getPluginManager().getCommands()) {
            if (!this.isLabelOfCommand(command, name)) continue;
            return command;
        }
        return null;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ConsoleCommandSender getConsoleSender() {
        if (this.consoleSender == null) {
            this.consoleSender = new ConsoleCommandSenderMock();
        }
        return this.consoleSender;
    }

    public InventoryMock createInventory(InventoryHolder owner, InventoryType type, String title, int size) {
        this.assertMainThread();
        switch (type) {
            case PLAYER: {
                PlayerInventoryMock inventory = new PlayerInventoryMock((HumanEntity)owner);
                return inventory;
            }
            case CHEST: {
                ChestInventoryMock inventory = new ChestInventoryMock(owner, size > 0 ? size : 27);
                return inventory;
            }
            case ENDER_CHEST: {
                EnderChestInventoryMock inventory = new EnderChestInventoryMock(owner);
                return inventory;
            }
        }
        throw new UnimplementedOperationException("Inventory type not yet supported");
    }

    public InventoryMock createInventory(InventoryHolder owner, InventoryType type) {
        return this.createInventory(owner, type, "Inventory");
    }

    public InventoryMock createInventory(InventoryHolder owner, InventoryType type, String title) {
        return this.createInventory(owner, type, title, -1);
    }

    public InventoryMock createInventory(InventoryHolder owner, int size) {
        return this.createInventory(owner, size, "Inventory");
    }

    public InventoryMock createInventory(InventoryHolder owner, int size, String title) {
        return this.createInventory(owner, InventoryType.CHEST, title, size);
    }

    public ItemFactory getItemFactory() {
        return this.factory;
    }

    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds);
    }

    public World getWorld(String name) {
        return this.worlds.stream().filter(world -> world.getName().equals(name)).findAny().orElse(null);
    }

    public World getWorld(UUID uid) {
        return this.worlds.stream().filter(world -> world.getUID().equals(uid)).findAny().orElse(null);
    }

    public BukkitSchedulerMock getScheduler() {
        return this.scheduler;
    }

    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    public Set<String> getIPBans() {
        return this.playerList.getIPBans().getBanEntries().stream().map(BanEntry::getTarget).collect(Collectors.toSet());
    }

    public void banIP(String address) {
        this.assertMainThread();
        this.playerList.getIPBans().addBan(address, null, null, null);
    }

    public void unbanIP(String address) {
        this.assertMainThread();
        this.playerList.getIPBans().pardon(address);
    }

    public BanList getBanList(BanList.Type type) {
        switch (type) {
            case IP: {
                return this.playerList.getIPBans();
            }
        }
        return this.playerList.getProfileBans();
    }

    public Set<OfflinePlayer> getOperators() {
        this.assertMainThread();
        HashSet<Object> allPlayers = new HashSet<Object>();
        allPlayers.addAll(this.offlinePlayers);
        allPlayers.addAll(this.players);
        return allPlayers.stream().filter(ServerOperator::isOp).collect(Collectors.toSet());
    }

    public GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public void setDefaultGameMode(GameMode mode) {
        this.assertMainThread();
        this.defaultGameMode = mode;
    }

    public int broadcastMessage(String message) {
        this.assertMainThread();
        for (Player player : this.players) {
            player.sendMessage(message);
        }
        return this.players.size();
    }

    public static void registerSerializables() {
        ConfigurationSerialization.registerClass(ItemMetaMock.class);
    }

    public boolean addRecipe(Recipe recipe) {
        this.assertMainThread();
        this.recipes.add(recipe);
        return true;
    }

    public List<Recipe> getRecipesFor(@NotNull ItemStack item) {
        this.assertMainThread();
        return this.recipes.stream().filter(recipe -> {
            ItemStack result = recipe.getResult();
            return result.getType() == item.getType() && result.getItemMeta().equals(item.getItemMeta());
        }).collect(Collectors.toList());
    }

    public Recipe getRecipe(NamespacedKey key) {
        this.assertMainThread();
        for (Recipe recipe : this.recipes) {
            if (!(recipe instanceof Keyed) || !((Keyed)recipe).getKey().equals((Object)key)) continue;
            return recipe;
        }
        return null;
    }

    public boolean removeRecipe(NamespacedKey key) {
        this.assertMainThread();
        Iterator<Recipe> iterator = this.recipeIterator();
        while (iterator.hasNext()) {
            Recipe recipe = iterator.next();
            if (!(recipe instanceof Keyed) || !((Keyed)recipe).getKey().equals((Object)key)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public Iterator<Recipe> recipeIterator() {
        this.assertMainThread();
        return this.recipes.iterator();
    }

    public void clearRecipes() {
        this.assertMainThread();
        this.recipes.clear();
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        this.assertMainThread();
        String[] commands = commandLine.split(" ");
        String commandLabel = commands[0];
        String[] args = Arrays.copyOfRange(commands, 1, commands.length);
        PluginCommand command = this.getPluginCommand(commandLabel);
        if (command != null) {
            return command.execute(sender, commandLabel, args);
        }
        return false;
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        throw new UnimplementedOperationException();
    }

    public Set<String> getListeningPluginChannels() {
        throw new UnimplementedOperationException();
    }

    public int getPort() {
        throw new UnimplementedOperationException();
    }

    public int getViewDistance() {
        throw new UnimplementedOperationException();
    }

    public String getIp() {
        throw new UnimplementedOperationException();
    }

    public String getWorldType() {
        throw new UnimplementedOperationException();
    }

    public boolean getGenerateStructures() {
        throw new UnimplementedOperationException();
    }

    public boolean getAllowEnd() {
        throw new UnimplementedOperationException();
    }

    public boolean getAllowNether() {
        throw new UnimplementedOperationException();
    }

    public boolean hasWhitelist() {
        throw new UnimplementedOperationException();
    }

    public void setWhitelist(boolean value) {
        throw new UnimplementedOperationException();
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        throw new UnimplementedOperationException();
    }

    public void reloadWhitelist() {
        throw new UnimplementedOperationException();
    }

    public String getUpdateFolder() {
        throw new UnimplementedOperationException();
    }

    public File getUpdateFolderFile() {
        throw new UnimplementedOperationException();
    }

    public long getConnectionThrottle() {
        throw new UnimplementedOperationException();
    }

    public int getTicksPerAnimalSpawns() {
        throw new UnimplementedOperationException();
    }

    public int getTicksPerMonsterSpawns() {
        throw new UnimplementedOperationException();
    }

    public ServicesManager getServicesManager() {
        throw new UnimplementedOperationException();
    }

    public World createWorld(WorldCreator creator) {
        throw new UnimplementedOperationException();
    }

    public boolean unloadWorld(String name, boolean save) {
        throw new UnimplementedOperationException();
    }

    public boolean unloadWorld(World world, boolean save) {
        throw new UnimplementedOperationException();
    }

    public MapView createMap(World world) {
        throw new UnimplementedOperationException();
    }

    public void reload() {
        throw new UnimplementedOperationException();
    }

    public void reloadData() {
        throw new UnimplementedOperationException();
    }

    public void savePlayers() {
        throw new UnimplementedOperationException();
    }

    public void resetRecipes() {
        throw new UnimplementedOperationException();
    }

    public Map<String, String[]> getCommandAliases() {
        throw new UnimplementedOperationException();
    }

    public int getSpawnRadius() {
        throw new UnimplementedOperationException();
    }

    public void setSpawnRadius(int value) {
        throw new UnimplementedOperationException();
    }

    public boolean getOnlineMode() {
        throw new UnimplementedOperationException();
    }

    public boolean getAllowFlight() {
        throw new UnimplementedOperationException();
    }

    public boolean isHardcore() {
        throw new UnimplementedOperationException();
    }

    public void shutdown() {
        throw new UnimplementedOperationException();
    }

    public int broadcast(String message, String permission) {
        throw new UnimplementedOperationException();
    }

    public OfflinePlayer getOfflinePlayer(String name) {
        Player player = this.getPlayer(name);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.getName().equals(name)) continue;
            return offlinePlayer;
        }
        return new OfflinePlayerMock(name);
    }

    public OfflinePlayer getOfflinePlayer(UUID id) {
        Player player = this.getPlayer(id);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.getUniqueId().equals(id)) continue;
            return offlinePlayer;
        }
        return this.playerFactory.createRandomOfflinePlayer();
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        throw new UnimplementedOperationException();
    }

    public File getWorldContainer() {
        throw new UnimplementedOperationException();
    }

    public Messenger getMessenger() {
        throw new UnimplementedOperationException();
    }

    public HelpMap getHelpMap() {
        throw new UnimplementedOperationException();
    }

    public Merchant createMerchant(String title) {
        throw new UnimplementedOperationException();
    }

    public int getMonsterSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getWaterAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public boolean isPrimaryThread() {
        return this.isOnMainThread();
    }

    public String getMotd() {
        throw new UnimplementedOperationException();
    }

    public String getShutdownMessage() {
        throw new UnimplementedOperationException();
    }

    public Warning.WarningState getWarningState() {
        throw new UnimplementedOperationException();
    }

    public ScoreboardManagerMock getScoreboardManager() {
        return this.scoreboardManager;
    }

    public CachedServerIcon getServerIcon() {
        throw new UnimplementedOperationException();
    }

    public CachedServerIcon loadServerIcon(File file) {
        throw new UnimplementedOperationException();
    }

    public CachedServerIcon loadServerIcon(BufferedImage image) {
        throw new UnimplementedOperationException();
    }

    public void setIdleTimeout(int threshold) {
        throw new UnimplementedOperationException();
    }

    public int getIdleTimeout() {
        throw new UnimplementedOperationException();
    }

    public ChunkGenerator.ChunkData createChunkData(World world) {
        throw new UnimplementedOperationException();
    }

    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        BossBarMock bar = new BossBarMock(title, color, style, flags);
        return bar;
    }

    public Entity getEntity(UUID uuid) {
        throw new UnimplementedOperationException();
    }

    public Advancement getAdvancement(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    public Iterator<Advancement> advancementIterator() {
        throw new UnimplementedOperationException();
    }

    public UnsafeValues getUnsafe() {
        return this.unsafe;
    }

    public BlockData createBlockData(Material material) {
        throw new UnimplementedOperationException();
    }

    public BlockData createBlockData(Material material, Consumer<BlockData> consumer) {
        throw new UnimplementedOperationException();
    }

    public BlockData createBlockData(String data) {
        throw new UnimplementedOperationException();
    }

    public BlockData createBlockData(Material material, String data) {
        throw new UnimplementedOperationException();
    }

    public Tag<Material> createMaterialTag(NamespacedKey key, String registryKey, Material ... materials) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must never be null");
        TagRegistry registry = this.materialTags.get(registryKey);
        TagWrapperMock tag = new TagWrapperMock(registry, key);
        registry.getTags().put(key, tag);
        return tag;
    }

    public void addTagRegistry(@NotNull TagRegistry registry) {
        this.materialTags.put(registry.getRegistry(), registry);
    }

    public <T extends Keyed> Tag<T> getTag(String registryKey, NamespacedKey key, Class<T> clazz) {
        Tag tag;
        TagRegistry registry;
        if (clazz == Material.class && (registry = this.materialTags.get(registryKey)) != null && (tag = (Tag)registry.getTags().get(key)) != null) {
            return tag;
        }
        return null;
    }

    private void createPotionEffectTypes() {
        for (PotionEffectType type : PotionEffectType.values()) {
            if (type == null) continue;
            return;
        }
        this.registerPotionEffectType(1, "SPEED", false, 8171462);
        this.registerPotionEffectType(2, "SLOWNESS", false, 5926017);
        this.registerPotionEffectType(3, "HASTE", false, 14270531);
        this.registerPotionEffectType(4, "MINING_FATIGUE", false, 4866583);
        this.registerPotionEffectType(5, "STRENGTH", false, 9643043);
        this.registerPotionEffectType(6, "INSTANT_HEALTH", true, 16262179);
        this.registerPotionEffectType(7, "INSTANT_DAMAGE", true, 4393481);
        this.registerPotionEffectType(8, "JUMP_BOOST", false, 2293580);
        this.registerPotionEffectType(9, "NAUSEA", false, 5578058);
        this.registerPotionEffectType(10, "REGENERATION", false, 13458603);
        this.registerPotionEffectType(11, "RESISTANCE", false, 10044730);
        this.registerPotionEffectType(12, "FIRE_RESISTANCE", false, 14981690);
        this.registerPotionEffectType(13, "WATER_BREATHING", false, 3035801);
        this.registerPotionEffectType(14, "INVISIBILITY", false, 8356754);
        this.registerPotionEffectType(15, "BLINDNESS", false, 2039587);
        this.registerPotionEffectType(16, "NIGHT_VISION", false, 0x1F1FA1);
        this.registerPotionEffectType(17, "HUNGER", false, 5797459);
        this.registerPotionEffectType(18, "WEAKNESS", false, 0x484D48);
        this.registerPotionEffectType(19, "POISON", false, 5149489);
        this.registerPotionEffectType(20, "WITHER", false, 3484199);
        this.registerPotionEffectType(21, "HEALTH_BOOST", false, 16284963);
        this.registerPotionEffectType(22, "ABSORPTION", false, 0x2552A5);
        this.registerPotionEffectType(23, "SATURATION", true, 16262179);
        this.registerPotionEffectType(24, "GLOWING", false, 9740385);
        this.registerPotionEffectType(25, "LEVITATION", false, 0xCEFFFF);
        this.registerPotionEffectType(26, "LUCK", false, 0x339900);
        this.registerPotionEffectType(27, "UNLUCK", false, 12624973);
        this.registerPotionEffectType(28, "SLOW_FALLING", false, 16773073);
        this.registerPotionEffectType(29, "CONDUIT_POWER", false, 1950417);
        this.registerPotionEffectType(30, "DOLPHINS_GRACE", false, 8954814);
        this.registerPotionEffectType(31, "BAD_OMEN", false, 745784);
        this.registerPotionEffectType(32, "HERO_OF_THE_VILLAGE", false, 45217);
        PotionEffectType.stopAcceptingRegistrations();
    }

    private void registerPotionEffectType(int id, String name, boolean instant, int rgb) {
        MockPotionEffectType type = new MockPotionEffectType(id, name, instant, Color.fromRGB((int)rgb));
        PotionEffectType.registerPotionEffectType((PotionEffectType)type);
    }

    public LootTable getLootTable(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        throw new UnimplementedOperationException();
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor color, BarStyle style, BarFlag ... flags) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must never be null");
        KeyedBossBarMock bar = new KeyedBossBarMock(key, title, color, style, flags);
        this.bossBars.put(key, bar);
        return bar;
    }

    public Iterator<KeyedBossBar> getBossBars() {
        return this.bossBars.values().stream().map(bossbar -> bossbar).iterator();
    }

    public KeyedBossBar getBossBar(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must never be null");
        return this.bossBars.get(key);
    }

    public boolean removeBossBar(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must never be null");
        return this.bossBars.remove(key, this.bossBars.get(key));
    }

    public List<Entity> selectEntities(CommandSender sender, String selector) {
        throw new UnimplementedOperationException();
    }

    public MapView getMap(int id) {
        throw new UnimplementedOperationException();
    }

    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        throw new UnimplementedOperationException();
    }

    public MockCommandMap getCommandMap() {
        return this.commandMap;
    }

    public int getTicksPerWaterSpawns() {
        throw new UnimplementedOperationException();
    }

    public int getTicksPerAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    protected long getCurrentServerTime() {
        return System.currentTimeMillis();
    }

    public int getTicksPerWaterAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    public int getWaterAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public Server.Spigot spigot() {
        throw new UnimplementedOperationException();
    }
}

