/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedTransferQueue;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pose;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class EntityMock
implements Entity,
MessageTarget {
    private final ServerMock server;
    private final UUID uuid;
    private Location location;
    private boolean teleported;
    private PlayerTeleportEvent.TeleportCause teleportCause;
    private MetadataTable metadataTable = new MetadataTable();
    private PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();
    private boolean operator = false;
    private String name = "entity";
    private final Queue<String> messages = new LinkedTransferQueue<String>();
    private final Set<PermissionAttachment> permissionAttachments = new HashSet<PermissionAttachment>();
    private Vector velocity = new Vector(0, 0, 0);
    private float fallDistance;

    public EntityMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        this.server = server;
        this.uuid = uuid;
        this.location = !Bukkit.getWorlds().isEmpty() ? ((World)Bukkit.getWorlds().get(0)).getSpawnLocation() : new Location(null, 0.0, 0.0, 0.0);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityMock) {
            return this.uuid.equals(((EntityMock)obj).getUniqueId());
        }
        return false;
    }

    public void assertLocation(Location expectedLocation, double maximumDistance) {
        double distance = this.location.distance(expectedLocation);
        Assert.assertEquals((Object)expectedLocation.getWorld(), (Object)this.location.getWorld());
        Assert.assertTrue((String)String.format("Distance was <%.3f> but should be less than or equal to <%.3f>", distance, maximumDistance), (distance <= maximumDistance ? 1 : 0) != 0);
    }

    public void assertTeleported(Location expectedLocation, double maximumDistance) {
        Assert.assertTrue((String)"Player did not teleport", (boolean)this.teleported);
        this.assertLocation(expectedLocation, maximumDistance);
        this.teleported = false;
    }

    public void assertNotTeleported() {
        Assert.assertFalse((String)"Player was teleported", (boolean)this.teleported);
        this.teleported = false;
    }

    public boolean hasTeleported() {
        return this.teleported;
    }

    public void clearTeleported() {
        this.teleported = false;
    }

    public PlayerTeleportEvent.TeleportCause getTeleportCause() {
        return this.teleportCause;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public Location getLocation() {
        return this.location.clone();
    }

    public Location getLocation(Location loc) {
        loc.setWorld(this.location.getWorld());
        loc.setDirection(this.location.getDirection());
        loc.setX(this.location.getX());
        loc.setY(this.location.getY());
        loc.setZ(this.location.getZ());
        return loc;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public World getWorld() {
        return this.location.getWorld();
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        this.location = location;
        this.teleported = true;
        this.teleportCause = cause;
        return true;
    }

    public boolean teleport(Entity destination) {
        return this.teleport(destination, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    public boolean isOp() {
        return this.operator;
    }

    public void setOp(boolean isOperator) {
        this.operator = isOperator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void sendMessage(String message) {
        this.messages.add(message);
    }

    public void sendMessage(String[] messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public String nextMessage() {
        return this.messages.poll();
    }

    public boolean isPermissionSet(String name) {
        for (PermissionAttachment attachment : this.permissionAttachments) {
            Map permissions = attachment.getPermissions();
            if (!permissions.containsKey(name) || !((Boolean)permissions.get(name)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isPermissionSet(Permission perm) {
        return this.isPermissionSet(perm.getName().toLowerCase(Locale.ENGLISH));
    }

    public boolean hasPermission(String name) {
        if (this.isPermissionSet(name)) {
            return true;
        }
        Permission perm = this.server.getPluginManager().getPermission(name);
        return perm != null ? this.hasPermission(perm) : Permission.DEFAULT_PERMISSION.getValue(this.isOp());
    }

    public boolean hasPermission(Permission perm) {
        return this.isPermissionSet(perm) || perm.getDefault().getValue(this.isOp());
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        PermissionAttachment attachment = this.addAttachment(plugin);
        attachment.setPermission(name, value);
        return attachment;
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        PermissionAttachment attachment = new PermissionAttachment(plugin, (Permissible)this);
        this.permissionAttachments.add(attachment);
        return attachment;
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        throw new UnimplementedOperationException();
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        throw new UnimplementedOperationException();
    }

    public void removeAttachment(PermissionAttachment attachment) {
        throw new UnimplementedOperationException();
    }

    public void recalculatePermissions() {
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        throw new UnimplementedOperationException();
    }

    public String getCustomName() {
        throw new UnimplementedOperationException();
    }

    public void setCustomName(String name) {
        throw new UnimplementedOperationException();
    }

    public void setVelocity(@NotNull Vector velocity) {
        this.velocity = velocity;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public double getHeight() {
        throw new UnimplementedOperationException();
    }

    public double getWidth() {
        throw new UnimplementedOperationException();
    }

    public boolean isOnGround() {
        throw new UnimplementedOperationException();
    }

    public List<Entity> getNearbyEntities(double x, double y, double z) {
        throw new UnimplementedOperationException();
    }

    public int getEntityId() {
        throw new UnimplementedOperationException();
    }

    public int getFireTicks() {
        throw new UnimplementedOperationException();
    }

    public int getMaxFireTicks() {
        throw new UnimplementedOperationException();
    }

    public void setFireTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    public void remove() {
        throw new UnimplementedOperationException();
    }

    public boolean isDead() {
        throw new UnimplementedOperationException();
    }

    public boolean isValid() {
        return !this.isDead();
    }

    public ServerMock getServer() {
        return this.server;
    }

    public Entity getPassenger() {
        throw new UnimplementedOperationException();
    }

    public boolean setPassenger(Entity passenger) {
        throw new UnimplementedOperationException();
    }

    public List<Entity> getPassengers() {
        throw new UnimplementedOperationException();
    }

    public boolean addPassenger(Entity passenger) {
        throw new UnimplementedOperationException();
    }

    public boolean removePassenger(Entity passenger) {
        throw new UnimplementedOperationException();
    }

    public boolean isEmpty() {
        throw new UnimplementedOperationException();
    }

    public boolean eject() {
        throw new UnimplementedOperationException();
    }

    public float getFallDistance() {
        return this.fallDistance;
    }

    public void setFallDistance(float distance) {
        this.fallDistance = distance;
    }

    public void setLastDamageCause(EntityDamageEvent event) {
        throw new UnimplementedOperationException();
    }

    public EntityDamageEvent getLastDamageCause() {
        throw new UnimplementedOperationException();
    }

    public int getTicksLived() {
        throw new UnimplementedOperationException();
    }

    public void setTicksLived(int value) {
        throw new UnimplementedOperationException();
    }

    public void playEffect(EntityEffect type) {
        throw new UnimplementedOperationException();
    }

    public boolean isInsideVehicle() {
        throw new UnimplementedOperationException();
    }

    public boolean leaveVehicle() {
        throw new UnimplementedOperationException();
    }

    public Entity getVehicle() {
        throw new UnimplementedOperationException();
    }

    public void setCustomNameVisible(boolean flag) {
        throw new UnimplementedOperationException();
    }

    public boolean isCustomNameVisible() {
        throw new UnimplementedOperationException();
    }

    public void setGlowing(boolean flag) {
        throw new UnimplementedOperationException();
    }

    public boolean isGlowing() {
        throw new UnimplementedOperationException();
    }

    public void setInvulnerable(boolean flag) {
        throw new UnimplementedOperationException();
    }

    public boolean isInvulnerable() {
        throw new UnimplementedOperationException();
    }

    public boolean isSilent() {
        throw new UnimplementedOperationException();
    }

    public void setSilent(boolean flag) {
        throw new UnimplementedOperationException();
    }

    public boolean hasGravity() {
        throw new UnimplementedOperationException();
    }

    public void setGravity(boolean gravity) {
        throw new UnimplementedOperationException();
    }

    public int getPortalCooldown() {
        throw new UnimplementedOperationException();
    }

    public void setPortalCooldown(int cooldown) {
        throw new UnimplementedOperationException();
    }

    public Set<String> getScoreboardTags() {
        throw new UnimplementedOperationException();
    }

    public boolean addScoreboardTag(String tag) {
        throw new UnimplementedOperationException();
    }

    public boolean removeScoreboardTag(String tag) {
        throw new UnimplementedOperationException();
    }

    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnimplementedOperationException();
    }

    public void setRotation(float yaw, float pitch) {
        throw new UnimplementedOperationException();
    }

    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    public boolean isPersistent() {
        throw new UnimplementedOperationException();
    }

    public void setPersistent(boolean persistent) {
        throw new UnimplementedOperationException();
    }

    public BlockFace getFacing() {
        throw new UnimplementedOperationException();
    }

    public Pose getPose() {
        throw new UnimplementedOperationException();
    }
}

