/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.AudioExperience;
import be.seeseemelk.mockbukkit.entity.LivingEntityMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryViewMock;
import be.seeseemelk.mockbukkit.inventory.SimpleInventoryViewMock;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Villager;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class PlayerMock
extends LivingEntityMock
implements Player {
    private boolean online;
    private PlayerInventoryMock inventory = null;
    private EnderChestInventoryMock enderChest = null;
    private GameMode gamemode = GameMode.SURVIVAL;
    private String displayName = null;
    private int expTotal = 0;
    private float exp = 0.0f;
    private int foodLevel = 20;
    private float saturation = 5.0f;
    private int expLevel = 0;
    private boolean sneaking = false;
    private boolean whitelisted = true;
    private InventoryView inventoryView;
    private Location compassTarget;
    private Location bedSpawnLocation;
    private ItemStack cursor = null;
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private final List<AudioExperience> heardSounds = new LinkedList<AudioExperience>();

    public PlayerMock(ServerMock server, String name) {
        this(server, name, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)));
        this.online = false;
    }

    public PlayerMock(ServerMock server, String name, UUID uuid) {
        super(server, uuid);
        this.setName(name);
        this.setDisplayName(name);
        this.online = true;
        if (Bukkit.getWorlds().isEmpty()) {
            MockBukkit.getMock().addSimpleWorld("world");
        }
        this.setLocation(((World)Bukkit.getWorlds().get(0)).getSpawnLocation().clone());
        this.setCompassTarget(this.getLocation());
        this.closeInventory();
    }

    public EntityType getType() {
        return EntityType.PLAYER;
    }

    public void assertGameMode(GameMode expectedGamemode) {
        Assert.assertEquals((Object)expectedGamemode, (Object)this.gamemode);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.attributes, Float.valueOf(this.exp), this.expLevel, this.expTotal, this.displayName, this.gamemode, this.getHealth(), this.foodLevel, Float.valueOf(this.saturation), this.inventory, this.enderChest, this.inventoryView, this.getMaxHealth(), this.online, this.whitelisted, this.compassTarget, this.bedSpawnLocation, this.cursor, this.firstPlayed, this.lastPlayed);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PlayerMock)) {
            return false;
        }
        PlayerMock other = (PlayerMock)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.displayName, other.displayName) && this.gamemode == other.gamemode && Double.doubleToLongBits(this.getHealth()) == Double.doubleToLongBits(other.getHealth()) && Objects.equals(this.inventory, other.inventory) && Objects.equals(this.inventoryView, other.inventoryView) && Objects.equals(this.cursor, other.cursor) && Double.doubleToLongBits(this.getMaxHealth()) == Double.doubleToLongBits(other.getMaxHealth()) && this.online == other.online && this.whitelisted == other.whitelisted && this.isDead() == other.isDead() && this.firstPlayed == other.firstPlayed && this.lastPlayed == other.lastPlayed;
    }

    protected BlockDamageEvent simulateBlockDamagePure(Block block) {
        BlockDamageEvent event = new BlockDamageEvent((Player)this, block, this.getItemInHand(), false);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public boolean simulateBlockDamage(Block block) {
        if (this.gamemode == GameMode.SURVIVAL) {
            BlockDamageEvent event = this.simulateBlockDamagePure(block);
            if (event.getInstaBreak()) {
                BlockBreakEvent breakEvent = new BlockBreakEvent(block, (Player)this);
                Bukkit.getPluginManager().callEvent((Event)breakEvent);
                if (!breakEvent.isCancelled()) {
                    block.setType(Material.AIR);
                }
            }
            return !event.isCancelled();
        }
        return false;
    }

    public boolean simulateBlockBreak(Block block) {
        if (this.gamemode == GameMode.SPECTATOR || this.gamemode == GameMode.ADVENTURE || this.gamemode == GameMode.SURVIVAL && this.simulateBlockDamagePure(block).isCancelled()) {
            return false;
        }
        BlockBreakEvent event = new BlockBreakEvent(block, (Player)this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.setType(Material.AIR);
        }
        return !event.isCancelled();
    }

    public void respawn() {
        boolean isBedSpawn;
        Location respawnLocation = this.getBedSpawnLocation();
        boolean bl = isBedSpawn = respawnLocation != null;
        if (!isBedSpawn) {
            respawnLocation = this.getLocation().getWorld().getSpawnLocation();
        }
        PlayerRespawnEvent event = new PlayerRespawnEvent((Player)this, respawnLocation, isBedSpawn);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.setHealth(this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        this.setLocation(event.getRespawnLocation().clone());
        this.alive = true;
    }

    public PlayerInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = (PlayerInventoryMock)Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.PLAYER);
        }
        return this.inventory;
    }

    public GameMode getGameMode() {
        return this.gamemode;
    }

    public void setGameMode(GameMode mode) {
        this.gamemode = mode;
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public void setWhitelisted(boolean value) {
        this.whitelisted = value;
    }

    public Player getPlayer() {
        if (this.online) {
            return this;
        }
        return null;
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isBanned() {
        return MockBukkit.getMock().getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    public InventoryView getOpenInventory() {
        return this.inventoryView;
    }

    public void openInventory(InventoryView inventory) {
        this.closeInventory();
        this.inventoryView = inventory;
    }

    public InventoryView openInventory(Inventory inventory) {
        this.closeInventory();
        this.inventoryView = new PlayerInventoryViewMock((HumanEntity)this, inventory);
        return this.inventoryView;
    }

    public void closeInventory() {
        if (this.inventoryView instanceof PlayerInventoryViewMock) {
            InventoryCloseEvent event = new InventoryCloseEvent(this.inventoryView);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        this.cursor = null;
        this.inventoryView = new SimpleInventoryViewMock((HumanEntity)this, null, this.inventory, InventoryType.CRAFTING);
    }

    public void assertInventoryView(String message, InventoryType type, Predicate<Inventory> predicate) {
        InventoryView view = this.getOpenInventory();
        if (view.getType() == type && predicate.test(view.getTopInventory())) {
            return;
        }
        Assert.fail((String)message);
    }

    public void assertInventoryView(InventoryType type, Predicate<Inventory> predicate) {
        this.assertInventoryView("The InventoryView Assertion has failed", type, predicate);
    }

    public void assertInventoryView(InventoryType type) {
        this.assertInventoryView("The InventoryView Assertion has failed", type, inv -> true);
    }

    public void assertInventoryView(String message, InventoryType type) {
        this.assertInventoryView(message, type, inv -> true);
    }

    public boolean performCommand(String command) {
        return Bukkit.dispatchCommand((CommandSender)this, (String)command);
    }

    public Inventory getEnderChest() {
        if (this.enderChest == null) {
            this.enderChest = new EnderChestInventoryMock((InventoryHolder)this);
        }
        return this.enderChest;
    }

    public MainHand getMainHand() {
        throw new UnimplementedOperationException();
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openMerchant(Villager trader, boolean force) {
        return this.openMerchant((Merchant)trader, force);
    }

    public InventoryView openMerchant(Merchant merchant, boolean force) {
        throw new UnimplementedOperationException();
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInMainHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInMainHand(item);
    }

    public ItemStack getItemOnCursor() {
        return this.cursor == null ? null : this.cursor.clone();
    }

    public void setItemOnCursor(ItemStack item) {
        this.cursor = item == null ? null : item.clone();
    }

    public boolean hasCooldown(Material material) {
        throw new UnimplementedOperationException();
    }

    public int getCooldown(Material material) {
        throw new UnimplementedOperationException();
    }

    public void setCooldown(Material material, int ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean isSleeping() {
        throw new UnimplementedOperationException();
    }

    public int getSleepTicks() {
        throw new UnimplementedOperationException();
    }

    public boolean isBlocking() {
        throw new UnimplementedOperationException();
    }

    public boolean isHandRaised() {
        throw new UnimplementedOperationException();
    }

    public int getExpToLevel() {
        if (this.expLevel >= 31) {
            return 9 * this.expLevel - 158;
        }
        if (this.expLevel >= 16) {
            return 5 * this.expLevel - 38;
        }
        return 2 * this.expLevel + 7;
    }

    public Entity getShoulderEntityLeft() {
        throw new UnimplementedOperationException();
    }

    public void setShoulderEntityLeft(Entity entity) {
        throw new UnimplementedOperationException();
    }

    public Entity getShoulderEntityRight() {
        throw new UnimplementedOperationException();
    }

    public void setShoulderEntityRight(Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (this.isSneaking() && !ignorePose) {
            return 1.54;
        }
        return 1.62;
    }

    @Override
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaximumNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getLastDamage() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setLastDamage(double damage) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Player getKiller() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasLineOfSight(Entity other) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return false;
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
    }

    @Override
    public EntityEquipment getEquipment() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getCanPickupItems() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isLeashed() {
        return false;
    }

    @Override
    public Entity getLeashHolder() {
        throw new IllegalStateException("Players cannot be leashed");
    }

    @Override
    public boolean setLeashHolder(Entity holder) {
        return false;
    }

    @Override
    public boolean isGliding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setGliding(boolean gliding) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAI(boolean ai) {
    }

    @Override
    public boolean hasAI() {
        return false;
    }

    @Override
    public void setCollidable(boolean collidable) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isCollidable() {
        throw new UnimplementedOperationException();
    }

    public boolean isConversing() {
        throw new UnimplementedOperationException();
    }

    public void acceptConversationInput(String input) {
        throw new UnimplementedOperationException();
    }

    public boolean beginConversation(Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        throw new UnimplementedOperationException();
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.firstPlayed > 0L;
    }

    public void setLastPlayed(long time) {
        if (time > 0L) {
            this.lastPlayed = time;
            if (this.firstPlayed == 0L) {
                this.firstPlayed = time;
            }
        }
    }

    public Map<String, Object> serialize() {
        throw new UnimplementedOperationException();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        throw new UnimplementedOperationException();
    }

    public Set<String> getListeningPluginChannels() {
        throw new UnimplementedOperationException();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getPlayerListName() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerListName(String name) {
        throw new UnimplementedOperationException();
    }

    public void setCompassTarget(@NotNull Location loc) {
        this.compassTarget = loc;
    }

    @NotNull
    public Location getCompassTarget() {
        return this.compassTarget;
    }

    public InetSocketAddress getAddress() {
        throw new UnimplementedOperationException();
    }

    public void sendRawMessage(String message) {
        throw new UnimplementedOperationException();
    }

    public void kickPlayer(String message) {
        throw new UnimplementedOperationException();
    }

    public void chat(String msg) {
        AsyncPlayerChatEvent eventAsync = new AsyncPlayerChatEvent(false, (Player)this, msg, new HashSet(Bukkit.getOnlinePlayers()));
        PlayerChatEvent eventSync = new PlayerChatEvent((Player)this, msg);
        MockBukkit.getMock().getScheduler().runTaskAsynchronously(null, () -> Bukkit.getPluginManager().callEvent((Event)eventAsync));
        Bukkit.getPluginManager().callEvent((Event)eventSync);
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    public boolean isSprinting() {
        throw new UnimplementedOperationException();
    }

    public void setSprinting(boolean sprinting) {
        throw new UnimplementedOperationException();
    }

    public void saveData() {
        throw new UnimplementedOperationException();
    }

    public void loadData() {
        throw new UnimplementedOperationException();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        throw new UnimplementedOperationException();
    }

    public boolean isSleepingIgnored() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void playNote(Location loc, byte instrument, byte note) {
        throw new UnimplementedOperationException();
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        throw new UnimplementedOperationException();
    }

    public void playSound(Location location, String sound, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    public void playSound(Location location, Sound sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location location, String sound, SoundCategory category, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    public void playSound(Location location, Sound sound, SoundCategory category, float volume, float pitch) {
        this.heardSounds.add(new AudioExperience(sound, category, location, volume, pitch));
    }

    public void assertSoundHeard(String message, Sound sound) {
        this.assertSoundHeard(message, sound, e -> true);
    }

    public void assertSoundHeard(String message, Sound sound, Predicate<AudioExperience> predicate) {
        for (AudioExperience audio : this.heardSounds) {
            if (audio.getSound() != sound || !predicate.test(audio)) continue;
            return;
        }
        Assert.fail((String)message);
    }

    public void assertSoundHeard(Sound sound) {
        this.assertSoundHeard("Sound Heard Assertion failed", sound);
    }

    public void assertSoundHeard(Sound sound, Predicate<AudioExperience> predicate) {
        this.assertSoundHeard("Sound Heard Assertion failed", sound, predicate);
    }

    public void stopSound(Sound sound) {
        this.stopSound(sound, SoundCategory.MASTER);
    }

    public void stopSound(String sound) {
        throw new UnimplementedOperationException();
    }

    public void stopSound(Sound sound, SoundCategory category) {
    }

    public void stopSound(String sound, SoundCategory category) {
        throw new UnimplementedOperationException();
    }

    public void playEffect(Location loc, Effect effect, int data) {
        throw new UnimplementedOperationException();
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        throw new UnimplementedOperationException();
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        throw new UnimplementedOperationException();
    }

    public boolean sendChunkChange(Location loc, int sx, int sy, int sz, byte[] data) {
        throw new UnimplementedOperationException();
    }

    public void sendSignChange(Location loc, String[] lines) {
        throw new UnimplementedOperationException();
    }

    public void sendMap(MapView map) {
        throw new UnimplementedOperationException();
    }

    public void updateInventory() {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        throw new UnimplementedOperationException();
    }

    public void setStatistic(Statistic statistic, int newValue) {
        throw new UnimplementedOperationException();
    }

    public int getStatistic(Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        throw new UnimplementedOperationException();
    }

    public int getStatistic(Statistic statistic, Material material) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        throw new UnimplementedOperationException();
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        throw new UnimplementedOperationException();
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        throw new UnimplementedOperationException();
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        throw new UnimplementedOperationException();
    }

    public void setPlayerTime(long time, boolean relative) {
        throw new UnimplementedOperationException();
    }

    public long getPlayerTime() {
        throw new UnimplementedOperationException();
    }

    public long getPlayerTimeOffset() {
        throw new UnimplementedOperationException();
    }

    public boolean isPlayerTimeRelative() {
        throw new UnimplementedOperationException();
    }

    public void resetPlayerTime() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerWeather(WeatherType type) {
        throw new UnimplementedOperationException();
    }

    public WeatherType getPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    public void resetPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    public void giveExp(int amount) {
        this.exp += (float)amount / (float)this.getExpToLevel();
        this.setTotalExperience(this.expTotal + amount);
        while (this.exp < 0.0f) {
            float total = this.exp * (float)this.getExpToLevel();
            boolean shouldContinue = this.expLevel > 0;
            this.giveExpLevels(-1);
            if (!shouldContinue) continue;
            this.exp = 1.0f + total / (float)this.getExpToLevel();
        }
        while (this.exp >= 1.0f) {
            this.exp = (this.exp - 1.0f) * (float)this.getExpToLevel();
            this.giveExpLevels(1);
            this.exp /= (float)this.getExpToLevel();
        }
    }

    public void giveExpLevels(int amount) {
        int oldLevel = this.expLevel;
        this.expLevel += amount;
        if (this.expLevel < 0) {
            this.expLevel = 0;
            this.exp = 0.0f;
        }
        if (oldLevel != this.expLevel) {
            PlayerLevelChangeEvent event = new PlayerLevelChangeEvent((Player)this, oldLevel, this.expLevel);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    public float getExp() {
        return this.exp;
    }

    public void setExp(float exp) {
        if ((double)exp < 0.0 || (double)exp > 1.0) {
            throw new IllegalArgumentException("Experience progress must be between 0.0 and 1.0");
        }
        this.exp = exp;
    }

    public int getLevel() {
        return this.expLevel;
    }

    public void setLevel(int level) {
        this.expLevel = level;
    }

    public int getTotalExperience() {
        return this.expTotal;
    }

    public void setTotalExperience(int exp) {
        this.expTotal = Math.max(0, exp);
    }

    public float getExhaustion() {
        throw new UnimplementedOperationException();
    }

    public void setExhaustion(float value) {
        throw new UnimplementedOperationException();
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float value) {
        this.saturation = Math.min((float)this.getFoodLevel(), value);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    @Nullable
    public Location getBedSpawnLocation() {
        return this.bedSpawnLocation;
    }

    public void setBedSpawnLocation(@Nullable Location loc) {
        this.setBedSpawnLocation(loc, false);
    }

    public void setBedSpawnLocation(@Nullable Location loc, boolean force) {
        if (force || loc == null || loc.getBlock().getType().name().endsWith("_BED")) {
            this.bedSpawnLocation = loc;
        }
    }

    public boolean getAllowFlight() {
        throw new UnimplementedOperationException();
    }

    public void setAllowFlight(boolean flight) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void hidePlayer(Player player) {
        throw new UnimplementedOperationException();
    }

    public void hidePlayer(Plugin plugin, Player player) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showPlayer(Player player) {
        throw new UnimplementedOperationException();
    }

    public void showPlayer(Plugin plugin, Player player) {
        throw new UnimplementedOperationException();
    }

    public boolean canSee(Player player) {
        throw new UnimplementedOperationException();
    }

    public boolean isFlying() {
        throw new UnimplementedOperationException();
    }

    public void setFlying(boolean value) {
        throw new UnimplementedOperationException();
    }

    public void setFlySpeed(float value) {
        throw new UnimplementedOperationException();
    }

    public void setWalkSpeed(float value) {
        throw new UnimplementedOperationException();
    }

    public float getFlySpeed() {
        throw new UnimplementedOperationException();
    }

    public float getWalkSpeed() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTexturePack(String url) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(String url) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(String url, byte[] hash) {
        throw new UnimplementedOperationException();
    }

    public Scoreboard getScoreboard() {
        throw new UnimplementedOperationException();
    }

    public void setScoreboard(Scoreboard scoreboard) {
        throw new UnimplementedOperationException();
    }

    public boolean isHealthScaled() {
        throw new UnimplementedOperationException();
    }

    public void setHealthScaled(boolean scale) {
        throw new UnimplementedOperationException();
    }

    public void setHealthScale(double scale) {
        throw new UnimplementedOperationException();
    }

    public double getHealthScale() {
        throw new UnimplementedOperationException();
    }

    public Entity getSpectatorTarget() {
        throw new UnimplementedOperationException();
    }

    public void setSpectatorTarget(Entity entity) {
        throw new UnimplementedOperationException();
    }

    public void sendTitle(String title, String subtitle) {
        throw new UnimplementedOperationException();
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        throw new UnimplementedOperationException();
    }

    public void resetTitle() {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    public AdvancementProgress getAdvancementProgress(Advancement advancement) {
        throw new UnimplementedOperationException();
    }

    public String getLocale() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSwimming() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSwimming(boolean swimming) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isRiptiding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPersistent() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPersistent(boolean persistent) {
        throw new UnimplementedOperationException();
    }

    public String getPlayerListHeader() {
        throw new UnimplementedOperationException();
    }

    public String getPlayerListFooter() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerListHeader(String header) {
        throw new UnimplementedOperationException();
    }

    public void setPlayerListFooter(String footer) {
        throw new UnimplementedOperationException();
    }

    public void setPlayerListHeaderFooter(String header, String footer) {
        throw new UnimplementedOperationException();
    }

    public void sendBlockChange(Location loc, BlockData block) {
        throw new UnimplementedOperationException();
    }

    public void updateCommands() {
        throw new UnimplementedOperationException();
    }

    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockFace getFacing() {
        throw new UnimplementedOperationException();
    }

    public int getClientViewDistance() {
        throw new UnimplementedOperationException();
    }

    public boolean sleep(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public void wakeup(boolean setSpawnLocation) {
        throw new UnimplementedOperationException();
    }

    public Location getBedLocation() {
        throw new UnimplementedOperationException();
    }

    public <T> T getMemory(MemoryKey<T> memoryKey) {
        throw new UnimplementedOperationException();
    }

    public <T> void setMemory(MemoryKey<T> memoryKey, T memoryValue) {
        throw new UnimplementedOperationException();
    }

    public double getAbsorptionAmount() {
        throw new UnimplementedOperationException();
    }

    public void setAbsorptionAmount(double amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Pose getPose() {
        throw new UnimplementedOperationException();
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void openBook(ItemStack book) {
        throw new UnimplementedOperationException();
    }

    public void attack(Entity target) {
        throw new UnimplementedOperationException();
    }

    public void swingMainHand() {
        throw new UnimplementedOperationException();
    }

    public void swingOffHand() {
        throw new UnimplementedOperationException();
    }

    public void sendExperienceChange(float progress) {
        throw new UnimplementedOperationException();
    }

    public void sendExperienceChange(float progress, int level) {
        throw new UnimplementedOperationException();
    }

    public float getAttackCooldown() {
        throw new UnimplementedOperationException();
    }

    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        throw new UnimplementedOperationException();
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        throw new UnimplementedOperationException();
    }

    public boolean dropItem(boolean dropAll) {
        throw new UnimplementedOperationException();
    }

    public Set<UUID> getCollidableExemptions() {
        throw new UnimplementedOperationException();
    }

    public Player.Spigot spigot() {
        throw new UnimplementedOperationException();
    }
}

