/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class InventoryMock
implements Inventory {
    private final ItemStack[] items;
    private final InventoryHolder holder;
    private final InventoryType type;

    public InventoryMock(InventoryHolder holder, int size, InventoryType type) {
        Validate.isTrue((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)("Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got " + size + ")"));
        this.holder = holder;
        this.type = type;
        this.items = new ItemStack[size];
    }

    public InventoryMock(InventoryHolder holder, InventoryType type) {
        this.holder = holder;
        this.type = type;
        this.items = new ItemStack[type.getDefaultSize()];
    }

    public void assertTrueForAll(Predicate<ItemStack> condition) {
        for (ItemStack item : this.items) {
            Assert.assertTrue((boolean)condition.test(item));
        }
    }

    public void assertTrueForNonNulls(Predicate<ItemStack> condition) {
        this.assertTrueForAll(itemstack -> itemstack == null || condition.test((ItemStack)itemstack));
    }

    public void assertTrueForSome(Predicate<ItemStack> condition) {
        for (ItemStack item : this.items) {
            if (item == null || !condition.test(item)) continue;
            return;
        }
        Assert.fail((String)"Condition was not met for any items");
    }

    public void assertContainsAny(ItemStack item) {
        this.assertTrueForSome(arg_0 -> ((ItemStack)item).isSimilar(arg_0));
    }

    public void assertContainsAtLeast(ItemStack item, int amount) {
        int n = this.getNumberOfItems(item);
        String message = String.format("Inventory contains only <%d> but expected at least <%d>", n, amount);
        Assert.assertTrue((String)message, (n >= amount ? 1 : 0) != 0);
    }

    public int getNumberOfItems(ItemStack item) {
        int amount = 0;
        for (ItemStack itemstack : this.items) {
            if (itemstack == null || !item.isSimilar(itemstack)) continue;
            amount += itemstack.getAmount();
        }
        return amount;
    }

    public int getSize() {
        return this.items.length;
    }

    public ItemStack getItem(int index) {
        return this.items[index];
    }

    public void setItem(int index, ItemStack item) {
        this.items[index] = item == null ? null : item.clone();
    }

    public ItemStack addItem(ItemStack item) {
        item = item.clone();
        for (int i = 0; i < this.items.length; ++i) {
            int toAdd;
            ItemStack oItem = this.items[i];
            if (oItem == null) {
                toAdd = Math.min(item.getAmount(), item.getMaxStackSize());
                this.items[i] = item.clone();
                this.items[i].setAmount(toAdd);
                item.setAmount(item.getAmount() - toAdd);
            } else if (item.isSimilar(oItem) && oItem.getAmount() < oItem.getMaxStackSize()) {
                toAdd = Math.min(item.getAmount(), item.getMaxStackSize() - oItem.getAmount());
                oItem.setAmount(oItem.getAmount() + toAdd);
                item.setAmount(item.getAmount() - toAdd);
            }
            if (item.getAmount() != 0) continue;
            return null;
        }
        return item;
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) throws IllegalArgumentException {
        HashMap<Integer, ItemStack> notSaved = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            ItemStack left = this.addItem(item);
            if (left == null) continue;
            notSaved.put(i, left);
        }
        return notSaved;
    }

    public ItemStack[] getContents() {
        return this.items;
    }

    public void setContents(ItemStack[] items) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.items[i] = i < items.length && items[i] != null ? items[i].clone() : null;
        }
    }

    public InventoryHolder getHolder() {
        return this.holder;
    }

    public ListIterator<ItemStack> iterator() {
        List list = Arrays.asList(this.items).stream().filter(item -> item != null).collect(Collectors.toList());
        return list.listIterator();
    }

    public InventoryType getType() {
        return this.type;
    }

    public int getMaxStackSize() {
        throw new UnimplementedOperationException();
    }

    public void setMaxStackSize(int size) {
        throw new UnimplementedOperationException();
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public ItemStack[] getStorageContents() {
        return this.getContents();
    }

    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setContents(items);
    }

    public boolean contains(Material material) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public boolean contains(ItemStack item) {
        throw new UnimplementedOperationException();
    }

    public boolean contains(Material material, int amount) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public boolean contains(ItemStack item, int amount) {
        throw new UnimplementedOperationException();
    }

    public boolean containsAtLeast(ItemStack item, int amount) {
        throw new UnimplementedOperationException();
    }

    public HashMap<Integer, ? extends ItemStack> all(Material material) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public HashMap<Integer, ? extends ItemStack> all(ItemStack item) {
        throw new UnimplementedOperationException();
    }

    public int first(Material material) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public int first(ItemStack item) {
        throw new UnimplementedOperationException();
    }

    public int firstEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.items[i] != null && this.items[i].getType() != Material.AIR) continue;
            return i;
        }
        return -1;
    }

    public void remove(Material material) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void remove(ItemStack item) {
        throw new UnimplementedOperationException();
    }

    public void clear(int index) {
        this.items[index] = null;
    }

    public void clear() {
        Arrays.fill(this.items, null);
    }

    public List<HumanEntity> getViewers() {
        throw new UnimplementedOperationException();
    }

    public ListIterator<ItemStack> iterator(int index) {
        throw new UnimplementedOperationException();
    }

    public Location getLocation() {
        throw new UnimplementedOperationException();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.items[i] == null || this.items[i].getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Inventory getSnapshot() {
        InventoryMock inventory = new InventoryMock(this.holder, this.getSize(), this.type);
        inventory.setContents(this.getContents());
        return inventory;
    }
}

