/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.meta.BookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.EnchantedBookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.FireworkEffectMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.FireworkMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.KnowledgeBookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.LeatherArmorMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.PotionMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.SkullMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.SuspiciousStewMetaMock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemFactoryMock
implements ItemFactory {
    private final Color defaultLeatherColor = Color.fromRGB((int)10511680);

    private Class<? extends ItemMeta> getItemMetaClass(Material material) {
        switch (material) {
            case WRITABLE_BOOK: 
            case WRITTEN_BOOK: {
                return BookMetaMock.class;
            }
            case ENCHANTED_BOOK: {
                return EnchantedBookMetaMock.class;
            }
            case KNOWLEDGE_BOOK: {
                return KnowledgeBookMetaMock.class;
            }
            case LEATHER_BOOTS: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_HELMET: 
            case LEATHER_LEGGINGS: {
                return LeatherArmorMetaMock.class;
            }
            case MAP: {
                throw new UnimplementedOperationException();
            }
            case FIREWORK_STAR: {
                return FireworkEffectMetaMock.class;
            }
            case FIREWORK_ROCKET: {
                return FireworkMetaMock.class;
            }
            case POTION: 
            case LINGERING_POTION: 
            case SPLASH_POTION: {
                return PotionMetaMock.class;
            }
            case PLAYER_HEAD: {
                return SkullMetaMock.class;
            }
            case SUSPICIOUS_STEW: {
                return SuspiciousStewMetaMock.class;
            }
            case TROPICAL_FISH_BUCKET: {
                throw new UnimplementedOperationException();
            }
        }
        return ItemMetaMock.class;
    }

    public ItemMeta getItemMeta(Material material) {
        try {
            return this.getItemMetaClass(material).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UnsupportedOperationException("Can't instantiate class");
        }
    }

    public boolean isApplicable(ItemMeta meta, ItemStack stack) {
        return this.isApplicable(meta, stack.getType());
    }

    public boolean isApplicable(ItemMeta meta, Material material) {
        Class<? extends ItemMeta> target = this.getItemMetaClass(material);
        return target.isInstance(meta);
    }

    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        if (meta1 != null && meta2 != null) {
            return meta1.equals(meta2);
        }
        return false;
    }

    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        return this.asMetaFor(meta, stack.getType());
    }

    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Class<? extends ItemMeta> target = this.getItemMetaClass(material);
        try {
            for (Constructor<?> constructor : target.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(meta.getClass())) continue;
                return (ItemMeta)constructor.newInstance(meta);
            }
            throw new NoSuchMethodException("Cannot find an ItemMeta constructor for the class \"" + meta.getClass().getName() + "\"");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Color getDefaultLeatherColor() {
        return this.defaultLeatherColor;
    }

    public Material updateMaterial(ItemMeta meta, Material material) {
        return material;
    }
}

