/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInventoryMock
extends InventoryMock
implements PlayerInventory {
    protected static final int HOTBAR = 0;
    protected static final int SLOT_BAR = 9;
    protected static final int BOOTS = 36;
    protected static final int LEGGINGS = 37;
    protected static final int CHESTPLATE = 38;
    protected static final int HELMET = 39;
    protected static final int OFF_HAND = 40;
    private int mainHandSlot = 0;

    public PlayerInventoryMock(HumanEntity holder) {
        super((InventoryHolder)holder, InventoryType.PLAYER);
    }

    public HumanEntity getHolder() {
        return (HumanEntity)super.getHolder();
    }

    @Override
    public ItemStack[] getStorageContents() {
        return Arrays.copyOfRange(this.getContents(), 0, 36);
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        throw new UnimplementedOperationException("setStorageContests has not been implemented for Player Inventories");
    }

    public ItemStack[] getArmorContents() {
        return Arrays.copyOfRange(this.getContents(), 36, 40);
    }

    public ItemStack[] getExtraContents() {
        return Arrays.copyOfRange(this.getContents(), 40, 41);
    }

    public ItemStack getHelmet() {
        return this.getItem(39);
    }

    public ItemStack getChestplate() {
        return this.getItem(38);
    }

    public ItemStack getLeggings() {
        return this.getItem(37);
    }

    public ItemStack getBoots() {
        return this.getItem(36);
    }

    public void setArmorContents(ItemStack[] items) {
        if (items == null) {
            throw new NullPointerException("ItemStack was null");
        }
        if (items.length > 4) {
            throw new IllegalArgumentException("ItemStack array too large (max: 4, was: " + items.length + ")");
        }
        items = items.length == 4 ? items : Arrays.copyOf(items, 4);
        this.setItem(36, items[0]);
        this.setItem(37, items[1]);
        this.setItem(38, items[2]);
        this.setItem(39, items[3]);
    }

    public void setExtraContents(ItemStack[] items) {
        if (items == null) {
            throw new NullPointerException("ItemStack was null");
        }
        if (items.length > 1) {
            throw new IllegalArgumentException("ItemStack array too large (max: 4, was: " + items.length + ")");
        }
        items = items.length == 1 ? items : Arrays.copyOf(items, 1);
        this.setItem(40, items[0]);
    }

    public void setHelmet(ItemStack helmet) {
        this.setItem(39, helmet);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setItem(38, chestplate);
    }

    public void setLeggings(ItemStack leggings) {
        this.setItem(37, leggings);
    }

    public void setBoots(ItemStack boots) {
        this.setItem(36, boots);
    }

    public ItemStack getItemInMainHand() {
        return this.getItem(9 + this.mainHandSlot);
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItem(9 + this.mainHandSlot, item);
    }

    public ItemStack getItemInOffHand() {
        return this.getItem(40);
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItem(40, item);
    }

    @Deprecated
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Deprecated
    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        switch (slot) {
            case CHEST: {
                return this.getChestplate();
            }
            case FEET: {
                return this.getBoots();
            }
            case HAND: {
                return this.getItemInMainHand();
            }
            case HEAD: {
                return this.getHelmet();
            }
            case LEGS: {
                return this.getLeggings();
            }
            case OFF_HAND: {
                return this.getItemInOffHand();
            }
        }
        return new ItemStack(Material.AIR);
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        switch (slot) {
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case HAND: {
                this.setItemInMainHand(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item);
                break;
            }
        }
    }

    public int getHeldItemSlot() {
        return this.mainHandSlot;
    }

    public void setHeldItemSlot(int slot) {
        if (slot < 0 || slot > 8) {
            throw new ArrayIndexOutOfBoundsException("Slot should be within [0-8] (was: " + slot + ")");
        }
        this.mainHandSlot = slot;
    }
}

