/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scheduler;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scheduler.AsyncTaskException;
import be.seeseemelk.mockbukkit.scheduler.RepeatingTask;
import be.seeseemelk.mockbukkit.scheduler.ScheduledTask;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;

public class BukkitSchedulerMock
implements BukkitScheduler {
    private static final String LOGGER_NAME = "BukkitSchedulerMock";
    private long currentTick = 0L;
    private int id = 0;
    private List<ScheduledTask> tasks = new LinkedList<ScheduledTask>();
    private ExecutorService pool = Executors.newCachedThreadPool();
    private AtomicInteger asyncTasksRunning = new AtomicInteger();
    private AtomicReference<Exception> asyncException = new AtomicReference();
    private int asyncTasksQueued = 0;

    public void shutdown() {
        this.waitAsyncTasksFinished();
        this.pool.shutdown();
        if (this.asyncException.get() != null) {
            throw new AsyncTaskException(this.asyncException.get());
        }
    }

    public long getCurrentTick() {
        return this.currentTick;
    }

    public void performOneTick() {
        ++this.currentTick;
        List<ScheduledTask> oldTasks = this.tasks;
        this.tasks = new LinkedList<ScheduledTask>();
        for (ScheduledTask task : oldTasks) {
            if (task.getScheduledTick() == this.currentTick && !task.isCancelled()) {
                if (task.isSync()) {
                    task.run();
                } else {
                    this.asyncTasksRunning.incrementAndGet();
                    this.pool.execute(task.getRunnable());
                    --this.asyncTasksQueued;
                }
                if (!(task instanceof RepeatingTask) || task.isCancelled()) continue;
                ((RepeatingTask)task).updateScheduledTick();
                this.tasks.add(task);
                continue;
            }
            if (task.isCancelled()) continue;
            this.tasks.add(task);
        }
    }

    public void performTicks(long ticks) {
        for (long i = 0L; i < ticks; ++i) {
            this.performOneTick();
        }
    }

    public void waitAsyncTasksFinished() {
        while (this.asyncTasksQueued > 0) {
            this.performOneTick();
        }
        while (this.asyncTasksRunning.get() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public BukkitTask runTask(Plugin plugin, Runnable task) {
        return this.runTaskLater(plugin, task, 1L);
    }

    public BukkitTask runTask(Plugin plugin, BukkitRunnable task) {
        return this.runTask(plugin, (Runnable)task);
    }

    public BukkitTask runTaskLater(Plugin plugin, Runnable task, long delay) {
        delay = Math.max(delay, 1L);
        ScheduledTask scheduledTask = new ScheduledTask(this.id++, plugin, true, this.currentTick + delay, task);
        this.tasks.add(scheduledTask);
        return scheduledTask;
    }

    public BukkitTask runTaskTimer(Plugin plugin, Runnable task, long delay, long period) {
        delay = Math.max(delay, 1L);
        RepeatingTask repeatingTask = new RepeatingTask(this.id++, plugin, true, this.currentTick + delay, period, task);
        this.tasks.add(repeatingTask);
        return repeatingTask;
    }

    public BukkitTask runTaskTimer(Plugin plugin, BukkitRunnable task, long delay, long period) {
        return this.runTaskTimer(plugin, (Runnable)task, delay, period);
    }

    public int scheduleSyncDelayedTask(Plugin plugin, Runnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLater instead of scheduleSyncDelayTask");
        return this.runTaskLater(plugin, task, delay).getTaskId();
    }

    public int scheduleSyncDelayedTask(Plugin plugin, BukkitRunnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLater instead of scheduleSyncDelayTask");
        return this.runTaskLater(plugin, (Runnable)task, delay).getTaskId();
    }

    public int scheduleSyncDelayedTask(Plugin plugin, Runnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTask instead of scheduleSyncDelayTask");
        return this.runTask(plugin, task).getTaskId();
    }

    public int scheduleSyncDelayedTask(Plugin plugin, BukkitRunnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTask instead of scheduleSyncDelayTask");
        return this.runTask(plugin, (Runnable)task).getTaskId();
    }

    public int scheduleSyncRepeatingTask(Plugin plugin, Runnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimer instead of scheduleSyncRepeatingTask");
        return this.runTaskTimer(plugin, task, delay, period).getTaskId();
    }

    public int scheduleSyncRepeatingTask(Plugin plugin, BukkitRunnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimer instead of scheduleSyncRepeatingTask");
        return this.runTaskTimer(plugin, (Runnable)task, delay, period).getTaskId();
    }

    public int scheduleAsyncDelayedTask(Plugin plugin, Runnable task, long delay) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskLaterAsynchronously instead of scheduleAsyncDelayedTask");
        return this.runTaskLaterAsynchronously(plugin, task, delay).getTaskId();
    }

    public int scheduleAsyncDelayedTask(Plugin plugin, Runnable task) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskAsynchronously instead of scheduleAsyncDelayedTask");
        return this.runTaskAsynchronously(plugin, task).getTaskId();
    }

    public int scheduleAsyncRepeatingTask(Plugin plugin, Runnable task, long delay, long period) {
        Logger.getLogger(LOGGER_NAME).warning("Consider using runTaskTimerAsynchronously instead of scheduleAsyncRepeatingTask");
        return this.runTaskTimerAsynchronously(plugin, task, delay, period).getTaskId();
    }

    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task) {
        throw new UnimplementedOperationException();
    }

    public void cancelTask(int taskId) {
        for (ScheduledTask task : this.tasks) {
            if (task.getTaskId() != taskId) continue;
            task.cancel();
            return;
        }
    }

    public void cancelTasks(Plugin plugin) {
        for (ScheduledTask task : this.tasks) {
            if (!task.getOwner().equals(plugin)) continue;
            task.cancel();
        }
    }

    public boolean isCurrentlyRunning(int taskId) {
        throw new UnimplementedOperationException();
    }

    public boolean isQueued(int taskId) {
        for (ScheduledTask task : this.tasks) {
            if (task.getTaskId() != taskId) continue;
            return !task.isCancelled();
        }
        return false;
    }

    public List<BukkitWorker> getActiveWorkers() {
        throw new UnimplementedOperationException();
    }

    public List<BukkitTask> getPendingTasks() {
        throw new UnimplementedOperationException();
    }

    public BukkitTask runTaskAsynchronously(Plugin plugin, Runnable task) {
        ScheduledTask scheduledTask = new ScheduledTask(this.id++, plugin, false, this.currentTick, new AsyncRunnable(task));
        this.asyncTasksRunning.incrementAndGet();
        this.pool.execute(scheduledTask.getRunnable());
        return scheduledTask;
    }

    public BukkitTask runTaskAsynchronously(Plugin plugin, BukkitRunnable task) {
        return this.runTaskAsynchronously(plugin, (Runnable)task);
    }

    public BukkitTask runTaskLater(Plugin plugin, BukkitRunnable task, long delay) {
        return this.runTaskLater(plugin, (Runnable)task, delay);
    }

    public BukkitTask runTaskLaterAsynchronously(Plugin plugin, Runnable task, long delay) {
        ScheduledTask scheduledTask = new ScheduledTask(this.id++, plugin, false, this.currentTick + delay, new AsyncRunnable(task));
        this.tasks.add(scheduledTask);
        ++this.asyncTasksQueued;
        return scheduledTask;
    }

    public BukkitTask runTaskLaterAsynchronously(Plugin plugin, BukkitRunnable task, long delay) {
        return this.runTaskLaterAsynchronously(plugin, (Runnable)task, delay);
    }

    public BukkitTask runTaskTimerAsynchronously(Plugin plugin, Runnable task, long delay, long period) {
        RepeatingTask scheduledTask = new RepeatingTask(this.id++, plugin, false, this.currentTick + delay, period, new AsyncRunnable(task));
        this.tasks.add(scheduledTask);
        return scheduledTask;
    }

    public BukkitTask runTaskTimerAsynchronously(Plugin plugin, BukkitRunnable task, long delay, long period) {
        return this.runTaskTimerAsynchronously(plugin, (Runnable)task, delay, period);
    }

    public void runTask(Plugin plugin, Consumer<BukkitTask> task) {
        throw new UnimplementedOperationException();
    }

    public void runTaskAsynchronously(Plugin plugin, Consumer<BukkitTask> task) {
        throw new UnimplementedOperationException();
    }

    public void runTaskLater(Plugin plugin, Consumer<BukkitTask> task, long delay) {
        throw new UnimplementedOperationException();
    }

    public void runTaskLaterAsynchronously(Plugin plugin, Consumer<BukkitTask> task, long delay) {
        throw new UnimplementedOperationException();
    }

    public void runTaskTimer(Plugin plugin, Consumer<BukkitTask> task, long delay, long period) {
        throw new UnimplementedOperationException();
    }

    public void runTaskTimerAsynchronously(Plugin plugin, Consumer<BukkitTask> task, long delay, long period) {
        throw new UnimplementedOperationException();
    }

    class AsyncRunnable
    implements Runnable {
        private final Runnable task;

        private AsyncRunnable(Runnable runnable) {
            this.task = runnable;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Exception t) {
                BukkitSchedulerMock.this.asyncException.set(t);
            }
            BukkitSchedulerMock.this.asyncTasksRunning.decrementAndGet();
        }
    }
}

