/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scoreboard.ScoreMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardMock;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;

public class ObjectiveMock
implements Objective {
    private final ScoreboardMock scoreboard;
    private final String name;
    private final String criteria;
    private final Map<String, ScoreMock> scores = new HashMap<String, ScoreMock>();
    private String displayName;
    private DisplaySlot displaySlot;
    private RenderType renderType;

    public ObjectiveMock(ScoreboardMock scoreboard, String name, String criteria) {
        this.scoreboard = scoreboard;
        this.name = name;
        this.displayName = name;
        this.criteria = criteria;
    }

    public String getName() throws IllegalStateException {
        return this.name;
    }

    public String getDisplayName() throws IllegalStateException {
        return this.displayName;
    }

    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        this.displayName = displayName;
    }

    public String getCriteria() throws IllegalStateException {
        return this.criteria;
    }

    public boolean isModifiable() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }

    public ScoreboardMock getScoreboard() {
        return this.scoreboard;
    }

    public void unregister() throws IllegalStateException {
        this.scoreboard.unregister(this);
    }

    public boolean isRegistered() {
        return this.scoreboard.getObjectives().contains(this);
    }

    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        this.displaySlot = slot;
        this.scoreboard.setDisplaySlot(this, slot);
    }

    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        return this.displaySlot;
    }

    public ScoreMock getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        return this.getScore(player.getName());
    }

    public ScoreMock getScore(String entry) throws IllegalArgumentException, IllegalStateException {
        if (this.scores.containsKey(entry)) {
            return this.scores.get(entry);
        }
        ScoreMock score = new ScoreMock(this, entry);
        this.scores.put(entry, score);
        return score;
    }

    public void setRenderType(RenderType renderType) throws IllegalStateException {
        this.renderType = renderType;
    }

    public RenderType getRenderType() throws IllegalStateException {
        return this.renderType;
    }
}

