/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scoreboard.ObjectiveMock;
import be.seeseemelk.mockbukkit.scoreboard.TeamMock;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardMock
implements Scoreboard {
    private Map<String, ObjectiveMock> objectives = new HashMap<String, ObjectiveMock>();
    private Map<DisplaySlot, ObjectiveMock> objectivesByDisplaySlot = new EnumMap<DisplaySlot, ObjectiveMock>(DisplaySlot.class);
    private Map<String, Team> teams = new HashMap<String, Team>();

    public ObjectiveMock registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        ObjectiveMock objective = new ObjectiveMock(this, name, criteria);
        this.objectives.put(name, objective);
        return objective;
    }

    public ObjectiveMock getObjective(String name) throws IllegalArgumentException {
        return this.objectives.get(name);
    }

    public Set<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        return this.objectives.values().stream().filter(objective -> objective.getCriteria().equals(criteria)).collect(Collectors.toSet());
    }

    public Set<Objective> getObjectives() {
        return Collections.unmodifiableSet(new HashSet<ObjectiveMock>(this.objectives.values()));
    }

    public ObjectiveMock getObjective(DisplaySlot slot) throws IllegalArgumentException {
        return this.objectivesByDisplaySlot.get(slot);
    }

    public Set<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        return this.getScores(player.getName());
    }

    public Set<Score> getScores(String entry) throws IllegalArgumentException {
        HashSet<Score> scores = new HashSet<Score>();
        for (Objective objective : this.objectives.values()) {
            Score score = objective.getScore(entry);
            if (score == null) continue;
            scores.add(score);
        }
        return scores;
    }

    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        this.resetScores(player.getName());
    }

    public void resetScores(String entry) throws IllegalArgumentException {
        for (Objective objective : this.objectives.values()) {
            Score score = objective.getScore(entry);
            if (score == null) continue;
            score.setScore(0);
        }
    }

    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        return this.getEntryTeam(player.getName());
    }

    public Team getEntryTeam(String entry) throws IllegalArgumentException {
        for (Team t : this.teams.values()) {
            if (!t.hasEntry(entry)) continue;
            return t;
        }
        return null;
    }

    public Team getTeam(String teamName) throws IllegalArgumentException {
        return this.teams.get(teamName);
    }

    public Set<Team> getTeams() {
        HashSet<Team> v = new HashSet<Team>(this.teams.values());
        return v;
    }

    public Team registerNewTeam(String name) throws IllegalArgumentException {
        TeamMock team = new TeamMock(name, this);
        this.teams.put(name, team);
        return team;
    }

    public Set<OfflinePlayer> getPlayers() {
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (Team t : this.teams.values()) {
            players.addAll(t.getPlayers());
        }
        return players;
    }

    public Set<String> getEntries() {
        HashSet<String> entries = new HashSet<String>();
        for (Team t : this.teams.values()) {
            entries.addAll(t.getEntries());
        }
        return entries;
    }

    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        Objective o = this.objectivesByDisplaySlot.remove(slot);
        if (o != null) {
            this.objectives.remove(o.getName());
        }
    }

    protected void setDisplaySlot(ObjectiveMock objective, DisplaySlot slot) {
        this.objectivesByDisplaySlot.put(slot, objective);
    }

    protected void unregister(ObjectiveMock objectiveMock) {
        this.objectives.remove(objectiveMock.getName());
        if (objectiveMock.getDisplaySlot() != null) {
            this.objectivesByDisplaySlot.remove(objectiveMock.getDisplaySlot());
        }
    }

    public Objective registerNewObjective(String name, String criteria, String displayName) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public Objective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }
}

