/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.tags;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.tags.TagMisconfigurationException;
import be.seeseemelk.mockbukkit.tags.TagRegistry;
import be.seeseemelk.mockbukkit.tags.TagWrapperMock;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public class TagParser
implements Keyed {
    private static final Pattern COLON = Pattern.compile(":");
    private static final Pattern MINECRAFT_MATERIAL = Pattern.compile("minecraft:[a-z0-9_]+");
    private static final Pattern MINECRAFT_TAG = Pattern.compile("#minecraft:[a-z_]+");
    private final TagRegistry registry;
    private final NamespacedKey key;

    public TagParser(@NotNull TagRegistry registry, @NotNull NamespacedKey key) {
        this.registry = registry;
        this.key = key;
    }

    TagParser(@NotNull TagWrapperMock tag) {
        this.registry = tag.getRegistry();
        this.key = tag.getKey();
    }

    void parse(@NotNull BiConsumer<Set<Material>, Set<TagWrapperMock>> callback) throws TagMisconfigurationException {
        String path = "/tags/" + this.registry.getRegistry() + '/' + this.getKey().getKey() + ".json";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(MockBukkit.class.getResourceAsStream(path), StandardCharsets.UTF_8));){
            this.parse(reader.lines().collect(Collectors.joining("")), callback);
        }
        catch (IOException x) {
            throw new TagMisconfigurationException(this.key, x.getMessage());
        }
    }

    public void parse(@NotNull String json, @NotNull BiConsumer<Set<Material>, Set<TagWrapperMock>> callback) throws TagMisconfigurationException {
        Validate.notNull((Object)json, (String)"Cannot parse a null String");
        try {
            HashSet<Material> materials = new HashSet<Material>();
            HashSet<TagWrapperMock> tags = new HashSet<TagWrapperMock>();
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            JsonElement child = root.get("values");
            if (child instanceof JsonArray) {
                JsonArray values = child.getAsJsonArray();
                for (JsonElement element : values) {
                    if (element instanceof JsonPrimitive && ((JsonPrimitive)element).isString()) {
                        this.parsePrimitiveValue(element.getAsString(), materials, tags);
                        continue;
                    }
                    if (element instanceof JsonObject) {
                        this.parseComplexValue(element.getAsJsonObject(), materials, tags);
                        continue;
                    }
                    throw new TagMisconfigurationException(this.key, "Unexpected value format: " + element.getClass().getSimpleName() + " - " + element.toString());
                }
            } else {
                throw new TagMisconfigurationException(this.key, "No values array specified");
            }
            callback.accept(materials, tags);
        }
        catch (JsonParseException | IllegalStateException x) {
            throw new TagMisconfigurationException(this.key, x.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePrimitiveValue(@NotNull String value, @NotNull Set<Material> materials, @NotNull Set<TagWrapperMock> tags) throws TagMisconfigurationException {
        if (MINECRAFT_MATERIAL.matcher(value).matches()) {
            Material material = Material.matchMaterial((String)value);
            if (material == null) throw new TagMisconfigurationException(this.key, "Minecraft Material '" + value + "' seems to not exist!");
            materials.add(material);
            return;
        } else {
            if (!MINECRAFT_TAG.matcher(value).matches()) throw new TagMisconfigurationException(this.key, "Could not recognize value '" + value + "'");
            NamespacedKey tagKey = NamespacedKey.minecraft((String)COLON.split(value)[1]);
            TagWrapperMock tag = this.registry.getTags().get(tagKey);
            if (tag == null) throw new TagMisconfigurationException(this.key, "There is no '" + value + "' tag in Minecraft:" + this.registry.getRegistry());
            tags.add(tag);
        }
    }

    private void parseComplexValue(@NotNull JsonObject entry, @NotNull Set<Material> materials, @NotNull Set<TagWrapperMock> tags) throws TagMisconfigurationException {
        JsonElement id = entry.get("id");
        JsonElement required = entry.get("required");
        if (id instanceof JsonPrimitive && ((JsonPrimitive)id).isString() && required instanceof JsonPrimitive && ((JsonPrimitive)required).isBoolean()) {
            if (required.getAsBoolean()) {
                this.parsePrimitiveValue(id.getAsString(), materials, tags);
            } else {
                try {
                    this.parsePrimitiveValue(id.getAsString(), materials, tags);
                }
                catch (TagMisconfigurationException tagMisconfigurationException) {}
            }
        } else {
            throw new TagMisconfigurationException(this.key, "Found a JSON Object value without an id!");
        }
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }
}

