/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.LivingEntityMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryViewMock;
import be.seeseemelk.mockbukkit.inventory.SimpleInventoryViewMock;
import be.seeseemelk.mockbukkit.sound.AudioExperience;
import be.seeseemelk.mockbukkit.sound.SoundReceiver;
import be.seeseemelk.mockbukkit.statistic.StatisticsMock;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Villager;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public class PlayerMock
extends LivingEntityMock
implements Player,
SoundReceiver {
    private boolean online;
    private PlayerInventoryMock inventory = null;
    private EnderChestInventoryMock enderChest = null;
    private GameMode gamemode = GameMode.SURVIVAL;
    private String displayName = null;
    private String playerListName = null;
    private int expTotal = 0;
    private float exp = 0.0f;
    private int foodLevel = 20;
    private float saturation = 5.0f;
    private int expLevel = 0;
    private boolean sneaking = false;
    private boolean sprinting = false;
    private boolean flying = false;
    private boolean whitelisted = true;
    private InventoryView inventoryView;
    private Location compassTarget;
    private Location bedSpawnLocation;
    private ItemStack cursor = null;
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private final PlayerSpigotMock playerSpigotMock = new PlayerSpigotMock();
    private final List<AudioExperience> heardSounds = new LinkedList<AudioExperience>();
    private final Map<UUID, Set<Plugin>> hiddenPlayers = new HashMap<UUID, Set<Plugin>>();
    private final Set<UUID> hiddenPlayersDeprecated = new HashSet<UUID>();
    private final StatisticsMock statistics = new StatisticsMock();

    public PlayerMock(ServerMock server, String name) {
        this(server, name, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)));
        this.online = false;
    }

    public PlayerMock(ServerMock server, String name, UUID uuid) {
        super(server, uuid);
        this.setName(name);
        this.setDisplayName(name);
        this.online = true;
        if (Bukkit.getWorlds().isEmpty()) {
            MockBukkit.getMock().addSimpleWorld("world");
        }
        this.setLocation(((World)Bukkit.getWorlds().get(0)).getSpawnLocation().clone());
        this.setCompassTarget(this.getLocation());
        this.closeInventory();
    }

    @NotNull
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    public void assertGameMode(GameMode expectedGamemode) {
        Assertions.assertEquals((Object)expectedGamemode, (Object)this.gamemode);
    }

    protected BlockDamageEvent simulateBlockDamagePure(Block block) {
        BlockDamageEvent event = new BlockDamageEvent((Player)this, block, this.getItemInHand(), false);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Nullable
    public BlockDamageEvent simulateBlockDamage(Block block) {
        if (this.gamemode == GameMode.SURVIVAL) {
            BlockDamageEvent event = this.simulateBlockDamagePure(block);
            if (event.getInstaBreak()) {
                BlockBreakEvent breakEvent = new BlockBreakEvent(block, (Player)this);
                Bukkit.getPluginManager().callEvent((Event)breakEvent);
                if (!breakEvent.isCancelled()) {
                    block.setType(Material.AIR);
                }
            }
            return event;
        }
        return null;
    }

    @Nullable
    public BlockBreakEvent simulateBlockBreak(Block block) {
        if (this.gamemode == GameMode.SPECTATOR || this.gamemode == GameMode.ADVENTURE || this.gamemode == GameMode.SURVIVAL && this.simulateBlockDamagePure(block).isCancelled()) {
            return null;
        }
        BlockBreakEvent event = new BlockBreakEvent(block, (Player)this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.setType(Material.AIR);
        }
        return event;
    }

    @Nullable
    public BlockPlaceEvent simulateBlockPlace(Material material, Location location) {
        if (this.gamemode == GameMode.ADVENTURE || this.gamemode == GameMode.SPECTATOR) {
            return null;
        }
        Block block = location.getBlock();
        BlockPlaceEvent event = new BlockPlaceEvent(block, null, null, null, (Player)this, true, null);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.setType(material);
        }
        return event;
    }

    public void respawn() {
        Location respawnLocation = this.getBedSpawnLocation();
        boolean isBedSpawn = respawnLocation != null;
        boolean isAnchorSpawn = false;
        if (!isBedSpawn) {
            respawnLocation = this.getLocation().getWorld().getSpawnLocation();
        }
        PlayerRespawnEvent event = new PlayerRespawnEvent((Player)this, respawnLocation, isBedSpawn, isAnchorSpawn);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.setHealth(this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        this.setLocation(event.getRespawnLocation().clone());
        this.alive = true;
    }

    @NotNull
    public PlayerMoveEvent simulatePlayerMove(@NotNull Location moveLocation) {
        PlayerMoveEvent event = new PlayerMoveEvent((Player)this, this.getLocation(), moveLocation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.setLocation(event.getTo());
        }
        return event;
    }

    @NotNull
    public PlayerInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = (PlayerInventoryMock)Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.PLAYER);
        }
        return this.inventory;
    }

    @NotNull
    public GameMode getGameMode() {
        return this.gamemode;
    }

    public void setGameMode(@NotNull GameMode mode) {
        this.gamemode = mode;
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public void setWhitelisted(boolean value) {
        this.whitelisted = value;
    }

    public Player getPlayer() {
        if (this.online) {
            return this;
        }
        return null;
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isBanned() {
        return MockBukkit.getMock().getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @NotNull
    public InventoryView getOpenInventory() {
        return this.inventoryView;
    }

    public void openInventory(@NotNull InventoryView inventory) {
        this.closeInventory();
        this.inventoryView = inventory;
    }

    public InventoryView openInventory(@NotNull Inventory inventory) {
        this.closeInventory();
        this.inventoryView = new PlayerInventoryViewMock((HumanEntity)this, inventory);
        return this.inventoryView;
    }

    public void closeInventory() {
        if (this.inventoryView instanceof PlayerInventoryViewMock) {
            InventoryCloseEvent event = new InventoryCloseEvent(this.inventoryView);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        this.cursor = null;
        this.inventoryView = new SimpleInventoryViewMock((HumanEntity)this, null, this.inventory, InventoryType.CRAFTING);
    }

    public void assertInventoryView(String message, InventoryType type, Predicate<Inventory> predicate) {
        InventoryView view = this.getOpenInventory();
        if (view.getType() == type && predicate.test(view.getTopInventory())) {
            return;
        }
        Assertions.fail((String)message);
    }

    public void assertInventoryView(InventoryType type, Predicate<Inventory> predicate) {
        this.assertInventoryView("The InventoryView Assertion has failed", type, predicate);
    }

    public void assertInventoryView(InventoryType type) {
        this.assertInventoryView("The InventoryView Assertion has failed", type, inv -> true);
    }

    public void assertInventoryView(String message, InventoryType type) {
        this.assertInventoryView(message, type, inv -> true);
    }

    public boolean performCommand(@NotNull String command) {
        return Bukkit.dispatchCommand((CommandSender)this, (String)command);
    }

    @NotNull
    public Inventory getEnderChest() {
        if (this.enderChest == null) {
            this.enderChest = new EnderChestInventoryMock((InventoryHolder)this);
        }
        return this.enderChest;
    }

    @NotNull
    public MainHand getMainHand() {
        throw new UnimplementedOperationException();
    }

    public boolean setWindowProperty(@NotNull InventoryView.Property prop, int value) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openMerchant(@NotNull Villager trader, boolean force) {
        return this.openMerchant((Merchant)trader, force);
    }

    public InventoryView openMerchant(@NotNull Merchant merchant, boolean force) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInMainHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInMainHand(item);
    }

    @NotNull
    public ItemStack getItemOnCursor() {
        return this.cursor == null ? new ItemStack(Material.AIR, 0) : this.cursor.clone();
    }

    public void setItemOnCursor(ItemStack item) {
        this.cursor = item == null ? null : item.clone();
    }

    public boolean hasCooldown(@NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public int getCooldown(@NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public void setCooldown(@NotNull Material material, int ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean isSleeping() {
        throw new UnimplementedOperationException();
    }

    public int getSleepTicks() {
        throw new UnimplementedOperationException();
    }

    public boolean isBlocking() {
        throw new UnimplementedOperationException();
    }

    public boolean isHandRaised() {
        throw new UnimplementedOperationException();
    }

    public int getExpToLevel() {
        if (this.expLevel >= 31) {
            return 9 * this.expLevel - 158;
        }
        if (this.expLevel >= 16) {
            return 5 * this.expLevel - 38;
        }
        return 2 * this.expLevel + 7;
    }

    public Entity getShoulderEntityLeft() {
        throw new UnimplementedOperationException();
    }

    public void setShoulderEntityLeft(Entity entity) {
        throw new UnimplementedOperationException();
    }

    public Entity getShoulderEntityRight() {
        throw new UnimplementedOperationException();
    }

    public void setShoulderEntityRight(Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (this.isSneaking() && !ignorePose) {
            return 1.54;
        }
        return 1.62;
    }

    @Override
    @NotNull
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaximumNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getLastDamage() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setLastDamage(double damage) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Player getKiller() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasLineOfSight(@NotNull Entity other) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return false;
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
    }

    public EntityEquipment getEquipment() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getCanPickupItems() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isLeashed() {
        return false;
    }

    @Override
    @NotNull
    public Entity getLeashHolder() {
        throw new IllegalStateException("Players cannot be leashed");
    }

    @Override
    public boolean setLeashHolder(Entity holder) {
        return false;
    }

    @Override
    public boolean isGliding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setGliding(boolean gliding) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAI(boolean ai) {
    }

    @Override
    public boolean hasAI() {
        return false;
    }

    @Override
    public void setCollidable(boolean collidable) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isCollidable() {
        throw new UnimplementedOperationException();
    }

    public boolean isConversing() {
        throw new UnimplementedOperationException();
    }

    public void acceptConversationInput(@NotNull String input) {
        throw new UnimplementedOperationException();
    }

    public boolean beginConversation(@NotNull Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(@NotNull Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(@NotNull Conversation conversation, @NotNull ConversationAbandonedEvent details) {
        throw new UnimplementedOperationException();
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.firstPlayed > 0L;
    }

    public void setLastPlayed(long time) {
        if (time > 0L) {
            this.lastPlayed = time;
            if (this.firstPlayed == 0L) {
                this.firstPlayed = time;
            }
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        throw new UnimplementedOperationException();
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, byte[] message) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    @NotNull
    public String getPlayerListName() {
        return this.playerListName == null ? this.getName() : this.playerListName;
    }

    public void setPlayerListName(String name) {
        this.playerListName = name;
    }

    public void setCompassTarget(@NotNull Location loc) {
        this.compassTarget = loc;
    }

    @NotNull
    public Location getCompassTarget() {
        return this.compassTarget;
    }

    public InetSocketAddress getAddress() {
        throw new UnimplementedOperationException();
    }

    public void sendRawMessage(@Nullable String message) {
        throw new UnimplementedOperationException();
    }

    public void sendRawMessage(@Nullable UUID sender, @NotNull String message) {
        throw new UnimplementedOperationException();
    }

    public void kickPlayer(String message) {
        throw new UnimplementedOperationException();
    }

    public void chat(@NotNull String msg) {
        HashSet players = new HashSet(Bukkit.getOnlinePlayers());
        AsyncPlayerChatEvent asyncEvent = new AsyncPlayerChatEvent(true, (Player)this, msg, players);
        PlayerChatEvent syncEvent = new PlayerChatEvent((Player)this, msg);
        ServerMock server = MockBukkit.getMock();
        server.getPluginManager().callEventAsynchronously((Event)asyncEvent);
        server.getPluginManager().callEvent((Event)syncEvent);
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @NotNull
    public PlayerToggleSneakEvent simulateSneak(boolean sneak) {
        PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this, sneak);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.sneaking = event.isSneaking();
        }
        return event;
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    public void setSprinting(boolean sprinting) {
        this.sprinting = sprinting;
    }

    @NotNull
    public PlayerToggleSprintEvent simulateSprint(boolean sprint) {
        PlayerToggleSprintEvent event = new PlayerToggleSprintEvent((Player)this, sprint);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.sprinting = event.isSprinting();
        }
        return event;
    }

    public void saveData() {
        throw new UnimplementedOperationException();
    }

    public void loadData() {
        throw new UnimplementedOperationException();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        throw new UnimplementedOperationException();
    }

    public boolean isSleepingIgnored() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void playNote(@NotNull Location loc, byte instrument, byte note) {
        throw new UnimplementedOperationException();
    }

    public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
        throw new UnimplementedOperationException();
    }

    public void playSound(@NotNull Location location, @NotNull String sound, float volume, float pitch) {
        this.heardSounds.add(new AudioExperience(sound, SoundCategory.MASTER, location, volume, pitch));
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Location location, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch) {
        this.heardSounds.add(new AudioExperience(sound, category, location, volume, pitch));
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch) {
        this.heardSounds.add(new AudioExperience(sound, category, location, volume, pitch));
    }

    @Override
    @NotNull
    public List<AudioExperience> getHeardSounds() {
        return this.heardSounds;
    }

    public void stopSound(@NotNull Sound sound) {
        this.stopSound(sound, SoundCategory.MASTER);
    }

    public void stopSound(@NotNull String sound) {
        this.stopSound(sound, SoundCategory.MASTER);
    }

    public void stopSound(@NotNull Sound sound, SoundCategory category) {
    }

    public void stopSound(@NotNull String sound, SoundCategory category) {
    }

    public void playEffect(@NotNull Location loc, @NotNull Effect effect, int data) {
        throw new UnimplementedOperationException();
    }

    public <T> void playEffect(@NotNull Location loc, @NotNull Effect effect, T data) {
        throw new UnimplementedOperationException();
    }

    public void sendBlockChange(@NotNull Location loc, @NotNull Material material, byte data) {
        throw new UnimplementedOperationException();
    }

    public boolean sendChunkChange(@NotNull Location loc, int sx, int sy, int sz, byte[] data) {
        throw new UnimplementedOperationException();
    }

    public void sendSignChange(@NotNull Location loc, String[] lines) {
        throw new UnimplementedOperationException();
    }

    public void sendMap(@NotNull MapView map) {
        throw new UnimplementedOperationException();
    }

    public void updateInventory() {
        throw new UnimplementedOperationException();
    }

    public void incrementStatistic(@NotNull Statistic statistic) {
        this.statistics.incrementStatistic(statistic, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic) {
        this.statistics.decrementStatistic(statistic, 1);
    }

    public void incrementStatistic(@NotNull Statistic statistic, int amount) {
        this.statistics.incrementStatistic(statistic, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, int amount) {
        this.statistics.decrementStatistic(statistic, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, int newValue) {
        this.statistics.setStatistic(statistic, newValue);
    }

    public int getStatistic(@NotNull Statistic statistic) {
        return this.statistics.getStatistic(statistic);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        this.statistics.incrementStatistic(statistic, material, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        this.statistics.decrementStatistic(statistic, material, 1);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        return this.statistics.getStatistic(statistic, material);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        this.statistics.incrementStatistic(statistic, material, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        this.statistics.decrementStatistic(statistic, material, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull Material material, int newValue) {
        this.statistics.setStatistic(statistic, material, newValue);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        this.statistics.incrementStatistic(statistic, entityType, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        this.statistics.decrementStatistic(statistic, entityType, 1);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        return this.statistics.getStatistic(statistic, entityType);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int amount) {
        this.statistics.incrementStatistic(statistic, entityType, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int amount) {
        this.statistics.decrementStatistic(statistic, entityType, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int newValue) {
        this.statistics.setStatistic(statistic, entityType, newValue);
    }

    public void setPlayerTime(long time, boolean relative) {
        throw new UnimplementedOperationException();
    }

    public long getPlayerTime() {
        throw new UnimplementedOperationException();
    }

    public long getPlayerTimeOffset() {
        throw new UnimplementedOperationException();
    }

    public boolean isPlayerTimeRelative() {
        throw new UnimplementedOperationException();
    }

    public void resetPlayerTime() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerWeather(@NotNull WeatherType type) {
        throw new UnimplementedOperationException();
    }

    public WeatherType getPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    public void resetPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    public void giveExp(int amount) {
        this.exp += (float)amount / (float)this.getExpToLevel();
        this.setTotalExperience(this.expTotal + amount);
        while (this.exp < 0.0f) {
            float total = this.exp * (float)this.getExpToLevel();
            boolean shouldContinue = this.expLevel > 0;
            this.giveExpLevels(-1);
            if (!shouldContinue) continue;
            this.exp = 1.0f + total / (float)this.getExpToLevel();
        }
        while (this.exp >= 1.0f) {
            this.exp = (this.exp - 1.0f) * (float)this.getExpToLevel();
            this.giveExpLevels(1);
            this.exp /= (float)this.getExpToLevel();
        }
    }

    public void giveExpLevels(int amount) {
        int oldLevel = this.expLevel;
        this.expLevel += amount;
        if (this.expLevel < 0) {
            this.expLevel = 0;
            this.exp = 0.0f;
        }
        if (oldLevel != this.expLevel) {
            PlayerLevelChangeEvent event = new PlayerLevelChangeEvent((Player)this, oldLevel, this.expLevel);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    public float getExp() {
        return this.exp;
    }

    public void setExp(float exp) {
        if ((double)exp < 0.0 || (double)exp > 1.0) {
            throw new IllegalArgumentException("Experience progress must be between 0.0 and 1.0");
        }
        this.exp = exp;
    }

    public int getLevel() {
        return this.expLevel;
    }

    public void setLevel(int level) {
        this.expLevel = level;
    }

    public int getTotalExperience() {
        return this.expTotal;
    }

    public void setTotalExperience(int exp) {
        this.expTotal = Math.max(0, exp);
    }

    public float getExhaustion() {
        throw new UnimplementedOperationException();
    }

    public void setExhaustion(float value) {
        throw new UnimplementedOperationException();
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float value) {
        this.saturation = Math.min((float)this.getFoodLevel(), value);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    @Nullable
    public Location getBedSpawnLocation() {
        return this.bedSpawnLocation;
    }

    public void setBedSpawnLocation(@Nullable Location loc) {
        this.setBedSpawnLocation(loc, false);
    }

    public void setBedSpawnLocation(@Nullable Location loc, boolean force) {
        if (force || loc == null || loc.getBlock().getType().name().endsWith("_BED")) {
            this.bedSpawnLocation = loc;
        }
    }

    public boolean getAllowFlight() {
        throw new UnimplementedOperationException();
    }

    public void setAllowFlight(boolean flight) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void hidePlayer(@NotNull Player player) {
        this.hiddenPlayersDeprecated.add(player.getUniqueId());
    }

    public void hidePlayer(@NotNull Plugin plugin, @NotNull Player player) {
        this.hiddenPlayers.putIfAbsent(player.getUniqueId(), new HashSet());
        Set<Plugin> blockingPlugins = this.hiddenPlayers.get(player.getUniqueId());
        blockingPlugins.add(plugin);
    }

    @Deprecated
    public void showPlayer(@NotNull Player player) {
        this.hiddenPlayersDeprecated.remove(player.getUniqueId());
    }

    public void showPlayer(@NotNull Plugin plugin, @NotNull Player player) {
        if (this.hiddenPlayers.containsKey(player.getUniqueId())) {
            Set<Plugin> blockingPlugins = this.hiddenPlayers.get(player.getUniqueId());
            blockingPlugins.remove(plugin);
            if (blockingPlugins.isEmpty()) {
                this.hiddenPlayers.remove(player.getUniqueId());
            }
        }
    }

    public boolean canSee(@NotNull Player player) {
        return !this.hiddenPlayers.containsKey(player.getUniqueId()) && !this.hiddenPlayersDeprecated.contains(player.getUniqueId());
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean value) {
        this.flying = value;
    }

    @NotNull
    public PlayerToggleFlightEvent simulateToggleFlight(boolean fly) {
        PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this, fly);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.flying = event.isFlying();
        }
        return event;
    }

    public void setFlySpeed(float value) {
        throw new UnimplementedOperationException();
    }

    public void setWalkSpeed(float value) {
        throw new UnimplementedOperationException();
    }

    public float getFlySpeed() {
        throw new UnimplementedOperationException();
    }

    public float getWalkSpeed() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTexturePack(@NotNull String url) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, byte[] hash) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Scoreboard getScoreboard() {
        throw new UnimplementedOperationException();
    }

    public void setScoreboard(@NotNull Scoreboard scoreboard) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setHealth(double health) {
        if (health > 0.0) {
            this.health = Math.min(health, this.getMaxHealth());
            return;
        }
        this.health = 0.0;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.addAll(Arrays.asList(this.getInventory().getContents()));
        PlayerDeathEvent event = new PlayerDeathEvent((Player)this, drops, 0, this.getName() + " got killed");
        Bukkit.getPluginManager().callEvent((Event)event);
        this.closeInventory();
        if (!((Boolean)this.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY)).booleanValue()) {
            this.getInventory().clear();
        }
        this.setLevel(0);
        this.setExp(0.0f);
        this.setFoodLevel(0);
        this.alive = false;
    }

    public boolean isHealthScaled() {
        throw new UnimplementedOperationException();
    }

    public void setHealthScaled(boolean scale) {
        throw new UnimplementedOperationException();
    }

    public void setHealthScale(double scale) {
        throw new UnimplementedOperationException();
    }

    public double getHealthScale() {
        throw new UnimplementedOperationException();
    }

    public Entity getSpectatorTarget() {
        throw new UnimplementedOperationException();
    }

    public void setSpectatorTarget(Entity entity) {
        throw new UnimplementedOperationException();
    }

    public void sendTitle(String title, String subtitle) {
        throw new UnimplementedOperationException();
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        throw new UnimplementedOperationException();
    }

    public void resetTitle() {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, T data) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public AdvancementProgress getAdvancementProgress(@NotNull Advancement advancement) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getLocale() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSwimming() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSwimming(boolean swimming) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isRiptiding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPersistent() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPersistent(boolean persistent) {
        throw new UnimplementedOperationException();
    }

    public String getPlayerListHeader() {
        throw new UnimplementedOperationException();
    }

    public String getPlayerListFooter() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerListHeader(String header) {
        throw new UnimplementedOperationException();
    }

    public void setPlayerListFooter(String footer) {
        throw new UnimplementedOperationException();
    }

    public void setPlayerListHeaderFooter(String header, String footer) {
        throw new UnimplementedOperationException();
    }

    public void sendBlockChange(@NotNull Location loc, @NotNull BlockData block) {
        throw new UnimplementedOperationException();
    }

    public void updateCommands() {
        throw new UnimplementedOperationException();
    }

    public boolean discoverRecipe(@NotNull NamespacedKey recipe) {
        return this.discoverRecipes(Collections.singletonList(recipe)) != 0;
    }

    public int discoverRecipes(@NotNull Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    public boolean undiscoverRecipe(@NotNull NamespacedKey recipe) {
        return this.undiscoverRecipes(Collections.singletonList(recipe)) != 0;
    }

    public int undiscoverRecipes(@NotNull Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public BlockFace getFacing() {
        throw new UnimplementedOperationException();
    }

    public int getClientViewDistance() {
        throw new UnimplementedOperationException();
    }

    public boolean sleep(@NotNull Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public void wakeup(boolean setSpawnLocation) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Location getBedLocation() {
        throw new UnimplementedOperationException();
    }

    public <T> T getMemory(@NotNull MemoryKey<T> memoryKey) {
        throw new UnimplementedOperationException();
    }

    public <T> void setMemory(@NotNull MemoryKey<T> memoryKey, T memoryValue) {
        throw new UnimplementedOperationException();
    }

    public double getAbsorptionAmount() {
        throw new UnimplementedOperationException();
    }

    public void setAbsorptionAmount(double amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public Pose getPose() {
        throw new UnimplementedOperationException();
    }

    public void sendSignChange(@NotNull Location loc, String[] lines, @NotNull DyeColor dyeColor) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void openBook(@NotNull ItemStack book) {
        throw new UnimplementedOperationException();
    }

    public void attack(@NotNull Entity target) {
        throw new UnimplementedOperationException();
    }

    public void swingMainHand() {
        throw new UnimplementedOperationException();
    }

    public void swingOffHand() {
        throw new UnimplementedOperationException();
    }

    public void sendExperienceChange(float progress) {
        throw new UnimplementedOperationException();
    }

    public void sendExperienceChange(float progress, int level) {
        throw new UnimplementedOperationException();
    }

    public float getAttackCooldown() {
        throw new UnimplementedOperationException();
    }

    public boolean hasDiscoveredRecipe(@NotNull NamespacedKey recipe) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<NamespacedKey> getDiscoveredRecipes() {
        throw new UnimplementedOperationException();
    }

    public boolean dropItem(boolean dropAll) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<UUID> getCollidableExemptions() {
        throw new UnimplementedOperationException();
    }

    public void sendBlockDamage(@NotNull Location loc, float progress) {
        throw new UnimplementedOperationException();
    }

    public int getSaturatedRegenRate() {
        throw new UnimplementedOperationException();
    }

    public void setSaturatedRegenRate(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getUnsaturatedRegenRate() {
        throw new UnimplementedOperationException();
    }

    public void setUnsaturatedRegenRate(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getStarvationRate() {
        throw new UnimplementedOperationException();
    }

    public void setStarvationRate(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getPing() {
        return 0;
    }

    @Override
    public boolean teleport(@NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)cause, (String)"Cause cannot be null");
        PlayerTeleportEvent playerTeleportEvent = new PlayerTeleportEvent((Player)this, this.getLocation(), location, cause);
        Bukkit.getPluginManager().callEvent((Event)playerTeleportEvent);
        if (playerTeleportEvent.isCancelled()) {
            return false;
        }
        return super.teleport(playerTeleportEvent.getTo(), cause);
    }

    @NotNull
    public PlayerSpigotMock spigot() {
        return this.playerSpigotMock;
    }

    public class PlayerSpigotMock
    extends Player.Spigot {
        public void sendMessage(BaseComponent ... components) {
            for (BaseComponent component : components) {
                this.sendMessage(component);
            }
        }

        public void sendMessage(@NotNull ChatMessageType position, BaseComponent ... components) {
            for (BaseComponent component : components) {
                this.sendMessage(position, component);
            }
        }

        public void sendMessage(@NotNull BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, component);
        }

        public void sendMessage(@NotNull ChatMessageType position, @NotNull BaseComponent component) {
            PlayerMock.this.sendMessage(component.toPlainText());
        }
    }
}

