/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import java.util.Random;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class PlayerMockFactory {
    private final ServerMock server;
    private final Random random = new Random();
    private int currentNameIndex = 0;

    public PlayerMockFactory(@NotNull ServerMock server) {
        this.server = server;
    }

    @NotNull
    private String getUniqueRandomName() {
        String name = "Player" + this.currentNameIndex++;
        if (name.length() > 16) {
            throw new IllegalStateException("Maximum number of player names reached");
        }
        return name;
    }

    @NotNull
    public PlayerMock createRandomPlayer() {
        String name = this.getUniqueRandomName();
        UUID uuid = new UUID(this.random.nextLong(), this.random.nextLong());
        return new PlayerMock(this.server, name, uuid);
    }

    @NotNull
    public OfflinePlayerMock createRandomOfflinePlayer() {
        return new OfflinePlayerMock(this.getUniqueRandomName());
    }
}

