/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ChunkMock
implements Chunk {
    private final World world;
    private final int x;
    private final int z;
    private boolean loaded = true;
    private final PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();

    protected ChunkMock(World world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    @NotNull
    public Block getBlock(int x, int y, int z) {
        Validate.isTrue((x >= 0 && x <= 15 ? 1 : 0) != 0, (String)"x is out of range (expected 0-15)");
        Validate.isTrue((y >= 0 && y <= 255 ? 1 : 0) != 0, (String)"y is out of range (expected 0-255)");
        Validate.isTrue((z >= 0 && z <= 15 ? 1 : 0) != 0, (String)"z is out of range (expected 0-15)");
        return this.world.getBlockAt((this.x << 4) + x, y, (this.z << 4) + z);
    }

    @NotNull
    public ChunkSnapshot getChunkSnapshot() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ChunkSnapshot getChunkSnapshot(boolean includeMaxblocky, boolean includeBiome, boolean includeBiomeTempRain) {
        throw new UnimplementedOperationException();
    }

    public boolean isEntitiesLoaded() {
        throw new UnimplementedOperationException();
    }

    public Entity[] getEntities() {
        throw new UnimplementedOperationException();
    }

    public BlockState[] getTileEntities() {
        throw new UnimplementedOperationException();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean load(boolean generate) {
        return this.load();
    }

    public boolean load() {
        this.loaded = true;
        return true;
    }

    public boolean unload(boolean save) {
        return this.unload();
    }

    public boolean unload() {
        this.loaded = false;
        return true;
    }

    public boolean isSlimeChunk() {
        throw new UnimplementedOperationException();
    }

    public int hashCode() {
        return this.world.hashCode() + this.x + this.z;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChunkMock) {
            ChunkMock chunk = (ChunkMock)obj;
            return this.x == chunk.x && this.z == chunk.z && this.world.equals(chunk.world);
        }
        return false;
    }

    public boolean isForceLoaded() {
        throw new UnimplementedOperationException();
    }

    public void setForceLoaded(boolean forced) {
        throw new UnimplementedOperationException();
    }

    public boolean addPluginChunkTicket(@NotNull Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    public boolean removePluginChunkTicket(@NotNull Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Plugin> getPluginChunkTickets() {
        throw new UnimplementedOperationException();
    }

    public long getInhabitedTime() {
        throw new UnimplementedOperationException();
    }

    public void setInhabitedTime(long ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean contains(@NotNull BlockData block) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }
}

