/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.block.state.TileStateMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerMock
extends TileStateMock
implements Container {
    private final Inventory inventory;
    private String customName;
    private String lock = "";

    public ContainerMock(@NotNull Material material) {
        super(material);
        this.inventory = this.createInventory();
    }

    protected ContainerMock(@NotNull Block block) {
        super(block);
        this.inventory = this.createInventory();
    }

    protected ContainerMock(@NotNull ContainerMock state) {
        super(state);
        this.inventory = state.getInventory();
    }

    protected abstract InventoryMock createInventory();

    @Override
    public abstract BlockState getSnapshot();

    public boolean isLocked() {
        return !this.lock.isEmpty();
    }

    @NotNull
    public String getLock() {
        return this.lock;
    }

    public void setLock(String key) {
        this.lock = key == null ? "" : key;
    }

    @Nullable
    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Inventory getSnapshotInventory() {
        return ((InventoryMock)this.inventory).getSnapshot();
    }
}

