/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.boss;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BossBarMock
implements BossBar {
    private String title = null;
    private BarColor color = null;
    private BarStyle style = null;
    private HashSet<Player> players = new HashSet();
    private HashSet<BarFlag> barFlags = new HashSet();
    private boolean visible = true;
    private double progress = 1.0;

    public BossBarMock(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        this.title = title;
        this.color = color;
        this.style = style;
        for (BarFlag flag : flags) {
            this.addFlag(flag);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BarColor getColor() {
        return this.color;
    }

    public void setColor(BarColor color) {
        this.color = color;
    }

    public BarStyle getStyle() {
        return this.style;
    }

    public void setStyle(BarStyle style) {
        this.style = style;
    }

    public void removeFlag(BarFlag flag) {
        this.barFlags.remove(flag);
    }

    public void addFlag(BarFlag flag) {
        this.barFlags.add(flag);
    }

    public boolean hasFlag(BarFlag flag) {
        return this.barFlags.contains(flag);
    }

    public void setProgress(double progress) {
        if (progress > 1.0 || progress < 0.0) {
            throw new IllegalArgumentException("Progress must be between 0.0 and 1.0");
        }
        this.progress = progress;
    }

    public double getProgress() {
        return this.progress;
    }

    public void addPlayer(@NotNull Player player) {
        Validate.notNull((Object)player, (String)"Player cannot be null!");
        this.players.add(player);
    }

    public void removePlayer(@NotNull Player player) {
        Validate.notNull((Object)player, (String)"Player cannot be null!");
        this.players.remove(player);
    }

    public void removeAll() {
        this.players.clear();
    }

    public List<Player> getPlayers() {
        return new ArrayList<Player>(this.players);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Deprecated
    public void show() {
        this.setVisible(true);
    }

    @Deprecated
    public void hide() {
        this.setVisible(false);
    }
}

